/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.jetty;

import java.io.IOException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.passage.lbc.internal.api.FloatingState;
import org.eclipse.passage.lbc.internal.api.RawRequest;

final class JettyRequest
implements RawRequest {
    private final HttpServletRequest origin;
    private final FloatingState state;

    JettyRequest(HttpServletRequest origin, FloatingState state) {
        this.origin = origin;
        this.state = state;
    }

    public String parameter(String name) {
        return this.origin.getParameter(name);
    }

    public byte[] content() throws IOException {
        byte[] content = new byte[this.origin.getContentLength()];
        Throwable throwable = null;
        Object var3_4 = null;
        try (ServletInputStream stream = this.origin.getInputStream();){
            stream.read(content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return content;
    }

    public FloatingState state() {
        return this.state;
    }
}

