/*******************************************************************************
 * Copyright (c) 2020 ArSysOp
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * https://www.eclipse.org/legal/epl-2.0/.
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     ArSysOp - initial API and implementation
 *******************************************************************************/
package org.eclipse.passage.lbc.internal.base;

import java.util.function.Supplier;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/**
 * @since 1.0
 */
public abstract class Port implements Supplier<Integer> {

	private final int port;

	public Port(int port) {
		this.port = port;
	}

	@Override
	public final Integer get() {
		return port;
	}

	public static final class Custom extends Port {

		public Custom(int argument) {
			super(argument);
		}

	}

	public static final class Default extends Port {

		public Default() {
			super(8090);
		}

	}

	public static final class Of implements Supplier<Port> {

		private final Port port;
		private final Logger log = LogManager.getLogger(getClass());

		public Of(String value) {
			this.port = port(value);
		}

		@Override
		public Port get() {
			return port;
		}

		private Port port(String argument) {
			try {
				return new Custom(Integer.parseInt(argument));
			} catch (NumberFormatException e) {
				log.error("failed: ", e); //$NON-NLS-1$ ;
				return new Default();
			}
		}

	}

}
