/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.passage.lbc.internal.base.ReleaseReport;
import org.eclipse.passage.lic.internal.json.Json;

public final class ReleaseReportDeserializer
extends StdDeserializer<ReleaseReport> {
    private static final long serialVersionUID = -2780539387686503904L;

    protected ReleaseReportDeserializer(Class<ReleaseReport> type) {
        super(type);
    }

    public ReleaseReport deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode root = (JsonNode)p.getCodec().readTree(p);
        ArrayNode nodes = (ArrayNode)root.get("verdicts");
        List parsed = StreamSupport.stream(nodes.spliterator(), false).map(this::result).collect(Collectors.toList());
        return new ReleaseReport(parsed);
    }

    private ReleaseReport.ReleaseResult result(JsonNode node) {
        return new ReleaseReport.ReleaseResult(new Json.LicensingCondition().apply(node.get("condition")), node.get("result").booleanValue());
    }
}

