/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.edit.ui;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.passage.lic.emf.ecore.EditingDomainRegistry;
import org.eclipse.passage.lic.emf.edit.BaseDomainRegistry;
import org.eclipse.passage.lic.emf.edit.EditingDomainRegistryAccess;
import org.eclipse.passage.loc.edit.ui.DomainRegistryLabelProvider;
import org.eclipse.passage.loc.internal.edit.ui.i18n.EditUiMessages;
import org.eclipse.passage.loc.internal.workbench.LocDomainRegistryAccess;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DomainRegistryExplorerPart {
    private final LocDomainRegistryAccess access;
    private TableViewer viewer;

    @Inject
    public DomainRegistryExplorerPart(IEclipseContext context) {
        this.access = (LocDomainRegistryAccess)context.get(EditingDomainRegistryAccess.class);
    }

    @PostConstruct
    public void postConstruct(Composite parent, IEclipseContext context) {
        Composite area = new Composite(parent, 0);
        area.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        area.setLayout((Layout)new GridLayout(1, false));
        this.viewer = this.createRegistryTree(area);
        ESelectionService selectionService = (ESelectionService)context.get(ESelectionService.class);
        this.viewer.addSelectionChangedListener(e -> {
            ISelection selection = e.getSelection();
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection structured = (IStructuredSelection)selection;
                if (structured.size() == 1) {
                    selectionService.setSelection(structured.getFirstElement());
                } else {
                    selectionService.setSelection((Object)structured.toArray());
                }
            }
        });
        this.update(this.access.domainRegistryList());
    }

    private TableViewer createRegistryTree(Composite area) {
        TableViewer created = new TableViewer(area);
        created.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        created.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        created.setLabelProvider((IBaseLabelProvider)new DomainRegistryLabelProvider(this.access));
        this.createContextMenu(created.getControl());
        return created;
    }

    @Inject
    @Optional
    public void changed(@UIEventTopic(value="org/eclipse/passage/lic/*") Object unused) {
        this.update(this.access.domainRegistryList());
    }

    private void update(List<EditingDomainRegistry<?>> list) {
        if (this.viewer == null && this.viewer.getControl().isDisposed()) {
            return;
        }
        this.viewer.setInput(list.stream().filter(BaseDomainRegistry.class::isInstance).map(BaseDomainRegistry.class::cast).map(BaseDomainRegistry::getEditingDomain).map(EditingDomain::getResourceSet).flatMap(rs -> rs.getResources().stream()).filter(r -> r.getURI() != null).sorted((r1, r2) -> r1.getURI().toString().compareTo(r2.getURI().toString())).collect(Collectors.toList()));
    }

    private void createContextMenu(Control control) {
        MenuManager contextMenu = new MenuManager("#ViewerMenu");
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener(this::fillContextMenu);
        control.setMenu(contextMenu.createContextMenu(control));
    }

    private void fillContextMenu(IMenuManager contextMenu) {
        contextMenu.add((IContributionItem)new GroupMarker("additions"));
        contextMenu.add((IAction)new Action(EditUiMessages.DomainRegistryRemoveHandler_title){

            public void run() {
                Resource resource;
                URI uri;
                Object first = DomainRegistryExplorerPart.this.viewer.getStructuredSelection().getFirstElement();
                if (first instanceof Resource && (uri = (resource = (Resource)first).getURI()) != null) {
                    DomainRegistryExplorerPart.this.access.domainRegistryForExtension(uri.fileExtension()).filter(BaseDomainRegistry.class::isInstance).map(BaseDomainRegistry.class::cast).ifPresent(r -> DomainRegistryExplorerPart.this.unregister(r, uri, DomainRegistryExplorerPart.this.viewer.getControl().getShell()));
                }
            }
        });
    }

    private void unregister(BaseDomainRegistry<?> registry, URI uri, Shell shell) {
        String title = EditUiMessages.DomainRegistryRemoveHandler_title;
        String message = String.format(EditUiMessages.DomainRegistryRemoveHandler_mesage, uri.toFileString());
        if (MessageDialog.openConfirm((Shell)shell, (String)title, (String)message)) {
            registry.unregisterSource(uri.toFileString());
        }
    }
}

