/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.oshi;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class OshiHal {
    public static final String CONDITION_TYPE_HARDWARE = "hardware";
    private static Set<String> osProperties = new LinkedHashSet<String>();
    private static Set<String> systemProperties = new LinkedHashSet<String>();
    private static Set<String> baseboardProperties = new LinkedHashSet<String>();
    private static Set<String> firmwareProperties = new LinkedHashSet<String>();
    private static Set<String> cpuProperties = new LinkedHashSet<String>();
    private static Set<String> hwdiskProperties = new LinkedHashSet<String>();

    static {
        osProperties.add("os.manufacturer");
        osProperties.add("os.family");
        osProperties.add("os.version");
        osProperties.add("os.buildnumber");
        systemProperties.add("system.manufacturer");
        systemProperties.add("system.model");
        systemProperties.add("system.serialnumber");
        baseboardProperties.add("baseboard.manufacturer");
        baseboardProperties.add("baseboard.model");
        baseboardProperties.add("baseboard.version");
        baseboardProperties.add("baseboard.serialnumber");
        firmwareProperties.add("firmware.manufacturer");
        firmwareProperties.add("firmware.version");
        firmwareProperties.add("firmware.releasedate");
        firmwareProperties.add("firmware.name");
        firmwareProperties.add("firmware.description");
        cpuProperties.add("cpu.vendor");
        cpuProperties.add("cpu.family");
        cpuProperties.add("cpu.model");
        cpuProperties.add("cpu.name");
        cpuProperties.add("cpu.identifier");
        cpuProperties.add("cpu.processorid");
        hwdiskProperties.add("hwdisk.model");
        hwdiskProperties.add("hwdisk.name");
        hwdiskProperties.add("hwdisk.serial");
    }

    private OshiHal() {
    }

    public static void dumpHardwareInfo(OutputStream output, Map<String, String> values) throws IOException {
        OshiHal.dumpOperatingSystem(output, values);
        output.write(10);
        OshiHal.dumpComputerSystem(output, values);
        output.write(10);
        OshiHal.dumpCentralProcessor(output, values);
        output.write(10);
        OshiHal.dumpDiskStores(output, values);
    }

    public static void dumpOperatingSystem(OutputStream output, Map<String, String> values) throws IOException {
        OshiHal.dumpProperties(output, osProperties, values);
    }

    public static void dumpComputerSystem(OutputStream output, Map<String, String> values) throws IOException {
        OshiHal.dumpProperties(output, systemProperties, values);
        OshiHal.dumpProperties(output, baseboardProperties, values);
        OshiHal.dumpProperties(output, firmwareProperties, values);
    }

    public static void dumpCentralProcessor(OutputStream output, Map<String, String> values) throws IOException {
        OshiHal.dumpProperties(output, cpuProperties, values);
    }

    public static void dumpDiskStores(OutputStream output, Map<String, String> values) throws IOException {
        OshiHal.dumpProperties(output, hwdiskProperties, values);
    }

    private static void dumpProperties(OutputStream output, Iterable<String> keys, Map<String, String> values) throws IOException {
        for (String key : keys) {
            String value = values.get(key);
            if (value == null) continue;
            OshiHal.dumpProperty(output, key, value);
        }
    }

    private static void dumpProperty(OutputStream output, String name, String value) throws IOException {
        output.write(name.getBytes());
        output.write(61);
        output.write(value.getBytes());
        output.write(10);
    }
}

