/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.restrictions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import org.eclipse.passage.lic.api.LicensingConfiguration;
import org.eclipse.passage.lic.api.requirements.LicensingRequirement;
import org.eclipse.passage.lic.api.restrictions.RestrictionVerdict;
import org.eclipse.passage.lic.base.requirements.LicensingRequirements;
import org.eclipse.passage.lic.base.restrictions.BaseRestrictionVerdict;
import org.eclipse.passage.lic.base.restrictions.RestrictionVerdictComparator;

public class RestrictionVerdicts {
    public static final int CODE_NOT_AUTHORIZED = 401;
    public static final int CODE_CONFIGURATION_ERROR = 500;

    private RestrictionVerdicts() {
    }

    public static BaseRestrictionVerdict createConfigurationError(LicensingConfiguration configuration, String featureId) {
        LicensingRequirement requirement = LicensingRequirements.createConfigurationError(featureId, configuration);
        int code = 500;
        return RestrictionVerdicts.createError(configuration, requirement, code);
    }

    public static BaseRestrictionVerdict create(LicensingConfiguration configuration, LicensingRequirement requirement, int code) {
        String policy = "error";
        if (requirement != null) {
            policy = requirement.getRestrictionLevel();
        }
        return new BaseRestrictionVerdict(configuration, requirement, policy, code);
    }

    public static BaseRestrictionVerdict createError(LicensingConfiguration configuration, LicensingRequirement requirement, int code) {
        String policy = "error";
        return new BaseRestrictionVerdict(configuration, requirement, policy, code);
    }

    public static Iterable<BaseRestrictionVerdict> createConfigurationError(LicensingConfiguration configuration, LicensingRequirement requirement) {
        int code = 500;
        return Collections.singletonList(RestrictionVerdicts.createError(configuration, requirement, code));
    }

    public static RestrictionVerdict resolveLastVerdict(Iterable<RestrictionVerdict> verdicts) {
        if (verdicts == null) {
            return null;
        }
        ArrayList list = new ArrayList();
        verdicts.forEach(list::add);
        if (list.isEmpty()) {
            return null;
        }
        Collections.sort(list, new RestrictionVerdictComparator());
        RestrictionVerdict last = (RestrictionVerdict)list.get(list.size() - 1);
        return last;
    }

    public static RestrictionVerdict resolveLastVerdict(Iterable<RestrictionVerdict> verdicts, String featureId) {
        if (featureId == null) {
            return RestrictionVerdicts.resolveLastVerdict(verdicts);
        }
        if (verdicts == null) {
            return null;
        }
        ArrayList<RestrictionVerdict> candidates = new ArrayList<RestrictionVerdict>();
        for (RestrictionVerdict verdict : verdicts) {
            LicensingRequirement requirement = verdict.getLicensingRequirement();
            if (requirement == null || !Objects.equals(featureId, requirement.getFeatureIdentifier())) continue;
            candidates.add(verdict);
        }
        return RestrictionVerdicts.resolveLastVerdict(candidates);
    }

    public static boolean shouldPauseExecution(RestrictionVerdict verdict) {
        if (verdict == null) {
            return false;
        }
        String level = verdict.getRestrictionLevel();
        return "warn".equals(level) || "error".equals(level) || "fatal".equals(level);
    }

    public static boolean shouldInterruptExecution(RestrictionVerdict verdict) {
        if (verdict == null) {
            return false;
        }
        String level = verdict.getRestrictionLevel();
        return "error".equals(level) || "fatal".equals(level);
    }
}

