/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.workbench.wizards;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.passage.lic.emf.ecore.EditingDomainRegistry;
import org.eclipse.passage.lic.emf.edit.ClassifierInitializer;
import org.eclipse.passage.lic.emf.edit.EditingDomainRegistryAccess;
import org.eclipse.passage.loc.workbench.LocWokbench;
import org.eclipse.passage.loc.workbench.wizards.CreateFileWizardPage;
import org.eclipse.swt.widgets.Shell;

public class CreateFileWizard
extends Wizard {
    protected final EObject eObject;
    protected final ClassifierInitializer initializer;
    protected final EStructuralFeature identifierFeature;
    protected final EStructuralFeature nameFeature;
    private final IEclipseContext eclipseContext;
    private final EditingDomainRegistry<?> domainRegistry;
    private final String perspectiveId;
    private CreateFileWizardPage filePage;

    public CreateFileWizard(IEclipseContext context, String domain, String perspectiveId) {
        this.eclipseContext = context;
        this.perspectiveId = perspectiveId;
        EditingDomainRegistryAccess registryAccess = (EditingDomainRegistryAccess)context.get(EditingDomainRegistryAccess.class);
        EditingDomainRegistry registry = registryAccess.getDomainRegistry(domain);
        EClass eClass = registry.getContentClassifier();
        this.domainRegistry = registry;
        this.eObject = eClass.getEPackage().getEFactoryInstance().create(eClass);
        this.identifierFeature = registry.getContentIdentifierAttribute();
        this.nameFeature = registry.getContentNameAttribute();
        this.initializer = registryAccess.getClassifierInitializer(domain);
    }

    public void addPages() {
        this.filePage = this.createFilePage(this.domainRegistry);
        this.addPage((IWizardPage)this.filePage);
    }

    protected CreateFileWizardPage createFilePage(EditingDomainRegistry<?> registry) {
        return new CreateFileWizardPage(CreateFileWizardPage.class.getName(), this.eObject, registry.getFileExtension(), this.initializer, this.identifierFeature != null, this.nameFeature != null);
    }

    public boolean performFinish() {
        URI fileURI;
        block5: {
            try {
                fileURI = this.filePage.getFileURI();
                File file = new File(fileURI.toFileString());
                if (!file.exists()) break block5;
                String absolutePath = file.getAbsolutePath();
                String message = String.format("The file \"%s\" already exists.  Do you want to replace the existing file?", absolutePath);
                if (MessageDialog.openQuestion((Shell)this.getShell(), (String)"Question", (String)message)) break block5;
                this.filePage.selectFileField();
                return false;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
        if (this.identifierFeature != null) {
            this.eObject.eSet(this.identifierFeature, (Object)this.filePage.getIdentifier());
        }
        if (this.nameFeature != null) {
            this.eObject.eSet(this.nameFeature, (Object)this.filePage.getName());
        }
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor progressMonitor) {
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                Resource resource = resourceSet.createResource(fileURI);
                resource.getContents().add((Object)CreateFileWizard.this.eObject);
                LocWokbench.save(resource);
                LocWokbench.switchPerspective(CreateFileWizard.this.eclipseContext, CreateFileWizard.this.perspectiveId);
                CreateFileWizard.this.domainRegistry.registerSource(fileURI.toFileString());
            }
        };
        this.getContainer().run(false, false, operation);
        return true;
    }
}

