/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.workbench.emfforms.dialogs;

import java.util.Set;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecp.ui.view.ECPRendererException;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTView;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTViewRenderer;
import org.eclipse.emf.ecp.view.spi.model.VDiagnostic;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emf.ecp.view.spi.model.VViewModelLoadingProperties;
import org.eclipse.emf.ecp.view.spi.model.VViewModelProperties;
import org.eclipse.emf.ecp.view.spi.validation.ValidationService;
import org.eclipse.emf.ecp.view.spi.validation.ViewValidationListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CreateFormDialog
extends TitleAreaDialog {
    private final String shellText;
    private final String dialogTitle;
    private final EObject createdObject;
    private ECPSWTView ecpswtView;

    public CreateFormDialog(Shell parent, String shellText, String dialogTitle, EObject created) {
        super(parent);
        this.shellText = shellText;
        this.dialogTitle = dialogTitle;
        this.createdObject = created;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.shellText);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.dialogTitle);
        ScrolledComposite wrapper = new ScrolledComposite(parent, 512);
        wrapper.setExpandHorizontal(true);
        wrapper.setExpandVertical(true);
        FillLayout wrapperLayout = new FillLayout();
        wrapperLayout.marginHeight = 10;
        wrapperLayout.marginWidth = 10;
        wrapper.setLayout((Layout)wrapperLayout);
        wrapper.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite emfFormsParent = new Composite((Composite)wrapper, 0);
        wrapper.setContent((Control)emfFormsParent);
        emfFormsParent.setLayout((Layout)new GridLayout());
        try {
            VViewModelLoadingProperties properties = VViewFactory.eINSTANCE.createViewModelLoadingProperties();
            properties.addInheritableProperty("useOnModifyDatabinding", (Object)"true");
            this.ecpswtView = ECPSWTViewRenderer.INSTANCE.render(emfFormsParent, this.createdObject, (VViewModelProperties)properties);
            ValidationService validationService = (ValidationService)this.ecpswtView.getViewModelContext().getService(ValidationService.class);
            validationService.registerValidationListener(new ViewValidationListener(){

                public void onNewValidation(Set<Diagnostic> validationResults) {
                    CreateFormDialog.this.updateOKButtonEnablement();
                }
            });
        }
        catch (ECPRendererException eCPRendererException) {
            // empty catch block
        }
        wrapper.setMinSize(wrapper.computeSize(-1, -1));
        return parent;
    }

    protected void okPressed() {
        this.getParentShell().forceFocus();
        Diagnostic result = Diagnostician.INSTANCE.validate(this.createdObject);
        if (result.getSeverity() == 0) {
            super.okPressed();
        } else {
            int errorCount = result.getChildren().size();
            StringBuilder sb = new StringBuilder();
            sb.append(errorCount);
            sb.append(" ");
            sb.append(errorCount == 1 ? "error" : "errors");
            sb.append(" occured while analyzing your inputs. The following errors were found:\r\n");
            int messageCount = 1;
            for (Diagnostic d : result.getChildren()) {
                sb.append("\r\n");
                sb.append(messageCount++);
                sb.append(". ");
                sb.append(d.getMessage());
            }
            String errorMessage = sb.toString();
            MessageDialog.open((int)1, (Shell)this.getParentShell(), (String)"Error", (String)errorMessage, (int)0);
        }
    }

    public EObject getCreatedInstance() {
        return this.createdObject;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.updateOKButtonEnablement();
    }

    private void updateOKButtonEnablement() {
        VDiagnostic diagnostic = this.ecpswtView.getViewModelContext().getViewModel().getDiagnostic();
        boolean isError = diagnostic.getHighestSeverity() >= 4;
        Button button = this.getButton(0);
        if (isError) {
            this.setErrorMessage(diagnostic.getMessage());
            if (button != null) {
                button.setEnabled(false);
            }
        } else {
            this.setErrorMessage(null);
            if (button != null) {
                button.setEnabled(true);
            }
        }
    }
}

