/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.users.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.passage.lic.emf.ecore.DomainContentAdapter;
import org.eclipse.passage.lic.emf.ecore.EditingDomainRegistry;
import org.eclipse.passage.lic.emf.edit.BaseDomainRegistry;
import org.eclipse.passage.lic.emf.edit.ComposedAdapterFactoryProvider;
import org.eclipse.passage.lic.users.UserDescriptor;
import org.eclipse.passage.lic.users.UserOriginDescriptor;
import org.eclipse.passage.lic.users.model.meta.UsersPackage;
import org.eclipse.passage.lic.users.registry.UserRegistry;
import org.eclipse.passage.loc.internal.users.core.UsersDomainRegistryTracker;
import org.eclipse.passage.loc.runtime.OperatorEvents;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.EventAdmin;

@Component(property={"org.eclipse.passage.lic.emf.edit.domain.name=users", "org.eclipse.passage.lic.emf.edit.file.extension=users_xmi"})
public class UserDomainRegistry
extends BaseDomainRegistry<UserOriginDescriptor>
implements UserRegistry,
EditingDomainRegistry<UserOriginDescriptor> {
    private final Map<String, UserOriginDescriptor> userOriginIndex = new HashMap<String, UserOriginDescriptor>();
    private final Map<String, UserDescriptor> userIndex = new HashMap<String, UserDescriptor>();

    @Reference
    public void bindEventAdmin(EventAdmin admin) {
        super.bindEventAdmin(admin);
    }

    public void unbindEventAdmin(EventAdmin admin) {
        super.unbindEventAdmin(admin);
    }

    @Reference
    public void bindFactoryProvider(ComposedAdapterFactoryProvider factoryProvider) {
        super.bindFactoryProvider(factoryProvider);
    }

    public void unbindFactoryProvider(ComposedAdapterFactoryProvider factoryProvider) {
        super.unbindFactoryProvider(factoryProvider);
    }

    @Activate
    public void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    @Deactivate
    public void deactivate(Map<String, Object> properties) {
        this.userIndex.clear();
        this.userOriginIndex.clear();
        super.deactivate(properties);
    }

    public String getFileExtension() {
        return "users_xmi";
    }

    public Class<UserOriginDescriptor> getContentClass() {
        return UserOriginDescriptor.class;
    }

    public String resolveIdentifier(UserOriginDescriptor content) {
        return content.getIdentifier();
    }

    public Iterable<UserOriginDescriptor> getUserOrigins() {
        return new ArrayList<UserOriginDescriptor>(this.userOriginIndex.values());
    }

    public UserOriginDescriptor getUserOrigin(String identifier) {
        return this.userOriginIndex.get(identifier);
    }

    public Iterable<? extends UserDescriptor> getUsers() {
        return new ArrayList<UserDescriptor>(this.userIndex.values());
    }

    public Iterable<? extends UserDescriptor> getUsers(String userOriginId) {
        UserOriginDescriptor userOrigin = this.userOriginIndex.get(userOriginId);
        if (userOrigin == null) {
            return Collections.emptyList();
        }
        return userOrigin.getUsers();
    }

    public UserDescriptor getUser(String identifier) {
        return this.userIndex.get(identifier);
    }

    protected DomainContentAdapter<UserOriginDescriptor, UserDomainRegistry> createContentAdapter() {
        return new UsersDomainRegistryTracker(this);
    }

    public void registerUserOrigin(UserOriginDescriptor userOrigin) {
        String identifier = userOrigin.getIdentifier();
        UserOriginDescriptor existing = this.userOriginIndex.put(identifier, userOrigin);
        this.eventAdmin.postEvent(OperatorEvents.create((String)"org/eclipse/passage/lic/users/registry/UserOrigin/create", (Object)userOrigin));
        userOrigin.getUsers().forEach(u -> this.registerUser((UserDescriptor)u));
    }

    public void registerUser(UserDescriptor user) {
        String identifier = user.getEmail();
        UserDescriptor existing = this.userIndex.put(identifier, user);
        this.eventAdmin.postEvent(OperatorEvents.create((String)"org/eclipse/passage/lic/users/registry/User/create", (Object)user));
    }

    public void unregisterUserOrigin(String userOriginId) {
        UserOriginDescriptor removed = this.userOriginIndex.remove(userOriginId);
        if (removed != null) {
            this.eventAdmin.postEvent(OperatorEvents.create((String)"org/eclipse/passage/lic/users/registry/UserOrigin/delete", (Object)removed));
            removed.getUsers().forEach(u -> this.unregisterUser(u.getEmail()));
        }
    }

    public void unregisterUser(String userId) {
        UserDescriptor removed = this.userIndex.remove(userId);
        if (removed != null) {
            this.eventAdmin.postEvent(OperatorEvents.create((String)"org/eclipse/passage/lic/users/registry/User/delete", (Object)removed));
        }
    }

    public EClass getContentClassifier() {
        return UsersPackage.eINSTANCE.getUserOrigin();
    }

    public EStructuralFeature getContentIdentifierAttribute() {
        return UsersPackage.eINSTANCE.getUserOrigin_Identifier();
    }

    public EStructuralFeature getContentNameAttribute() {
        return UsersPackage.eINSTANCE.getUserOrigin_Name();
    }

    public void registerContent(UserOriginDescriptor content) {
        this.registerUserOrigin(content);
    }

    public void unregisterContent(String identifier) {
        this.unregisterUserOrigin(identifier);
    }
}

