/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.edit.ui;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.passage.lic.features.FeatureSetDescriptor;
import org.eclipse.passage.lic.features.registry.FeatureRegistry;
import org.eclipse.passage.lic.licenses.LicensePackDescriptor;
import org.eclipse.passage.lic.licenses.registry.LicenseRegistry;
import org.eclipse.passage.lic.products.ProductLineDescriptor;
import org.eclipse.passage.lic.products.registry.ProductRegistry;
import org.eclipse.passage.lic.users.UserOriginDescriptor;
import org.eclipse.passage.lic.users.registry.UserRegistry;
import org.eclipse.passage.loc.edit.ui.DomainRegistryContentProvider;
import org.eclipse.passage.loc.edit.ui.DomainRegistryLabelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class DomainRegistryExplorerPart {
    private List<Object> registries = new ArrayList<Object>();
    private TreeViewer treeViewer;

    @Inject
    public DomainRegistryExplorerPart(IEclipseContext context) {
        this.registries.add(context.get(FeatureRegistry.class));
        this.registries.add(context.get(ProductRegistry.class));
        this.registries.add(context.get(UserRegistry.class));
        this.registries.add(context.get(LicenseRegistry.class));
    }

    @PostConstruct
    public void postConstruct(Composite parent, IEclipseContext context) {
        Composite area = new Composite(parent, 0);
        area.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        area.setLayout((Layout)new GridLayout(1, false));
        this.treeViewer = this.createRegistryTree(area);
        ESelectionService selectionService = (ESelectionService)context.get(ESelectionService.class);
        this.treeViewer.addSelectionChangedListener(e -> {
            ISelection selection = e.getSelection();
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection structured = (IStructuredSelection)selection;
                if (structured.size() == 1) {
                    selectionService.setSelection(structured.getFirstElement());
                } else {
                    selectionService.setSelection((Object)structured.toArray());
                }
            }
        });
        this.treeViewer.setInput(this.registries);
    }

    private TreeViewer createRegistryTree(Composite area) {
        TreeViewer treeView = new TreeViewer(area);
        treeView.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        treeView.setAutoExpandLevel(2);
        treeView.setContentProvider((IContentProvider)new DomainRegistryContentProvider());
        treeView.setLabelProvider((IBaseLabelProvider)new DomainRegistryLabelProvider());
        return treeView;
    }

    @Inject
    @Optional
    public void createFeatureSet(@UIEventTopic(value="org/eclipse/passage/lic/features/registry/FeatureSet/create") FeatureSetDescriptor descriptor) {
        this.treeViewer.refresh();
    }

    @Inject
    @Optional
    public void deleteFeatureSet(@UIEventTopic(value="org/eclipse/passage/lic/features/registry/FeatureSet/delete") FeatureSetDescriptor descriptor) {
        this.treeViewer.refresh();
    }

    @Inject
    @Optional
    public void updateFeatureSet(@UIEventTopic(value="org/eclipse/passage/lic/features/registry/FeatureSet/update") FeatureSetDescriptor descriptor) {
        this.treeViewer.refresh();
    }

    @Inject
    @Optional
    public void createProductLine(@UIEventTopic(value="org/eclipse/passage/lic/products/registry/ProductLine/create") ProductLineDescriptor descriptor) {
        this.treeViewer.refresh();
    }

    @Inject
    @Optional
    public void deleteProductLine(@UIEventTopic(value="org/eclipse/passage/lic/products/registry/ProductLine/delete") ProductLineDescriptor descriptor) {
        this.treeViewer.refresh();
    }

    @Inject
    @Optional
    public void updatedProductLine(@UIEventTopic(value="org/eclipse/passage/lic/products/registry/ProductLine/update") ProductLineDescriptor descriptor) {
        this.treeViewer.refresh();
    }

    @Inject
    @Optional
    public void createUserOrigin(@UIEventTopic(value="org/eclipse/passage/lic/users/registry/UserOrigin/create") UserOriginDescriptor descriptor) {
        this.treeViewer.refresh();
    }

    @Inject
    @Optional
    public void deleteUserOrigin(@UIEventTopic(value="org/eclipse/passage/lic/users/registry/UserOrigin/delete") UserOriginDescriptor descriptor) {
        this.treeViewer.refresh();
    }

    @Inject
    @Optional
    public void updateUserOrigin(@UIEventTopic(value="org/eclipse/passage/lic/users/registry/UserOrigin/update") UserOriginDescriptor descriptor) {
        this.treeViewer.refresh();
    }

    @Inject
    @Optional
    public void createLicensePack(@UIEventTopic(value="org/eclipse/passage/lic/licenses/registry/LicensePack/create") LicensePackDescriptor descriptor) {
        this.treeViewer.refresh();
    }

    @Inject
    @Optional
    public void deleteLicensePack(@UIEventTopic(value="org/eclipse/passage/lic/licenses/registry/LicensePack/delete") LicensePackDescriptor descriptor) {
        this.treeViewer.refresh();
    }

    @Inject
    @Optional
    public void updateLicensePack(@UIEventTopic(value="org/eclipse/passage/lic/licenses/registry/LicensePack/update") LicensePackDescriptor descriptor) {
        this.treeViewer.refresh();
    }
}

