/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jface.dialogs;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.passage.lic.jface.dialogs.LicensingRegistryPage;
import org.eclipse.passage.lic.jface.resource.LicensingColors;
import org.eclipse.passage.lic.jface.resource.LicensingImages;
import org.eclipse.passage.lic.jface.viewers.RestrictionRepresenters;
import org.eclipse.passage.lic.runtime.restrictions.RestrictionExecutorRegistry;
import org.eclipse.passage.lic.runtime.restrictions.RestrictionLevelDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class RestrictionLevelPage
extends LicensingRegistryPage<RestrictionExecutorRegistry> {
    private Map<String, RGB> restrictionColors = new HashMap<String, RGB>();

    public RestrictionLevelPage() {
        super(RestrictionExecutorRegistry.class);
    }

    @Override
    protected void createContent(Composite parent, RestrictionExecutorRegistry registry) {
        Iterable restrictionLevels = registry.getRestrictionLevels();
        GridDataFactory groupData = GridDataFactory.fillDefaults().align(4, 1).grab(true, false);
        for (RestrictionLevelDescriptor descriptor : restrictionLevels) {
            Group group = new Group(parent, 0);
            String identifier = descriptor.getIdentifier();
            group.setText(descriptor.getName());
            group.setData((Object)descriptor);
            group.setLayout((Layout)new GridLayout(2, false));
            group.setLayoutData((Object)groupData.create());
            Label image = new Label((Composite)group, 0);
            String imageKey = RestrictionRepresenters.resolveImageKey(identifier);
            image.setImage(LicensingImages.getImage(imageKey));
            image.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            final Label color = new Label((Composite)group, 0);
            final String colorKey = RestrictionRepresenters.resolveColorKey(identifier);
            color.setBackground(LicensingColors.getColorRegistry().get(colorKey));
            color.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            Button selectColor = new Button((Composite)group, 8);
            selectColor.setText("Select");
            selectColor.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
            selectColor.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ColorDialog dialog = new ColorDialog(Display.getDefault().getActiveShell());
                    RGB rgbSelected = dialog.open();
                    if (rgbSelected != null) {
                        RestrictionLevelPage.this.restrictionColors.put(colorKey, rgbSelected);
                        color.setBackground(new Color((Device)Display.getDefault(), rgbSelected));
                    }
                }
            });
            Label description = new Label((Composite)group, 64);
            description.setText(descriptor.getDescription());
        }
    }

    @Override
    protected String getConfigurationErrorMessage() {
        return "Restriction levels definitions are not available.\nPlease check the product configuration";
    }

    @Override
    protected IStatus accept() {
        return LicensingColors.acceptColors(this.restrictionColors);
    }
}

