/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.conditions;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.passage.lic.base.conditions.ConditionMiners;
import org.eclipse.passage.lic.base.io.LicensingPaths;
import org.eclipse.passage.lic.base.io.NullKeyKeeper;
import org.eclipse.passage.lic.base.io.NullStreamCodec;
import org.eclipse.passage.lic.runtime.LicensingConfiguration;
import org.eclipse.passage.lic.runtime.LicensingException;
import org.eclipse.passage.lic.runtime.LicensingReporter;
import org.eclipse.passage.lic.runtime.LicensingResult;
import org.eclipse.passage.lic.runtime.conditions.ConditionMiner;
import org.eclipse.passage.lic.runtime.conditions.ConditionTransport;
import org.eclipse.passage.lic.runtime.conditions.LicensingCondition;
import org.eclipse.passage.lic.runtime.io.KeyKeeper;
import org.eclipse.passage.lic.runtime.io.KeyKeeperRegistry;
import org.eclipse.passage.lic.runtime.io.StreamCodec;
import org.eclipse.passage.lic.runtime.io.StreamCodecRegistry;

public abstract class BasePathConditionMiner
implements ConditionMiner {
    private LicensingReporter licensingReporter;
    private KeyKeeperRegistry keyKeeperRegistry;
    private StreamCodecRegistry streamCodecRegistry;
    private final Map<String, ConditionTransport> conditionTransports = new HashMap<String, ConditionTransport>();

    protected void bindLicensingReporter(LicensingReporter reporter) {
        this.licensingReporter = reporter;
    }

    protected void unbindLicensingReporter(LicensingReporter reporter) {
        if (this.licensingReporter == reporter) {
            this.licensingReporter = null;
        }
    }

    protected void bindKeyKeeperRegistry(KeyKeeperRegistry registry) {
        this.keyKeeperRegistry = registry;
    }

    protected void unbindKeyKeeperRegistry(KeyKeeperRegistry registry) {
        if (this.keyKeeperRegistry == registry) {
            this.keyKeeperRegistry = null;
        }
    }

    protected void bindStreamCodecRegistry(StreamCodecRegistry registry) {
        this.streamCodecRegistry = registry;
    }

    protected void unbindStreamCodecRegistry(StreamCodecRegistry registry) {
        if (this.streamCodecRegistry == registry) {
            this.streamCodecRegistry = null;
        }
    }

    protected void bindConditionTransport(ConditionTransport transport, Map<String, Object> properties) {
        String contentType = String.valueOf(properties.get("licensing.content.type"));
        this.conditionTransports.put(contentType, transport);
    }

    protected void unbindConditionTransport(ConditionTransport transport, Map<String, Object> properties) {
        String contentType = String.valueOf(properties.get("licensing.content.type"));
        ConditionTransport current = this.conditionTransports.get(contentType);
        if (transport == current) {
            this.conditionTransports.remove(contentType);
        }
    }

    public final Iterable<LicensingCondition> extractLicensingConditions(LicensingConfiguration configuration) {
        String source = this.getClass().getName();
        ArrayList<LicensingCondition> mined = new ArrayList<LicensingCondition>();
        if (configuration == null) {
            return mined;
        }
        ConditionTransport transport = this.conditionTransports.get("application/xml");
        if (transport == null) {
            return mined;
        }
        Path from = this.getBasePath();
        Path configurationPath = LicensingPaths.resolveConfigurationPath(from, configuration);
        if (!Files.isDirectory(configurationPath, new LinkOption[0])) {
            return mined;
        }
        KeyKeeper keyKeeper = this.keyKeeperRegistry.getKeyKeeper(configuration);
        StreamCodec streamCodec = this.streamCodecRegistry.getStreamCodec(configuration);
        String extension = NullKeyKeeper.INSTANCE == keyKeeper && NullStreamCodec.INSTANCE == streamCodec ? LicensingPaths.EXTENSION_LICENSE_DECRYPTED : LicensingPaths.EXTENSION_LICENSE_ENCRYPTED;
        try {
            List<String> packs = ConditionMiners.collectPacks(configurationPath, extension);
            LicensingResult result = ConditionMiners.mine(source, configuration, mined, keyKeeper, streamCodec, transport, packs);
            this.licensingReporter.logResult(result);
        }
        catch (LicensingException e) {
            this.licensingReporter.logResult(e.getResult());
        }
        return mined;
    }

    protected abstract Path getBasePath();
}

