/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.IThreadListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.dialogs.EventLoopProgressMonitor;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public abstract class WorkspaceModifyOperation
implements IRunnableWithProgress,
IThreadListener {
    private final ISchedulingRule rule;

    protected WorkspaceModifyOperation() {
        this((ISchedulingRule)IDEWorkbenchPlugin.getPluginWorkspace().getRoot());
    }

    protected WorkspaceModifyOperation(ISchedulingRule rule) {
        this.rule = rule;
    }

    protected abstract void execute(IProgressMonitor var1) throws CoreException, InvocationTargetException, InterruptedException;

    public final synchronized void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        AtomicReference rethrownInvocationTargetException = new AtomicReference();
        AtomicReference rethrownInterruptedException = new AtomicReference();
        try {
            Display display;
            IWorkspaceRunnable workspaceRunnable = pm -> {
                try {
                    this.execute(pm);
                }
                catch (InvocationTargetException e1) {
                    rethrownInvocationTargetException.set(e1);
                }
                catch (InterruptedException e2) {
                    rethrownInterruptedException.set(e2);
                }
            };
            if (monitor != null && PlatformUI.isWorkbenchRunning() && !PlatformUI.getWorkbench().isStarting() && !(display = PlatformUI.getWorkbench().getDisplay()).isDisposed() && display.getThread() == Thread.currentThread()) {
                monitor = new EventLoopProgressMonitor(monitor);
            }
            IDEWorkbenchPlugin.getPluginWorkspace().run(workspaceRunnable, this.rule, 0, monitor);
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
        catch (OperationCanceledException e) {
            InterruptedException interruptedException = new InterruptedException(e.getMessage());
            interruptedException.initCause(e);
            throw interruptedException;
        }
        if (rethrownInvocationTargetException.get() != null) {
            throw (InvocationTargetException)rethrownInvocationTargetException.get();
        }
        if (rethrownInterruptedException.get() != null) {
            throw (InterruptedException)rethrownInterruptedException.get();
        }
    }

    public void threadChange(Thread thread) {
        if (this.rule == null) {
            return;
        }
        Job currentJob = Job.getJobManager().currentJob();
        if (currentJob == null) {
            return;
        }
        ISchedulingRule currentRule = currentJob.getRule();
        if (currentRule == null) {
            return;
        }
        throw new IllegalStateException("Cannot fork a thread from a thread owning a rule");
    }

    public ISchedulingRule getRule() {
        return this.rule;
    }
}

