/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.about;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.about.IInstallationPageContainer;
import org.eclipse.ui.about.InstallationPage;
import org.eclipse.ui.internal.ConfigurationInfo;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.services.IServiceLocator;
import org.osgi.framework.FrameworkUtil;

public class InstallationDialog
extends TrayDialog
implements IInstallationPageContainer {
    protected static final String ID = "ID";
    private static final String DIALOG_SETTINGS_SECTION = "InstallationDialogSettings";
    private static final int TAB_WIDTH_IN_DLUS = 440;
    private static final int TAB_HEIGHT_IN_DLUS = 320;
    private static String lastSelectedTabId = null;
    private CTabFolder folder;
    IServiceLocator serviceLocator;
    private ButtonManager buttonManager;
    private final Map<InstallationPage, String> pageToId = new HashMap<InstallationPage, String>();
    private Dialog modalParent;

    public InstallationDialog(Shell parentShell, IServiceLocator locator) {
        super(parentShell);
        this.serviceLocator = locator;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        String productName = "";
        IProduct product = Platform.getProduct();
        if (product != null && product.getName() != null) {
            productName = product.getName();
        }
        newShell.setText(NLS.bind((String)WorkbenchMessages.InstallationDialog_ShellTitle, (Object)productName));
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.folder = new CTabFolder(composite, 0);
        this.configureFolder();
        this.createFolderItems(this.folder);
        GridData folderData = new GridData(4, 4, true, true);
        folderData.widthHint = this.convertHorizontalDLUsToPixels(440);
        folderData.heightHint = this.convertVerticalDLUsToPixels(320);
        this.folder.setLayoutData((Object)folderData);
        this.folder.addSelectionListener(this.createFolderSelectionListener());
        this.folder.addDisposeListener(e -> this.releaseContributions());
        return composite;
    }

    protected void createFolderItems(CTabFolder folder) {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = ConfigurationInfo.getSortedExtensions(this.loadElements());
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            CTabItem item = new CTabItem(folder, 0);
            item.setText(element.getAttribute("name"));
            item.setData((Object)element);
            item.setData(ID, (Object)element.getAttribute("id"));
            Composite control = new Composite((Composite)folder, 0);
            control.setLayout((Layout)new GridLayout());
            item.setControl((Control)control);
            ++n2;
        }
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        boolean selected = false;
        if (this.folder.getItemCount() > 0) {
            if (lastSelectedTabId != null) {
                CTabItem[] items = this.folder.getItems();
                int i = 0;
                while (i < items.length) {
                    if (items[i].getData(ID).equals(lastSelectedTabId)) {
                        this.folder.setSelection(i);
                        this.tabSelected(items[i]);
                        selected = true;
                        break;
                    }
                    ++i;
                }
            }
            if (!selected) {
                this.tabSelected(this.folder.getItem(0));
            }
        }
        Dialog.applyDialogFont((Control)this.folder);
        return control;
    }

    private SelectionListener createFolderSelectionListener() {
        return SelectionListener.widgetSelectedAdapter(e -> this.tabSelected((CTabItem)e.item));
    }

    private void tabSelected(CTabItem item) {
        if (item.getData() instanceof IConfigurationElement) {
            IConfigurationElement element = (IConfigurationElement)item.getData();
            Composite pageComposite = (Composite)item.getControl();
            try {
                InstallationPage page = (InstallationPage)((Object)element.createExecutableExtension("class"));
                page.createControl(pageComposite);
                Dialog.applyDialogFont((Control)pageComposite);
                page.setPageContainer(this);
                this.pageToId.put(page, element.getAttribute("id"));
                this.createButtons(page);
                item.setData((Object)page);
                item.addDisposeListener(e -> page.dispose());
                pageComposite.layout(true, true);
            }
            catch (CoreException e1) {
                Label label = new Label(pageComposite, 0);
                label.setText(e1.getMessage());
                item.setData(null);
            }
        }
        String id = (String)item.getData(ID);
        this.rememberSelectedTab(id);
        this.buttonManager.update(id);
        Button button = this.createButton(this.buttonManager.getParent(), 12, IDialogConstants.CLOSE_LABEL, true);
        GridData gd = (GridData)button.getLayoutData();
        gd.horizontalAlignment = 1;
        gd.horizontalIndent = this.convertHorizontalDLUsToPixels(61) / 2;
        this.getButtonBar().getParent().layout(true, true);
    }

    protected void createButtons(InstallationPage page) {
        page.createPageButtons(this.buttonManager.getParent());
        Dialog.applyDialogFont((Control)this.buttonManager.getParent());
    }

    private void rememberSelectedTab(String pageId) {
        lastSelectedTabId = pageId;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridLayout layout = (GridLayout)parent.getLayout();
        layout.makeColumnsEqualWidth = false;
        this.buttonManager = new ButtonManager(parent);
    }

    private void configureFolder() {
    }

    private IConfigurationElement[] loadElements() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", "installationPages");
        return point.getConfigurationElements();
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = PlatformUI.getDialogSettingsProvider(FrameworkUtil.getBundle(InstallationDialog.class)).getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS_SECTION);
        if (section == null) {
            section = settings.addNewSection(DIALOG_SETTINGS_SECTION);
        }
        return section;
    }

    protected void releaseContributions() {
        this.buttonManager.clear();
    }

    @Override
    public void closeModalContainers() {
        this.close();
        if (this.modalParent != null) {
            this.modalParent.close();
        }
    }

    protected void buttonPressed(int buttonId) {
        if (12 == buttonId) {
            this.okPressed();
        }
    }

    @Override
    public void registerPageButton(InstallationPage page, Button button) {
        this.buttonManager.addPageButton(this.pageToId(page), button);
    }

    protected String pageToId(InstallationPage page) {
        String pageId = this.pageToId.get((Object)page);
        Assert.isLegal((pageId != null ? 1 : 0) != 0);
        return pageId;
    }

    public void setModalParent(Dialog parent) {
        this.modalParent = parent;
    }

    class ButtonManager {
        private final Composite composite;
        HashMap<String, List<Button>> buttonMap = new HashMap();

        public ButtonManager(Composite composite) {
            this.composite = composite;
        }

        public Composite getParent() {
            return this.composite;
        }

        public void update(String currentPageId) {
            if (this.composite == null || this.composite.isDisposed()) {
                return;
            }
            GC metricsGC = new GC((Drawable)this.composite);
            FontMetrics metrics = metricsGC.getFontMetrics();
            metricsGC.dispose();
            List<Button> buttons = this.buttonMap.get(currentPageId);
            Control[] children = this.composite.getChildren();
            int visibleChildren = 0;
            Button closeButton = InstallationDialog.this.getButton(12);
            Control[] controlArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                if (closeButton == control) {
                    closeButton.dispose();
                } else {
                    control.setVisible(false);
                    this.setButtonLayoutData(metrics, control, false);
                }
                ++n2;
            }
            if (buttons != null) {
                for (Button button : buttons) {
                    button.setVisible(true);
                    this.setButtonLayoutData(metrics, (Control)button, true);
                    GridData data = (GridData)button.getLayoutData();
                    data.exclude = false;
                    ++visibleChildren;
                }
            }
            GridLayout compositeLayout = (GridLayout)this.composite.getLayout();
            compositeLayout.numColumns = visibleChildren;
            this.composite.layout(true);
        }

        protected void setButtonLayoutData(FontMetrics metrics, Control button, boolean visible) {
            GridData data = new GridData(256);
            int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)metrics, (int)61);
            Point minSize = button.computeSize(-1, -1, true);
            data.widthHint = Math.max(widthHint, minSize.x);
            data.exclude = !visible;
            button.setLayoutData((Object)data);
        }

        public void addPageButton(String id, Button button) {
            List<Button> list = this.buttonMap.get(id);
            if (list == null) {
                list = new ArrayList<Button>(1);
                this.buttonMap.put(id, list);
            }
            list.add(button);
        }

        public void clear() {
            this.buttonMap = new HashMap();
        }
    }
}

