/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.util.HashMap;
import java.util.Set;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.Win32DPIUtils;
import org.eclipse.swt.internal.win32.BITMAP;
import org.eclipse.swt.internal.win32.ICONINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.version.OsVersion;

public final class Cursor
extends Resource {
    private static final int DEFAULT_ZOOM = 100;
    private HashMap<Integer, CursorHandle> zoomLevelToHandle = new HashMap();
    private final CursorHandleProvider cursorHandleProvider;
    private boolean isDestroyed;

    public Cursor(Device device, int style) {
        super(device);
        this.cursorHandleProvider = new StyleCursorHandleProvider(style);
        this.init();
        this.device.registerResourceWithZoomSupport(this);
    }

    @Deprecated
    public Cursor(Device device, ImageData source, ImageData mask, int hotspotX, int hotspotY) {
        super(device);
        this.cursorHandleProvider = new ImageDataWithMaskCursorHandleProvider(source, mask, hotspotX, hotspotY);
        this.init();
        this.device.registerResourceWithZoomSupport(this);
    }

    public Cursor(Device device, ImageData source, int hotspotX, int hotspotY) {
        super(device);
        this.cursorHandleProvider = new ImageDataCursorHandleProvider(source, hotspotX, hotspotY);
        this.init();
        this.device.registerResourceWithZoomSupport(this);
    }

    private static CursorHandle setupCursorFromImageData(Device device, ImageData source, ImageData mask, int hotspotX, int hotspotY) {
        if (source == null) {
            SWT.error(4);
        }
        long hBitmap = 0L;
        long hMask = 0L;
        if (source.maskData == null && source.transparentPixel == -1 && (source.alpha != -1 || source.alphaData != null)) {
            PaletteData palette = source.palette;
            PaletteData newPalette = new PaletteData(65280, 0xFF0000, -16777216);
            ImageData img = new ImageData(source.width, source.height, 32, newPalette);
            if (palette.isDirect) {
                ImageData.blit(source.data, source.depth, source.bytesPerLine, source.getByteOrder(), source.width, source.height, palette.redMask, palette.greenMask, palette.blueMask, img.data, img.depth, img.bytesPerLine, img.getByteOrder(), img.width, img.height, newPalette.redMask, newPalette.greenMask, newPalette.blueMask, false, false);
            } else {
                RGB[] rgbs = palette.getRGBs();
                int length = rgbs.length;
                byte[] srcReds = new byte[length];
                byte[] srcGreens = new byte[length];
                byte[] srcBlues = new byte[length];
                int i = 0;
                while (i < rgbs.length) {
                    RGB rgb = rgbs[i];
                    if (rgb != null) {
                        srcReds[i] = (byte)rgb.red;
                        srcGreens[i] = (byte)rgb.green;
                        srcBlues[i] = (byte)rgb.blue;
                    }
                    ++i;
                }
                ImageData.blit(source.width, source.height, source.data, source.depth, source.bytesPerLine, source.getByteOrder(), srcReds, srcGreens, srcBlues, img.data, img.depth, img.bytesPerLine, img.getByteOrder(), newPalette.redMask, newPalette.greenMask, newPalette.blueMask);
            }
            hBitmap = Image.createDIB(source.width, source.height, 32);
            if (hBitmap == 0L) {
                SWT.error(2);
            }
            BITMAP dibBM = new BITMAP();
            OS.GetObject(hBitmap, BITMAP.sizeof, dibBM);
            byte[] srcData = img.data;
            if (source.alpha != -1) {
                int i = 3;
                while (i < srcData.length) {
                    srcData[i] = (byte)source.alpha;
                    i += 4;
                }
            } else if (source.alphaData != null) {
                int sp = 3;
                int ap = 0;
                while (sp < srcData.length) {
                    srcData[sp] = source.alphaData[ap];
                    sp += 4;
                    ++ap;
                }
            }
            OS.MoveMemory(dibBM.bmBits, srcData, srcData.length);
            hMask = OS.CreateBitmap(source.width, source.height, 1, 1, new byte[((source.width + 7) / 8 + 3) / 4 * 4 * source.height]);
            if (hMask == 0L) {
                SWT.error(2);
            }
        } else {
            if (mask == null) {
                mask = source.getTransparencyMask();
            }
            long[] result = Image.initIcon(device, source, mask);
            hBitmap = result[0];
            hMask = result[1];
        }
        ICONINFO info = new ICONINFO();
        info.fIcon = false;
        info.hbmColor = hBitmap;
        info.hbmMask = hMask;
        info.xHotspot = hotspotX;
        info.yHotspot = hotspotY;
        long handle = OS.CreateIconIndirect(info);
        OS.DeleteObject(hBitmap);
        OS.DeleteObject(hMask);
        if (handle == 0L) {
            SWT.error(2);
        }
        return new IconCursorHandle(handle);
    }

    public Cursor(Device device, ImageDataProvider imageDataProvider, int hotspotX, int hotspotY) {
        super(device);
        if (imageDataProvider == null) {
            SWT.error(4);
        }
        this.cursorHandleProvider = new ImageDataProviderCursorHandleProvider(imageDataProvider, hotspotX, hotspotY);
        this.init();
        this.device.registerResourceWithZoomSupport(this);
    }

    public static Long win32_getHandle(Cursor cursor, int zoom) {
        if (cursor.isDisposed()) {
            return 0L;
        }
        if (cursor.zoomLevelToHandle.get(zoom) != null) {
            return cursor.zoomLevelToHandle.get(zoom).getHandle();
        }
        CursorHandle handle = cursor.cursorHandleProvider.createHandle(cursor.device, zoom);
        cursor.setHandleForZoomLevel(handle, zoom);
        return cursor.zoomLevelToHandle.get(zoom).getHandle();
    }

    private void setHandleForZoomLevel(CursorHandle handle, Integer zoom) {
        if (zoom != null && !this.zoomLevelToHandle.containsKey(zoom)) {
            this.zoomLevelToHandle.put(zoom, handle);
        }
    }

    private static float getPointerSizeScaleFactor() {
        int[] cursorBaseSize;
        if (OsVersion.IS_WIN10_1809 && (cursorBaseSize = OS.readRegistryDwords(-2147483647, "Control Panel\\Cursors", "CursorBaseSize")) != null && cursorBaseSize.length > 0 && cursorBaseSize[0] > 0) {
            return (float)cursorBaseSize[0] / 32.0f;
        }
        return 1.0f;
    }

    @Override
    void destroy() {
        this.device.deregisterResourceWithZoomSupport(this);
        for (CursorHandle handle : this.zoomLevelToHandle.values()) {
            handle.destroy();
        }
        this.zoomLevelToHandle.clear();
        this.isDestroyed = true;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Cursor)) {
            return false;
        }
        Cursor cursor = (Cursor)object;
        return this.device == cursor.device && Cursor.win32_getHandle(this, 100) == Cursor.win32_getHandle(cursor, 100);
    }

    public int hashCode() {
        return Cursor.win32_getHandle(this, 100).intValue();
    }

    @Override
    public boolean isDisposed() {
        return this.isDestroyed;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Cursor {*DISPOSED*}";
        }
        return "Cursor {" + String.valueOf(this.zoomLevelToHandle) + "}";
    }

    @Override
    void destroyHandlesExcept(Set<Integer> zoomLevels) {
        this.zoomLevelToHandle.entrySet().removeIf(entry -> {
            Integer zoom = (Integer)entry.getKey();
            if (!zoomLevels.contains(zoom) && zoom != DPIUtil.getZoomForAutoscaleProperty(100)) {
                ((CursorHandle)entry.getValue()).destroy();
                return true;
            }
            return false;
        });
    }

    private static abstract class CursorHandle {
        private final long handle;

        public CursorHandle(long handle) {
            this.handle = handle;
        }

        long getHandle() {
            return this.handle;
        }

        abstract void destroy();
    }

    private static interface CursorHandleProvider {
        public CursorHandle createHandle(Device var1, int var2);
    }

    private static class CustomCursorHandle
    extends CursorHandle {
        public CustomCursorHandle(long handle) {
            super(handle);
        }

        @Override
        void destroy() {
            OS.DestroyCursor(this.getHandle());
        }
    }

    private static abstract class HotspotAwareCursorHandleProvider
    implements CursorHandleProvider {
        private final int hotspotX;
        private final int hotspotY;

        public HotspotAwareCursorHandleProvider(int hotspotX, int hotspotY) {
            this.hotspotX = hotspotX;
            this.hotspotY = hotspotY;
        }

        protected final int getHotpotXInPixels(int zoom) {
            return Win32DPIUtils.pointToPixel(this.hotspotX, zoom);
        }

        protected final int getHotpotYInPixels(int zoom) {
            return Win32DPIUtils.pointToPixel(this.hotspotY, zoom);
        }

        protected static final void validateHotspotInsideImage(ImageData source, int hotspotX, int hotspotY) {
            if (hotspotX >= source.width || hotspotX < 0 || hotspotY >= source.height || hotspotY < 0) {
                SWT.error(5);
            }
        }
    }

    private static class IconCursorHandle
    extends CursorHandle {
        public IconCursorHandle(long handle) {
            super(handle);
        }

        @Override
        void destroy() {
            OS.DestroyIcon(this.getHandle());
        }
    }

    private static class ImageDataCursorHandleProvider
    extends HotspotAwareCursorHandleProvider {
        protected final ImageData source;

        public ImageDataCursorHandleProvider(ImageData source, int hotspotX, int hotspotY) {
            super(hotspotX, hotspotY);
            if (source == null) {
                SWT.error(4);
            }
            ImageDataCursorHandleProvider.validateHotspotInsideImage(source, hotspotX, hotspotY);
            this.source = source;
        }

        @Override
        public CursorHandle createHandle(Device device, int zoom) {
            float accessibilityFactor = Cursor.getPointerSizeScaleFactor();
            int scaledZoom = (int)((float)zoom * accessibilityFactor);
            ImageData scaledSource = DPIUtil.scaleImageData(device, this.source, scaledZoom, 100);
            return Cursor.setupCursorFromImageData(device, scaledSource, null, this.getHotpotXInPixels(zoom), this.getHotpotYInPixels(zoom));
        }
    }

    private static class ImageDataProviderCursorHandleProvider
    extends HotspotAwareCursorHandleProvider {
        private final ImageDataProvider provider;

        public ImageDataProviderCursorHandleProvider(ImageDataProvider provider, int hotspotX, int hotspotY) {
            super(hotspotX, hotspotY);
            ImageData source = provider.getImageData(100);
            if (source == null) {
                SWT.error(4);
            }
            ImageDataProviderCursorHandleProvider.validateHotspotInsideImage(source, hotspotX, hotspotY);
            this.provider = provider;
        }

        @Override
        public CursorHandle createHandle(Device device, int zoom) {
            ImageData source;
            if (zoom == 100) {
                source = this.provider.getImageData(100);
            } else {
                Image tempImage = new Image(device, this.provider);
                source = tempImage.getImageData(zoom);
                tempImage.dispose();
            }
            return Cursor.setupCursorFromImageData(device, source, null, this.getHotpotXInPixels(zoom), this.getHotpotYInPixels(zoom));
        }
    }

    private static class ImageDataWithMaskCursorHandleProvider
    extends ImageDataCursorHandleProvider {
        private final ImageData mask;

        public ImageDataWithMaskCursorHandleProvider(ImageData source, ImageData mask, int hotspotX, int hotspotY) {
            super(source, hotspotX, hotspotY);
            this.mask = mask;
            this.validateMask(source, mask);
        }

        private void validateMask(ImageData source, ImageData mask) {
            ImageData testMask;
            ImageData imageData = testMask = mask == null ? null : (ImageData)mask.clone();
            if (testMask == null) {
                if (source.getTransparencyType() != 2) {
                    SWT.error(4);
                }
                testMask = source.getTransparencyMask();
            }
            if (testMask.width != source.width || testMask.height != source.height) {
                SWT.error(5);
            }
        }

        @Override
        public CursorHandle createHandle(Device device, int zoom) {
            float accessibilityFactor = Cursor.getPointerSizeScaleFactor();
            int scaledZoom = (int)((float)zoom * accessibilityFactor);
            ImageData scaledSource = DPIUtil.scaleImageData(device, this.source, scaledZoom, 100);
            ImageData scaledMask = this.mask != null ? DPIUtil.scaleImageData(device, this.mask, scaledZoom, 100) : null;
            return Cursor.setupCursorFromImageData(device, scaledSource, scaledMask, this.getHotpotXInPixels(zoom), this.getHotpotYInPixels(zoom));
        }
    }

    private static class StyleCursorHandleProvider
    implements CursorHandleProvider {
        private final long lpCursorName;

        public StyleCursorHandleProvider(int style) {
            this.lpCursorName = StyleCursorHandleProvider.getOSCursorIdFromStyle(style);
        }

        @Override
        public CursorHandle createHandle(Device device, int zoom) {
            long handle = OS.LoadCursor(0L, this.lpCursorName);
            if (handle == 0L) {
                SWT.error(2);
            }
            return new CustomCursorHandle(handle);
        }

        private static final long getOSCursorIdFromStyle(int style) {
            long lpCursorName = 0L;
            switch (style) {
                case 21: {
                    lpCursorName = 32649L;
                    break;
                }
                case 0: {
                    lpCursorName = 32512L;
                    break;
                }
                case 1: {
                    lpCursorName = 32514L;
                    break;
                }
                case 2: {
                    lpCursorName = 32515L;
                    break;
                }
                case 3: {
                    lpCursorName = 32650L;
                    break;
                }
                case 4: {
                    lpCursorName = 32651L;
                    break;
                }
                case 5: {
                    lpCursorName = 32646L;
                    break;
                }
                case 6: {
                    lpCursorName = 32643L;
                    break;
                }
                case 7: {
                    lpCursorName = 32645L;
                    break;
                }
                case 8: {
                    lpCursorName = 32642L;
                    break;
                }
                case 9: {
                    lpCursorName = 32644L;
                    break;
                }
                case 10: {
                    lpCursorName = 32645L;
                    break;
                }
                case 11: {
                    lpCursorName = 32645L;
                    break;
                }
                case 12: {
                    lpCursorName = 32644L;
                    break;
                }
                case 13: {
                    lpCursorName = 32644L;
                    break;
                }
                case 14: {
                    lpCursorName = 32643L;
                    break;
                }
                case 15: {
                    lpCursorName = 32642L;
                    break;
                }
                case 16: {
                    lpCursorName = 32643L;
                    break;
                }
                case 17: {
                    lpCursorName = 32642L;
                    break;
                }
                case 18: {
                    lpCursorName = 32516L;
                    break;
                }
                case 19: {
                    lpCursorName = 32513L;
                    break;
                }
                case 20: {
                    lpCursorName = 32648L;
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
            return lpCursorName;
        }
    }
}

