/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.internal.workbench.Policy;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugTrace;

public final class WorkbenchLogger
extends Logger {
    protected DebugTrace trace;
    protected FrameworkLog log;
    private String bundleName;

    @Inject
    public WorkbenchLogger(@Optional @Named(value="logger.bundlename") String bundleName) {
        this.bundleName = bundleName == null ? "org.eclipse.e4.ui.workbench" : bundleName;
    }

    public void debug(Throwable t) {
        this.debug(t, null);
    }

    public void debug(Throwable t, String message) {
        if (!this.isDebugEnabled()) {
            return;
        }
        this.trace("/debug", t, message);
    }

    public void error(Throwable t, String message) {
        this.log((IStatus)new Status(4, this.bundleName, message, t));
    }

    private static FrameworkLogEntry getLog(IStatus status) {
        IStatus[] children;
        IStatus coreStatus;
        int stackCode;
        Throwable t = status.getException();
        ArrayList<FrameworkLogEntry> childlist = new ArrayList<FrameworkLogEntry>();
        int n = stackCode = t instanceof CoreException ? 1 : 0;
        if (stackCode == 1 && (coreStatus = ((CoreException)t).getStatus()) != null) {
            childlist.add(WorkbenchLogger.getLog(coreStatus));
        }
        if (status.isMultiStatus()) {
            IStatus[] iStatusArray = children = status.getChildren();
            int n2 = children.length;
            int n3 = 0;
            while (n3 < n2) {
                IStatus element = iStatusArray[n3];
                childlist.add(WorkbenchLogger.getLog(element));
                ++n3;
            }
        }
        children = childlist.isEmpty() ? null : childlist.toArray(new FrameworkLogEntry[childlist.size()]);
        return new FrameworkLogEntry(status.getPlugin(), status.getSeverity(), status.getCode(), status.getMessage(), stackCode, t, (FrameworkLogEntry[])children);
    }

    public void info(Throwable t, String message) {
        this.log((IStatus)new Status(1, this.bundleName, message, t));
    }

    public boolean isDebugEnabled() {
        return Policy.DEBUG;
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public boolean isTraceEnabled() {
        return Policy.TRACE;
    }

    public boolean isWarnEnabled() {
        return true;
    }

    private void log(IStatus status) {
        if (this.log != null) {
            this.log.log(WorkbenchLogger.getLog(status));
        } else {
            System.out.println(status.getMessage());
            if (status.getException() != null) {
                status.getException().printStackTrace();
            }
        }
    }

    @Inject
    public void setDebugOptions(DebugOptions options) {
        if (options != null) {
            this.trace = options.newDebugTrace(this.bundleName, WorkbenchLogger.class);
        }
    }

    @Inject
    public void setFrameworkLog(FrameworkLog log) {
        this.log = log;
    }

    public void trace(Throwable t, String message) {
        this.trace("/trace", t, message);
    }

    private void trace(String flag, Throwable t, String message) {
        if (this.trace != null) {
            this.trace.trace(flag, message, t);
        } else {
            System.out.println(message);
            if (t != null) {
                t.printStackTrace();
            }
        }
    }

    public void warn(Throwable t, String message) {
        this.log((IStatus)new Status(2, this.bundleName, message, t));
    }
}

