/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import java.io.IOException;
import java.security.SecureRandom;
import org.bouncycastle.bcpg.AEADUtils;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.bcpg.SymmetricKeyUtils;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.HKDFParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.bc.BcAEADUtil;
import org.bouncycastle.util.Arrays;

public class BcAEADSecretKeyEncryptorBuilder {
    private int aeadAlgorithm;
    private int symmetricAlgorithm;
    private S2K.Argon2Params argon2Params;

    public BcAEADSecretKeyEncryptorBuilder(int n, int n2, S2K.Argon2Params argon2Params) {
        this.aeadAlgorithm = n;
        this.symmetricAlgorithm = n2;
        this.argon2Params = argon2Params;
    }

    public PBESecretKeyEncryptor build(char[] cArray, final PublicKeyPacket publicKeyPacket) {
        return new PBESecretKeyEncryptor(this.symmetricAlgorithm, this.aeadAlgorithm, this.argon2Params, new SecureRandom(), cArray){
            private byte[] iv;
            {
                super(n, n2, argon2Params, secureRandom, cArray);
                this.iv = new byte[AEADUtils.getIVLength(this.aeadAlgorithm)];
                this.random.nextBytes(this.iv);
            }

            @Override
            public byte[] encryptKeyData(byte[] byArray, byte[] byArray2, int n, int n2) throws PGPException {
                int n3 = publicKeyPacket.getPacketTag() == 6 ? 5 : 7;
                byte[] byArray3 = new byte[]{(byte)(0xC0 | n3), (byte)publicKeyPacket.getVersion(), (byte)BcAEADSecretKeyEncryptorBuilder.this.symmetricAlgorithm, (byte)this.aeadAlgorithm};
                HKDFParameters hKDFParameters = new HKDFParameters(this.getKey(), null, byArray3);
                HKDFBytesGenerator hKDFBytesGenerator = new HKDFBytesGenerator((Digest)new SHA256Digest());
                hKDFBytesGenerator.init((DerivationParameters)hKDFParameters);
                byArray = new byte[SymmetricKeyUtils.getKeyLengthInOctets(this.encAlgorithm)];
                hKDFBytesGenerator.generateBytes(byArray, 0, byArray.length);
                try {
                    byte[] byArray4 = Arrays.prepend((byte[])publicKeyPacket.getEncodedContents(), (byte)((byte)(0xC0 | n3)));
                    AEADBlockCipher aEADBlockCipher = BcAEADUtil.createAEADCipher(this.encAlgorithm, this.aeadAlgorithm);
                    aEADBlockCipher.init(true, (CipherParameters)new AEADParameters(new KeyParameter(byArray), 128, this.getCipherIV(), byArray4));
                    int n4 = aEADBlockCipher.getOutputSize(byArray2.length);
                    byte[] byArray5 = new byte[n4];
                    n4 = aEADBlockCipher.processBytes(byArray2, 0, byArray2.length, byArray5, 0);
                    aEADBlockCipher.doFinal(byArray5, n4);
                    return byArray5;
                }
                catch (IOException iOException) {
                    throw new PGPException("Exception AEAD protecting private key material", iOException);
                }
                catch (InvalidCipherTextException invalidCipherTextException) {
                    throw new PGPException("Exception AEAD protecting private key material", (Exception)((Object)invalidCipherTextException));
                }
            }

            @Override
            public byte[] getCipherIV() {
                return this.iv;
            }
        };
    }
}

