/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.internal.ui;

import org.eclipse.oomph.internal.ui.ImageHoverButton;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class ImageCheckbox
extends ImageHoverButton {
    private final Image checkedImage;
    private boolean checked;

    public ImageCheckbox(Composite parent, Image defaultImage, Image hoverImage) {
        this(parent, defaultImage, hoverImage, hoverImage);
    }

    public ImageCheckbox(Composite parent, Image defaultImage, Image hoverImage, Image checkedImage) {
        super(parent, 32, defaultImage, hoverImage);
        this.checkedImage = checkedImage;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
        this.setImage(this.computeImage());
        this.redraw();
    }

    @Override
    protected Image computeImage() {
        if (!this.isEnabled()) {
            return super.computeImage();
        }
        if (this.isHover() && !this.isChecked()) {
            return this.getHoverImage();
        }
        return this.isChecked() || this.isFocusControl() ? this.getCheckedImage() : this.getDefaultImage();
    }

    protected Image getCheckedImage() {
        return this.checkedImage;
    }
}

