/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench.swt;

import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.ui.internal.workbench.swt.DialogSettingsProvider;
import org.eclipse.jface.dialogs.IDialogSettingsProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public final class DialogSettingsProviderService {
    public static final DialogSettingsProviderService instance = new DialogSettingsProviderService();
    private static Map<Bundle, DialogSettingsProvider> fTrackedBundles = Collections.synchronizedMap(new WeakHashMap());

    static {
        final BundleContext ctx = FrameworkUtil.getBundle(DialogSettingsProviderService.class).getBundleContext();
        Hashtable<String, String[]> topics = new Hashtable<String, String[]>();
        ((Dictionary)topics).put("event.topics", new String[]{"org/eclipse/e4/ui/LifeCycle/appShutdownStarted"});
        ctx.registerService(EventHandler.class, (Object)new EventHandler(){
            private boolean fSaved;

            public void handleEvent(Event event) {
                if (event.getTopic().equals("org/eclipse/e4/ui/LifeCycle/appShutdownStarted") && !this.fSaved) {
                    if (Platform.inDebugMode()) {
                        Platform.getLog((Bundle)ctx.getBundle()).info("Saving dialog settings");
                    }
                    fTrackedBundles.forEach((bundle, service) -> service.saveDialogSettings());
                    this.fSaved = true;
                }
            }
        }, topics);
    }

    public synchronized IDialogSettingsProvider getProvider(Bundle bundle) {
        if (fTrackedBundles.containsKey(bundle)) {
            return fTrackedBundles.get(bundle);
        }
        DialogSettingsProvider dialogSettingsProvider = new DialogSettingsProvider(bundle);
        fTrackedBundles.put(bundle, dialogSettingsProvider);
        return dialogSettingsProvider;
    }
}

