/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.gitbash;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.oomph.gitbash.Activator;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAction<TARGET>
implements IObjectActionDelegate {
    private IWorkbenchPart targetPart;
    private Class<TARGET> targetClass;
    private TARGET target;

    public AbstractAction(Class<TARGET> targetClass) {
        this.targetClass = targetClass;
    }

    public IWorkbenchPart getTargetPart() {
        return this.targetPart;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.target = null;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            Object element = ssel.getFirstElement();
            this.target = AbstractAction.getAdapter(element, this.targetClass);
        }
    }

    public void run(IAction action) {
        if (this.target != null) {
            try {
                this.run(this.targetPart.getSite().getShell(), this.target);
            }
            catch (Exception ex) {
                Activator.log(ex);
            }
        }
    }

    protected abstract void run(Shell var1, TARGET var2) throws Exception;

    public static <T> T getAdapter(Object adaptable, Class<T> c) {
        IAdaptable a;
        Object adapter;
        if (c.isInstance(adaptable)) {
            return (T)adaptable;
        }
        if (adaptable instanceof IAdaptable && c.isInstance(adapter = (a = (IAdaptable)adaptable).getAdapter(c))) {
            return (T)adapter;
        }
        return null;
    }
}

