/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.util;

public interface Confirmer {
    public static final Confirmer ACCEPT = new Confirmer(){

        public Confirmation confirm(boolean defaultConfirmed, Object info) {
            return new Confirmation(true, false);
        }
    };
    public static final Confirmer DECLINE = new Confirmer(){

        public Confirmation confirm(boolean defaultConfirmed, Object info) {
            return new Confirmation(false, false);
        }
    };
    public static final Confirmer DEFAULT = new Confirmer(){

        public Confirmation confirm(boolean defaultConfirmed, Object info) {
            return new Confirmation(defaultConfirmed, false);
        }
    };

    public Confirmation confirm(boolean var1, Object var2);

    public static final class Confirmation {
        private final boolean confirmed;
        private final boolean remember;

        public Confirmation(boolean confirmed, boolean remember) {
            this.confirmed = confirmed;
            this.remember = remember;
        }

        public boolean isConfirmed() {
            return this.confirmed;
        }

        public boolean isRemember() {
            return this.remember;
        }

        public String toString() {
            return String.valueOf(this.confirmed ? "Accept" : "Decline") + (this.remember ? " (remember)" : "");
        }
    }
}

