/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.targlets.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.command.DragAndDropCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.query.CollectionResult;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.oomph.p2.Configuration;
import org.eclipse.oomph.p2.P2Factory;
import org.eclipse.oomph.p2.Repository;
import org.eclipse.oomph.p2.RepositoryList;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.resources.ResourcesFactory;
import org.eclipse.oomph.resources.SourceLocator;
import org.eclipse.oomph.setup.Project;
import org.eclipse.oomph.setup.ProjectCatalog;
import org.eclipse.oomph.setup.Scope;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.VariableChoice;
import org.eclipse.oomph.setup.VariableTask;
import org.eclipse.oomph.setup.provider.SetupTaskItemProvider;
import org.eclipse.oomph.setup.targlets.SetupTargletsFactory;
import org.eclipse.oomph.setup.targlets.SetupTargletsPackage;
import org.eclipse.oomph.setup.targlets.TargletTask;
import org.eclipse.oomph.setup.targlets.provider.SetupTargletsEditPlugin;
import org.eclipse.oomph.targlets.IUGenerator;
import org.eclipse.oomph.targlets.Targlet;
import org.eclipse.oomph.targlets.TargletFactory;
import org.eclipse.oomph.targlets.core.WorkspaceIUInfo;
import org.eclipse.oomph.targlets.internal.core.WorkspaceIUAnalyzer;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.oomph.util.pde.TargetPlatformRunnable;
import org.eclipse.oomph.util.pde.TargetPlatformUtil;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.internal.core.target.IUBundleContainer;
import org.eclipse.pde.internal.core.target.WorkspaceFileTargetHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargletTaskItemProvider
extends SetupTaskItemProvider {
    private static final Pattern VERSION_PATTERN = Pattern.compile("([1-9]+\\.[0-9]+)");

    public TargletTaskItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addTargletURIsPropertyDescriptor(object);
            this.addOperatingSystemPropertyDescriptor(object);
            this.addWindowingSystemPropertyDescriptor(object);
            this.addArchitecturePropertyDescriptor(object);
            this.addLocalePropertyDescriptor(object);
            this.addProgramArgumentsPropertyDescriptor(object);
            this.addVMArgumentsPropertyDescriptor(object);
            this.addTargetNamePropertyDescriptor(object);
            this.addActivateTargetPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addTargetNamePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TargletTask_targetName_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TargletTask_targetName_feature", "_UI_TargletTask_type"), (EStructuralFeature)SetupTargletsPackage.Literals.TARGLET_TASK__TARGET_NAME, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addActivateTargetPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TargletTask_activateTarget_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TargletTask_activateTarget_feature", "_UI_TargletTask_type"), (EStructuralFeature)SetupTargletsPackage.Literals.TARGLET_TASK__ACTIVATE_TARGET, true, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
    }

    protected void addTargletURIsPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TargletTask_targletURIs_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TargletTask_targletURIs_feature", "_UI_TargletTask_type"), (EStructuralFeature)SetupTargletsPackage.Literals.TARGLET_TASK__TARGLET_UR_IS, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addOperatingSystemPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TargletTask_operatingSystem_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TargletTask_operatingSystem_feature", "_UI_TargletTask_type"), (EStructuralFeature)SetupTargletsPackage.Literals.TARGLET_TASK__OPERATING_SYSTEM, true, false, true, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null){

            public Collection<?> getChoiceOfValues(Object object) {
                return Configuration.Choices.forOS();
            }
        });
    }

    protected void addWindowingSystemPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TargletTask_windowingSystem_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TargletTask_windowingSystem_feature", "_UI_TargletTask_type"), (EStructuralFeature)SetupTargletsPackage.Literals.TARGLET_TASK__WINDOWING_SYSTEM, true, false, true, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null){

            public Collection<?> getChoiceOfValues(Object object) {
                return Configuration.Choices.forWS();
            }
        });
    }

    protected void addArchitecturePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TargletTask_architecture_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TargletTask_architecture_feature", "_UI_TargletTask_type"), (EStructuralFeature)SetupTargletsPackage.Literals.TARGLET_TASK__ARCHITECTURE, true, false, true, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null){

            public Collection<?> getChoiceOfValues(Object object) {
                return Configuration.Choices.forArch();
            }
        });
    }

    protected void addLocalePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TargletTask_locale_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TargletTask_locale_feature", "_UI_TargletTask_type"), (EStructuralFeature)SetupTargletsPackage.Literals.TARGLET_TASK__LOCALE, true, false, true, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null){
            private static final String NL_EXTRA = "org.eclipse.pde.nl.extra";
            private LocaleItemLabelProvider labelProvider;

            public Collection<?> getChoiceOfValues(Object object) {
                LocaleItemLabelProvider labelProvider = this.getLabelProvider(object);
                Set<String> locales = labelProvider.getLocaleMap().keySet();
                return TargletTaskItemProvider.getChoices(locales.toArray(new String[locales.size()]), NL_EXTRA);
            }

            public LocaleItemLabelProvider getLabelProvider(Object object) {
                if (this.labelProvider == null) {
                    this.labelProvider = new LocaleItemLabelProvider(this.itemDelegator);
                }
                return this.labelProvider;
            }
        });
    }

    protected void addProgramArgumentsPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TargletTask_programArguments_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TargletTask_programArguments_feature", "_UI_TargletTask_type"), (EStructuralFeature)SetupTargletsPackage.Literals.TARGLET_TASK__PROGRAM_ARGUMENTS, true, true, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addVMArgumentsPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TargletTask_vMArguments_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TargletTask_vMArguments_feature", "_UI_TargletTask_type"), (EStructuralFeature)SetupTargletsPackage.Literals.TARGLET_TASK__VM_ARGUMENTS, true, true, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    private static Set<String> getChoices(String[] values, String extraValuesPreference) {
        HashSet<String> result = new HashSet<String>();
        result.addAll(Arrays.asList(values));
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.pde.core");
        String extraValues = node.get(extraValuesPreference, null);
        if (!StringUtil.isEmpty((String)extraValues)) {
            StringTokenizer tokenizer = new StringTokenizer(extraValues, ",");
            while (tokenizer.hasMoreTokens()) {
                String extraValue = tokenizer.nextToken().trim();
                result.add(extraValue);
            }
        }
        return result;
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(SetupTargletsPackage.Literals.TARGLET_TASK__TARGLETS);
            this.childrenFeatures.add(SetupTargletsPackage.Literals.TARGLET_TASK__IMPLICIT_DEPENDENCIES);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/TargletTask"));
    }

    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getText(Object object) {
        TargletTask targletTask = (TargletTask)object;
        StringBuilder builder = new StringBuilder();
        HashSet<String> added = new HashSet<String>();
        String targetNameLabel = "";
        String targetName = targletTask.getTargetName();
        if (targetName != null) {
            Pattern TARGET_NAME_LABEL_PATTERN = Pattern.compile("(.*)[\\s-_](Modular)?[\\s-_]*(Target)?");
            Matcher matcher = TARGET_NAME_LABEL_PATTERN.matcher(targetName);
            targetNameLabel = matcher.matches() ? matcher.group(1) : targetName;
        }
        for (Targlet targlet : targletTask.getTarglets()) {
            String name = targlet.getName();
            if (!added.add(name)) continue;
            if (builder.length() != 0) {
                builder.append(" + ");
            }
            builder.append(name);
        }
        if (builder.length() != 0) {
            builder.insert(0, " (");
            builder.append(')');
        }
        if (StringUtil.isEmpty((String)targetNameLabel)) {
            builder.insert(0, "Target");
        } else {
            builder.insert(0, " Target");
            builder.insert(0, targetNameLabel);
        }
        if (targletTask.isActivateTarget()) {
            builder.append(", activate");
        }
        return builder.toString();
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(TargletTask.class)) {
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 10: 
            case 18: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(SetupTargletsPackage.Literals.TARGLET_TASK__TARGLETS, TargletFactory.eINSTANCE.createTarglet()));
        newChildDescriptors.add(this.createChildParameter(SetupTargletsPackage.Literals.TARGLET_TASK__IMPLICIT_DEPENDENCIES, SetupTargletsFactory.eINSTANCE.createImplicitDependency()));
    }

    public Command createCommand(Object object, final EditingDomain domain, Class<? extends Command> commandClass, final CommandParameter commandParameter) {
        URI uri;
        Object value;
        Collection collection;
        if (commandClass == DragAndDropCommand.class && (collection = commandParameter.getCollection()).size() == 1 && (value = collection.iterator().next()) instanceof URI && "target".equals((uri = (URI)value).fileExtension()) && uri.isPlatformResource()) {
            final Path path = new Path(uri.toPlatformString(true));
            try {
                Command result = (Command)TargetPlatformUtil.runWithTargetPlatformService((TargetPlatformRunnable)new TargetPlatformRunnable<Command>(){

                    public Command run(ITargetPlatformService service) throws CoreException {
                        ITargetHandle[] iTargetHandleArray = service.getTargets((IProgressMonitor)new NullProgressMonitor());
                        int n = iTargetHandleArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            WorkspaceFileTargetHandle workspaceFileTargetHandle;
                            IFile targetFile;
                            ITargetHandle targetHandle = iTargetHandleArray[n2];
                            if (targetHandle instanceof WorkspaceFileTargetHandle && path.equals((Object)(targetFile = (workspaceFileTargetHandle = (WorkspaceFileTargetHandle)targetHandle).getTargetFile()).getFullPath())) {
                                final TreeSet<Requirement> requirements = new TreeSet<Requirement>(new Comparator<Requirement>(){

                                    @Override
                                    public int compare(Requirement requirement1, Requirement requirement2) {
                                        String name1 = requirement1.getName();
                                        String name2 = requirement2.getName();
                                        return name1.compareTo(name2);
                                    }
                                });
                                final TreeSet<Repository> repos = new TreeSet<Repository>(new Comparator<Repository>(){

                                    @Override
                                    public int compare(Repository repository1, Repository repository2) {
                                        String url1 = repository1.getURL();
                                        String url2 = repository2.getURL();
                                        return url1.compareTo(url2);
                                    }
                                });
                                ITargetDefinition targetDefinition = targetHandle.getTargetDefinition();
                                final String arch = targetDefinition.getArch();
                                final String os = targetDefinition.getOS();
                                final String ws = targetDefinition.getWS();
                                final String nl = targetDefinition.getNL();
                                final String programArguments = targetDefinition.getProgramArguments();
                                final String vmArguments = targetDefinition.getVMArguments();
                                ITargetLocation[] iTargetLocationArray = targetDefinition.getTargetLocations();
                                int n3 = iTargetLocationArray.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    ITargetLocation targetLocation = iTargetLocationArray[n4];
                                    if (targetLocation instanceof IUBundleContainer) {
                                        java.net.URI[] repositories;
                                        IUBundleContainer iuBundleContainer = (IUBundleContainer)targetLocation;
                                        java.net.URI[] uRIArray = repositories = iuBundleContainer.getRepositories();
                                        int n5 = repositories.length;
                                        int n6 = 0;
                                        while (n6 < n5) {
                                            java.net.URI repo = uRIArray[n6];
                                            URI repoURI = URI.createURI((String)repo.toString());
                                            if (repoURI.hasTrailingPathSeparator()) {
                                                repoURI = repoURI.trimSegments(1);
                                            }
                                            repos.add(P2Factory.eINSTANCE.createRepository(repoURI.toString()));
                                            ++n6;
                                        }
                                        String[] ids = (String[])ReflectUtil.invokeMethod((String)"getIds", (Object)iuBundleContainer);
                                        Version[] versions = (Version[])ReflectUtil.invokeMethod((String)"getVersions", (Object)iuBundleContainer);
                                        int i = 0;
                                        int length = ids.length;
                                        while (i < length) {
                                            requirements.add(P2Factory.eINSTANCE.createRequirement(ids[i], versions[i]));
                                            ++i;
                                        }
                                    }
                                    ++n4;
                                }
                                DragAndDropCommand.Detail detail = (DragAndDropCommand.Detail)commandParameter.getFeature();
                                return new TargletDragAndDropCommand(domain, commandParameter.getOwner(), detail.location, detail.operations, detail.operation, commandParameter.getCollection()){

                                    protected boolean prepareDropCopyOn() {
                                        this.dragCommand = IdentityCommand.INSTANCE;
                                        CompoundCommand compoundCommand = new CompoundCommand(0);
                                        this.dropCommand = compoundCommand;
                                        Targlet targlet = TargletFactory.eINSTANCE.createTarglet();
                                        targlet.setName(String.valueOf(this.getTargletName(StringUtil.cap((String)uri.trimFileExtension().lastSegment()))) + "Target Platform");
                                        targlet.setActiveRepositoryListName("${eclipse.target.platform}");
                                        targlet.getRequirements().addAll((Collection)requirements);
                                        EList repositoryLists = targlet.getRepositoryLists();
                                        RepositoryList repositoryList = P2Factory.eINSTANCE.createRepositoryList();
                                        repositoryList.setName(this.getRepositoryListName(StringUtil.cap((String)uri.trimFileExtension().lastSegment())));
                                        repositoryLists.add((Object)repositoryList);
                                        repositoryList.getRepositories().addAll((Collection)repos);
                                        TargletTask targletTask = (TargletTask)this.owner;
                                        compoundCommand.append((Command)new AddCommand(this.domain, (EObject)targletTask, (EStructuralFeature)SetupTargletsPackage.Literals.TARGLET_TASK__TARGLETS, (Object)targlet));
                                        if (StringUtil.isEmpty((String)targletTask.getArchitecture()) && !StringUtil.isEmpty((String)arch)) {
                                            compoundCommand.append((Command)new SetCommand(this.domain, (EObject)targletTask, (EStructuralFeature)SetupTargletsPackage.Literals.TARGLET_TASK__ARCHITECTURE, (Object)arch));
                                        }
                                        if (StringUtil.isEmpty((String)targletTask.getOperatingSystem()) && !StringUtil.isEmpty((String)os)) {
                                            compoundCommand.append((Command)new SetCommand(this.domain, (EObject)targletTask, (EStructuralFeature)SetupTargletsPackage.Literals.TARGLET_TASK__OPERATING_SYSTEM, (Object)os));
                                        }
                                        if (StringUtil.isEmpty((String)targletTask.getWindowingSystem()) && !StringUtil.isEmpty((String)ws)) {
                                            compoundCommand.append((Command)new SetCommand(this.domain, (EObject)targletTask, (EStructuralFeature)SetupTargletsPackage.Literals.TARGLET_TASK__WINDOWING_SYSTEM, (Object)ws));
                                        }
                                        if (StringUtil.isEmpty((String)targletTask.getLocale()) && !StringUtil.isEmpty((String)nl)) {
                                            compoundCommand.append((Command)new SetCommand(this.domain, (EObject)targletTask, (EStructuralFeature)SetupTargletsPackage.Literals.TARGLET_TASK__LOCALE, (Object)nl));
                                        }
                                        if (!StringUtil.isEmpty((String)vmArguments)) {
                                            String newVmArguments = targletTask.getVMArguments();
                                            newVmArguments = StringUtil.isEmpty((String)newVmArguments) ? "" : String.valueOf(newVmArguments) + "\n";
                                            newVmArguments = String.valueOf(newVmArguments) + vmArguments;
                                            compoundCommand.append((Command)new SetCommand(this.domain, (EObject)targletTask, (EStructuralFeature)SetupTargletsPackage.Literals.TARGLET_TASK__VM_ARGUMENTS, (Object)newVmArguments.replaceAll("[\n\r]+", "\n").trim()));
                                        }
                                        if (!StringUtil.isEmpty((String)programArguments)) {
                                            String newProgramArguments = targletTask.getProgramArguments();
                                            newProgramArguments = StringUtil.isEmpty((String)newProgramArguments) ? "" : String.valueOf(newProgramArguments) + "\n";
                                            newProgramArguments = String.valueOf(newProgramArguments) + programArguments;
                                            compoundCommand.append((Command)new SetCommand(this.domain, (EObject)targletTask, (EStructuralFeature)SetupTargletsPackage.Literals.TARGLET_TASK__PROGRAM_ARGUMENTS, (Object)newProgramArguments.replaceAll("[\n\r]+", "\n").trim()));
                                        }
                                        return this.dropCommand.canExecute();
                                    }

                                    private String getRepositoryListName(String defaultName) {
                                        String lowerCaseDefaultName = defaultName.toLowerCase();
                                        TargletTask targletTask = (TargletTask)this.owner;
                                        Scope scope = targletTask.getScope();
                                        while (scope != null) {
                                            if (scope instanceof ProjectCatalog) {
                                                TreeIterator it = EcoreUtil.getAllProperContents((EObject)scope, (boolean)false);
                                                while (it.hasNext()) {
                                                    VariableTask variableTask;
                                                    EObject child = (EObject)it.next();
                                                    if (!(child instanceof VariableTask) || !"eclipse.target.platform".equals((variableTask = (VariableTask)child).getName())) continue;
                                                    String candidate = null;
                                                    for (VariableChoice variableChoice : variableTask.getChoices()) {
                                                        Matcher matcher;
                                                        String value = variableChoice.getValue();
                                                        if (lowerCaseDefaultName.contains(value.toLowerCase())) {
                                                            return value;
                                                        }
                                                        String label = variableChoice.getLabel();
                                                        if (label != null && (matcher = VERSION_PATTERN.matcher(label)).find() && defaultName.indexOf(matcher.group(1)) != -1) {
                                                            return value;
                                                        }
                                                        if (candidate != null) continue;
                                                        candidate = value;
                                                    }
                                                    return candidate;
                                                }
                                                break;
                                            }
                                            scope = scope.getParentScope();
                                        }
                                        return defaultName;
                                    }
                                };
                            }
                            ++n2;
                        }
                        return null;
                    }
                });
                if (result != null) {
                    return result;
                }
            }
            catch (CoreException coreException) {}
        }
        return super.createCommand(object, domain, commandClass, commandParameter);
    }

    protected Command createPrimaryDragAndDropCommand(EditingDomain domain, Object owner, float location, int operations, int operation, Collection<?> collection) {
        final ArrayList<IPath> paths = new ArrayList<IPath>();
        for (Object value : collection) {
            if (!"org.eclipse.egit.ui.internal.repository.tree.RepositoryNode".equals(value.getClass().getName())) continue;
            paths.add((IPath)ReflectUtil.invokeMethod((String)"getPath", value));
        }
        if (collection.size() == paths.size()) {
            return new TargletDragAndDropCommand(domain, owner, location, operations, operation, collection){

                protected boolean prepareDropCopyOn() {
                    this.dragCommand = IdentityCommand.INSTANCE;
                    this.dropCommand = new CompoundCommand(Integer.MAX_VALUE){

                        public void execute() {
                            TargletTask targletTask = (TargletTask)owner;
                            ArrayList<Requirement> requirements = new ArrayList<Requirement>();
                            for (Targlet otherTarglet : targletTask.getTarglets()) {
                                for (Requirement requirement : otherTarglet.getRequirements()) {
                                    requirements.add(requirement);
                                }
                            }
                            for (IPath path : paths) {
                                Targlet targlet = TargletFactory.eINSTANCE.createTarglet();
                                SourceLocator sourceLocator = ResourcesFactory.eINSTANCE.createSourceLocator(path.toString(), true);
                                WorkspaceIUAnalyzer workspaceIUAnalyzer = new WorkspaceIUAnalyzer();
                                workspaceIUAnalyzer.analyze(sourceLocator, IUGenerator.DEFAULTS, (IProgressMonitor)new NullProgressMonitor());
                                Map workspaceIUInfos = workspaceIUAnalyzer.getWorkspaceIUInfos();
                                Set ius = workspaceIUInfos.keySet();
                                Iterator it = workspaceIUInfos.entrySet().iterator();
                                block3: while (it.hasNext()) {
                                    Map.Entry entry = it.next();
                                    String id = ((IInstallableUnit)entry.getKey()).getId();
                                    if (!id.endsWith(".plain.project")) continue;
                                    WorkspaceIUInfo value = (WorkspaceIUInfo)entry.getValue();
                                    for (Map.Entry entry2 : workspaceIUInfos.entrySet()) {
                                        if (entry2 == entry || !((WorkspaceIUInfo)entry2.getValue()).equals((Object)value)) continue;
                                        it.remove();
                                        continue block3;
                                    }
                                }
                                HashSet allIUs = new HashSet(ius);
                                HashSet<Requirement> redundant = new HashSet<Requirement>();
                                CollectionResult queryable = new CollectionResult(allIUs);
                                for (IInstallableUnit rootIU : allIUs) {
                                    for (IRequirement iRequirement : rootIU.getRequirements()) {
                                        if (!(iRequirement instanceof IRequiredCapability)) continue;
                                        IRequiredCapability requiredCapability = (IRequiredCapability)iRequirement;
                                        String namespace = requiredCapability.getNamespace();
                                        if ("org.eclipse.equinox.p2.iu".equals(namespace)) {
                                            String name = requiredCapability.getName();
                                            for (Requirement otherRequirement : requirements) {
                                                if (!name.equals(otherRequirement.getName())) continue;
                                                redundant.add(otherRequirement);
                                            }
                                        }
                                        for (IInstallableUnit iu : P2Util.asIterable((IQueryResult)queryable.query(QueryUtil.createMatchQuery((IExpression)iRequirement.getMatches(), (Object[])new Object[0]), null))) {
                                            ius.remove(iu);
                                        }
                                    }
                                }
                                targlet.setName(this.getTargletName("Default"));
                                EList targletRequirements = targlet.getRequirements();
                                for (IInstallableUnit iu : new TreeSet(ius)) {
                                    Requirement requirement = P2Factory.eINSTANCE.createRequirement(iu.getId());
                                    IMatchExpression filter = iu.getFilter();
                                    if (filter != null) {
                                        requirement.setMatchExpression(filter);
                                    }
                                    targletRequirements.add((Object)requirement);
                                }
                                sourceLocator.setRootFolder(this.getSourceLocation(path));
                                targlet.getSourceLocators().add((Object)sourceLocator);
                                this.appendAndExecute((Command)new AddCommand(domain, (EObject)targletTask, (EStructuralFeature)SetupTargletsPackage.Literals.TARGLET_TASK__TARGLETS, (Object)targlet));
                                if (redundant.isEmpty()) continue;
                                this.appendAndExecute(DeleteCommand.create((EditingDomain)domain, redundant));
                            }
                        }

                        private String getSourceLocation(IPath path) {
                            TargletTask targletTask = (TargletTask)owner;
                            Resource resource = targletTask.eResource();
                            if (resource != null) {
                                String candidate = null;
                                TreeIterator it = resource.getAllContents();
                                while (it.hasNext()) {
                                    EStructuralFeature eStructuralFeature;
                                    SetupTask setupTask;
                                    String id;
                                    EObject eObject = (EObject)it.next();
                                    EClass eClass = eObject.eClass();
                                    if (!"GitCloneTask".equals(eClass.getName()) || !(eObject instanceof SetupTask) || StringUtil.isEmpty((String)(id = (setupTask = (SetupTask)eObject).getID())) || (eStructuralFeature = eClass.getEStructuralFeature("remoteURI")) == null) continue;
                                    String result = "${" + id + ".location}";
                                    if (candidate != null) {
                                        candidate = result;
                                    }
                                    String remoteURI = (String)eObject.eGet(eStructuralFeature);
                                    try {
                                        URI uri = URI.createURI((String)remoteURI);
                                        if (!uri.isHierarchical()) {
                                            uri = URI.createURI((String)uri.opaquePart());
                                        }
                                        if ("git".equals(uri.fileExtension())) {
                                            uri = uri.trimFileExtension();
                                        }
                                        String baseName = URI.decode((String)uri.lastSegment());
                                        if (!path.toString().endsWith("/" + baseName)) continue;
                                        break;
                                    }
                                    catch (Throwable throwable) {}
                                }
                                if (candidate != null) {
                                    return candidate;
                                }
                            }
                            return path.toString();
                        }

                        protected boolean prepare() {
                            return true;
                        }
                    };
                    return this.dropCommand.canExecute();
                }
            };
        }
        return super.createPrimaryDragAndDropCommand(domain, owner, location, operations, operation, collection);
    }

    public ResourceLocator getResourceLocator() {
        return SetupTargletsEditPlugin.INSTANCE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LocaleItemLabelProvider
    implements IItemLabelProvider {
        private final AdapterFactoryItemDelegator itemDelegator;
        private Map<String, String> localeMap;

        public LocaleItemLabelProvider(AdapterFactoryItemDelegator itemDelegator) {
            this.itemDelegator = itemDelegator;
        }

        public Object getImage(Object object) {
            return this.itemDelegator.getImage(object);
        }

        public String getText(Object object) {
            return this.getLocaleMap().get(object);
        }

        public Map<String, String> getLocaleMap() {
            if (this.localeMap == null) {
                this.localeMap = new HashMap<String, String>();
                Locale[] localeArray = Locale.getAvailableLocales();
                int n = localeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Locale locale = localeArray[n2];
                    this.localeMap.put(locale.toString(), String.valueOf(locale.toString()) + " - " + locale.getDisplayName());
                    ++n2;
                }
            }
            return this.localeMap;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TargletDragAndDropCommand
    extends DragAndDropCommand {
        public TargletDragAndDropCommand(EditingDomain domain, Object owner, float location, int operations, int operation, Collection<?> collection) {
            super(domain, owner, location, operations, operation, collection, true);
        }

        protected String getTargletName(String defaultName) {
            TargletTask targletTask = (TargletTask)this.owner;
            Scope scope = targletTask.getScope();
            while (scope != null) {
                if (scope instanceof Project) {
                    String label = scope.getLabel();
                    if (StringUtil.isEmpty((String)label)) {
                        label = StringUtil.cap((String)scope.getName());
                    }
                    return label;
                }
                scope = scope.getParentScope();
            }
            return defaultName;
        }
    }
}

