/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.core;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.internal.core.P2CorePlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RootAnalyzer {
    private RootAnalyzer() {
    }

    public static Set<IInstallableUnit> getRootUnits(IQueryable<IInstallableUnit> queryable, IProgressMonitor monitor) {
        HashSet<IInstallableUnit> rootIUs = new HashSet<IInstallableUnit>();
        for (IInstallableUnit iu : P2Util.asIterable(queryable.query(QueryUtil.createIUAnyQuery(), null))) {
            P2CorePlugin.checkCancelation((IProgressMonitor)monitor);
            String id = iu.getId();
            if (id.endsWith(".source") || id.endsWith(".source.feature.group") || "true".equalsIgnoreCase(iu.getProperty("org.eclipse.equinox.p2.type.category")) || "true".equalsIgnoreCase(iu.getProperty("org.eclipse.equinox.p2.type.product"))) continue;
            rootIUs.add(iu);
        }
        RootAnalyzer.removeImplicitUnits(rootIUs, queryable, monitor);
        return rootIUs;
    }

    public static void removeImplicitUnits(Map<IMetadataRepository, Set<IInstallableUnit>> result, IProgressMonitor monitor) {
        for (Map.Entry<IMetadataRepository, Set<IInstallableUnit>> entry : result.entrySet()) {
            IMetadataRepository metadataRepository = entry.getKey();
            Set<IInstallableUnit> ius = entry.getValue();
            RootAnalyzer.removeImplicitUnits(ius, (IQueryable<IInstallableUnit>)metadataRepository, monitor);
        }
    }

    public static void removeImplicitUnits(Set<IInstallableUnit> ius, IQueryable<IInstallableUnit> queryable, IProgressMonitor monitor) {
        HashSet<IInstallableUnit> rootIUs = new HashSet<IInstallableUnit>(ius);
        HashSet<IInstallableUnit> visitedIUs = new HashSet<IInstallableUnit>();
        for (IInstallableUnit iu : ius) {
            RootAnalyzer.removeImplicitUnits(iu, rootIUs, visitedIUs, queryable, monitor);
        }
        if (rootIUs.size() < ius.size()) {
            ius.retainAll(rootIUs);
        }
    }

    private static void removeImplicitUnits(IInstallableUnit iu, Set<IInstallableUnit> rootIUs, Set<IInstallableUnit> visitedIUs, IQueryable<IInstallableUnit> queryable, IProgressMonitor monitor) {
        if (visitedIUs.add(iu)) {
            for (IRequirement requirement : iu.getRequirements()) {
                for (IInstallableUnit requiredIU : P2Util.asIterable(queryable.query(QueryUtil.createMatchQuery((IExpression)requirement.getMatches(), (Object[])new Object[0]), null))) {
                    P2CorePlugin.checkCancelation((IProgressMonitor)monitor);
                    if (iu.equals((Object)requiredIU)) continue;
                    rootIUs.remove(requiredIU);
                    RootAnalyzer.removeImplicitUnits(requiredIU, rootIUs, visitedIUs, queryable, monitor);
                }
            }
        }
    }
}

