/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.extractor.lib.tests;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.oomph.extractor.lib.BINDescriptor;
import org.eclipse.oomph.extractor.lib.JREData;
import org.junit.Assert;

public class BINDescriptorTest {
    public static void main(String[] args) throws IOException {
        int major = 1;
        int minor = 7;
        int micro = 0;
        int bitness = 64;
        int jdk = 0;
        String launcherPath = "eclipse-inst.exe";
        String iniPath = "eclipse-inst.ini";
        String content = major + " " + minor + " " + micro + " " + bitness + " " + jdk + " " + launcherPath + " " + iniPath;
        ByteArrayInputStream stream = new ByteArrayInputStream(content.getBytes());
        BINDescriptor descriptor = new BINDescriptor((InputStream)stream);
        JREData jre = descriptor.getJRE();
        Assert.assertEquals((String)"major", (long)major, (long)jre.getMajor());
        Assert.assertEquals((String)"minor", (long)minor, (long)jre.getMinor());
        Assert.assertEquals((String)"micro", (long)micro, (long)jre.getMicro());
        Assert.assertEquals((String)"bitness", (long)bitness, (long)jre.getBitness());
        Assert.assertEquals((String)"jdk", (long)jdk, (long)descriptor.getJDK());
        Assert.assertEquals((String)"launcherPath", (Object)launcherPath, (Object)descriptor.getLauncherPath());
        Assert.assertEquals((String)"iniPath", (Object)iniPath, (Object)descriptor.getIniPath());
        System.out.println("SUCCESS");
    }
}

