/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.workingsets.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIHandlerImpl;
import org.eclipse.oomph.util.IOExceptionWithCause;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferencesURIHandlerImpl
extends URIHandlerImpl {
    private static final IEclipsePreferences ROOT = Platform.getPreferencesService().getRootNode();

    public boolean canHandle(URI uri) {
        return "preference".equals(uri.scheme());
    }

    public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
        final PreferenceAccessor accessor = new PreferenceAccessor(uri.trimSegments(1));
        return new ByteArrayOutputStream(){

            public void close() throws IOException {
                accessor.put(new String(this.toByteArray(), "UTF-8"));
            }
        };
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        URI preferencePath = uri.trimSegments(1);
        String value = new PreferenceAccessor(preferencePath).get();
        if (value == null) {
            throw new IOException("No preference value available for " + preferencePath);
        }
        return new URIConverter.ReadableInputStream(value);
    }

    public void delete(URI uri, Map<?, ?> options) throws IOException {
        new PreferenceAccessor(uri.trimSegments(1)).remove();
    }

    public boolean exists(URI uri, Map<?, ?> options) {
        return new PreferenceAccessor(uri.trimSegments(1)).get() != null;
    }

    public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
        return Collections.emptyMap();
    }

    public void setAttributes(URI uri, Map<String, ?> attributes, Map<?, ?> options) throws IOException {
    }

    protected static class PreferenceAccessor {
        private final Preferences preferences;
        private final String key;

        public PreferenceAccessor(URI uri) {
            IEclipsePreferences node = ROOT;
            String[] stringArray = uri.trimSegments(1).segments();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                node = node.node(name);
                ++n2;
            }
            this.key = uri.lastSegment();
            this.preferences = node;
        }

        public String get() {
            return this.preferences.get(this.key, null);
        }

        public void put(String value) throws IOException {
            this.preferences.put(this.key, value);
            this.flush();
        }

        public void remove() throws IOException {
            this.preferences.remove(this.key);
            this.flush();
        }

        private void flush() throws IOException {
            try {
                this.preferences.flush();
            }
            catch (BackingStoreException ex) {
                throw new IOExceptionWithCause((Throwable)ex);
            }
        }
    }
}

