/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.targlets.internal.core;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.oomph.targlets.Targlet;
import org.eclipse.oomph.targlets.TargletContainer;
import org.eclipse.oomph.targlets.TargletFactory;
import org.eclipse.oomph.targlets.core.ITargletContainer;
import org.eclipse.oomph.targlets.internal.core.TargletContainerDescriptorManager;
import org.eclipse.oomph.targlets.internal.core.TargletsCorePlugin;

public class TargletContainerResourceFactory
implements Resource.Factory {
    public static final String PROTOCOL_NAME = "targlet_container";
    public static final String OPTION_MIRRORS = "MIRRORS";

    public Resource createResource(URI uri) {
        String id = uri.opaquePart();
        final ITargletContainer targletContainer = TargletContainerDescriptorManager.getContainer(id);
        final TargletContainer wrapper = TargletFactory.eINSTANCE.createTargletContainer();
        wrapper.setID(id);
        ResourceImpl resource = new ResourceImpl(uri){

            public void save(Map<?, ?> options) throws IOException {
                if (targletContainer != null) {
                    boolean mirrors = options != null && options.containsKey(TargletContainerResourceFactory.OPTION_MIRRORS) ? (Boolean)options.get(TargletContainerResourceFactory.OPTION_MIRRORS) : (this.defaultSaveOptions != null ? (Boolean)this.defaultSaveOptions.get(TargletContainerResourceFactory.OPTION_MIRRORS) : Boolean.TRUE);
                    try {
                        targletContainer.setTarglets((Collection<? extends Targlet>)wrapper.getTarglets());
                        targletContainer.forceUpdate(false, mirrors, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException ex) {
                        TargletsCorePlugin.INSTANCE.log(ex, 2);
                    }
                }
            }
        };
        if (targletContainer != null) {
            wrapper.getTarglets().addAll(targletContainer.getTarglets());
        }
        resource.getContents().add((Object)wrapper);
        return resource;
    }
}

