/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.internal.views.markers.MarkerEntry;
import org.eclipse.ui.internal.views.markers.MockMarkerEntry;
import org.eclipse.ui.views.markers.MarkerItem;

public class MarkerSortUtil {
    private static int BATCH_SIZE = Integer.getInteger("org.eclipse.ui.MarkerSortUtil.batchSize", Integer.MAX_VALUE);
    private static float MERGE_OR_HEAP_SWITCH = 1.5f;

    private static void partiallySort(MarkerEntry[] array, int first, int middle, int last, Comparator<MarkerItem> comparator) {
        MarkerSortUtil.heapify(array, first, middle, comparator);
        MarkerSortUtil.adjustMaxElement(array, first, middle, last, comparator);
        MarkerSortUtil.heapToSortedArray(array, first, middle, comparator);
    }

    private static void adjustMaxElement(MarkerEntry[] heapArray, int first, int heapSize, int last, Comparator<MarkerItem> comparator) {
        int current = heapSize;
        while (current <= last) {
            if (comparator.compare(heapArray[current], heapArray[first]) < 0) {
                MarkerEntry tmp = heapArray[current];
                heapArray[current] = heapArray[first];
                heapArray[first] = tmp;
                MarkerSortUtil.adjustHeap(heapArray, first, first, heapSize, comparator);
            }
            heapArray[current].clearCache();
            ++current;
        }
        MarkerEntry.clearCollationCache();
    }

    private static void adjustHeap(MarkerEntry[] array, int first, int position, int last, Comparator<MarkerItem> comparator) {
        MarkerEntry hole = array[position];
        int holeIndex = position;
        holeIndex = MarkerSortUtil.leafSearch(array, first, holeIndex, last, comparator);
        holeIndex = MarkerSortUtil.bottomUpSearch(array, first, holeIndex, position, hole, last, comparator);
        array[holeIndex] = hole;
    }

    private static int leafSearch(MarkerEntry[] array, int first, int position, int last, Comparator<MarkerItem> comparator) {
        int holeOffset = position - first;
        int len = last - first;
        int childOffset = 2 * holeOffset + 2;
        while (childOffset < len) {
            if (comparator.compare(array[first + childOffset], array[first + (childOffset - 1)]) < 0) {
                --childOffset;
            }
            array[first + holeOffset] = array[first + childOffset];
            holeOffset = childOffset++;
            childOffset *= 2;
        }
        if (childOffset-- == len) {
            array[first + holeOffset] = array[first + childOffset];
            holeOffset = childOffset;
        }
        return holeOffset + first;
    }

    private static int bottomUpSearch(MarkerEntry[] array, int first, int fromIndex, int toIndex, MarkerEntry hole, int last, Comparator<MarkerItem> comparator) {
        int holeOffset = fromIndex - first;
        int parent = (holeOffset - 1) / 2;
        int top = toIndex - first;
        while (holeOffset != top && comparator.compare(array[first + parent], hole) < 0) {
            array[first + holeOffset] = array[first + parent];
            holeOffset = parent;
            parent = (holeOffset - 1) / 2;
        }
        return first + holeOffset;
    }

    private static void heapify(MarkerEntry[] array, int first, int last, Comparator<MarkerItem> comparator) {
        if (last - first < 2) {
            return;
        }
        int parent = (last - first - 2) / 2;
        do {
            MarkerSortUtil.adjustHeap(array, first, first + parent, last, comparator);
        } while (parent-- != 0);
    }

    private static void heapToSortedArray(MarkerEntry[] array, int first, int last, Comparator<MarkerItem> comparator) {
        while (last - first > 1) {
            array[last].clearCache();
            MarkerEntry tmp = array[--last];
            array[last] = array[first];
            array[first] = tmp;
            MarkerSortUtil.adjustHeap(array, first, first, last, comparator);
        }
        array[first + 1].clearCache();
        array[first].clearCache();
    }

    public static void sortStartingKElement(MarkerEntry[] entries, Comparator<MarkerItem> comparator, int from, int to, int k, IProgressMonitor monitor) {
        int last = from + k - 1;
        if (entries.length == 0 || from < 0 || from >= to || last < from || last > to || to > entries.length - 1 || to < 0) {
            return;
        }
        int n = to - from + 1;
        if (BATCH_SIZE == Integer.MAX_VALUE || n <= BATCH_SIZE && (float)n / (float)k <= MERGE_OR_HEAP_SWITCH) {
            Arrays.sort(entries, from, to + 1, comparator);
            int i = from;
            while (i <= to) {
                entries[i].clearCache();
                ++i;
            }
            MarkerEntry.clearCollationCache();
            return;
        }
        int totalBatches = (k - 1) / BATCH_SIZE;
        int batchCount = 0;
        while (totalBatches > 0) {
            if (monitor.isCanceled()) {
                return;
            }
            int fromTemp = from + batchCount * BATCH_SIZE;
            int toTemp = from + (batchCount + 1) * BATCH_SIZE;
            MarkerSortUtil.partiallySort(entries, fromTemp, toTemp, to, comparator);
            ++batchCount;
            --totalBatches;
        }
        if (monitor.isCanceled()) {
            return;
        }
        if (last >= from + batchCount * BATCH_SIZE) {
            if (last == to) {
                MarkerSortUtil.partiallySort(entries, from + batchCount * BATCH_SIZE, last, to, comparator);
            } else {
                MarkerSortUtil.partiallySort(entries, from + batchCount * BATCH_SIZE, last + 1, to, comparator);
            }
        }
    }

    public static void sortStartingKElement(MockMarkerEntry[] fArray1, Comparator<MarkerItem> comparator, int from, int k, int limit) {
        MarkerSortUtil.sortStartingKElement(fArray1, comparator, from, k, limit, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void sortStartingKElement(MarkerEntry[] entries, Comparator<MarkerItem> comparator, int k, IProgressMonitor monitor) {
        MarkerSortUtil.sortStartingKElement(entries, comparator, 0, entries.length - 1, k, monitor);
    }

    public static void sortStartingKElement(MarkerEntry[] entries, Comparator<MarkerItem> comparator, int from, int k, IProgressMonitor monitor) {
        MarkerSortUtil.sortStartingKElement(entries, comparator, from, entries.length - 1, k, monitor);
    }
}

