/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.sdk;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.artifact.processors.pgp.PGPPublicKeyStore;
import org.eclipse.equinox.internal.p2.engine.phases.CertificateChecker;
import org.eclipse.equinox.internal.p2.ui.dialogs.PGPPublicKeyViewDialog;
import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKMessages;
import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKUIActivator;
import org.eclipse.equinox.internal.p2.ui.viewers.CertificateLabelProvider;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.repository.spi.PGPPublicKeyService;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.widgets.ButtonFactory;
import org.eclipse.jface.widgets.CompositeFactory;
import org.eclipse.jface.widgets.LabelFactory;
import org.eclipse.jface.widgets.TableFactory;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.framework.Bundle;

public class TrustPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String EXPORT_FILTER_PATH = "exportFilterPath";
    private static final String ADD_FILTER_PATH = "addFilterPath";
    private CertificateChecker certificateChecker;
    private Set<Certificate> trustedCertificates;
    private PGPPublicKeyStore trustedKeys;
    private Map<PGPPublicKey, Set<Bundle>> contributedTrustedKeys;
    private boolean dirty;
    private TableViewer viewer;

    public TrustPreferencePage() {
        super(ProvSDKMessages.TrustPreferencePage_title);
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        IProvisioningAgent provisioningAgent = ProvSDKUIActivator.getDefault().getProvisioningAgent();
        this.certificateChecker = new CertificateChecker(provisioningAgent);
        this.certificateChecker.setProfile(((IProfileRegistry)provisioningAgent.getService(IProfileRegistry.class)).getProfile("_SELF_"));
        this.trustedCertificates = new LinkedHashSet<Certificate>(this.certificateChecker.getPreferenceTrustedCertificates());
        this.contributedTrustedKeys = this.certificateChecker.getContributedTrustedKeys();
        this.trustedKeys = this.certificateChecker.getPreferenceTrustedKeys();
        Composite res = new Composite(parent, 0);
        res.setLayout((Layout)new GridLayout(2, false));
        GridData data = new GridData(4, -1, true, false, 2, 1);
        data.widthHint = this.convertWidthInCharsToPixels(90);
        LabelFactory factory = (LabelFactory)((LabelFactory)WidgetFactory.label((int)64).text(ProvSDKMessages.TrustPreferencePage_pgpIntro).font(parent.getFont())).layoutData((Object)data);
        factory.create((Widget)res);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        Composite tableComposite = (Composite)((CompositeFactory)((CompositeFactory)WidgetFactory.composite((int)0).layoutData((Object)new GridData(4, 4, true, true))).layout((Layout)tableColumnLayout)).create((Widget)res);
        Table keyTable = (Table)((TableFactory)WidgetFactory.table((int)68354).headerVisible(true).linesVisible(true).font(parent.getFont())).create((Widget)tableComposite);
        this.viewer = new TableViewer(keyTable);
        keyTable.setHeaderVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        TableViewerColumn typeColumn = this.createColumn(this.viewer, ProvSDKMessages.TrustPreferencePage_TypeColumn, key -> "PGP", cert -> "x509", tableColumnLayout, 1);
        this.createColumn(this.viewer, ProvSDKMessages.TrustPreferencePage_FingerprintIdColumn, key -> PGPPublicKeyService.toHexFingerprint((PGPPublicKey)key), cert -> cert.getSerialNumber().toString(), tableColumnLayout, 10);
        this.createColumn(this.viewer, ProvSDKMessages.TrustPreferencePage_NameColumn, key -> {
            ArrayList userIds = new ArrayList();
            key.getUserIDs().forEachRemaining(userIds::add);
            return String.join((CharSequence)", ", userIds);
        }, cert -> CertificateLabelProvider.getText((X509Certificate)cert), tableColumnLayout, 15);
        this.createColumn(this.viewer, ProvSDKMessages.TrustPreferencePage_Contributor, key -> {
            Set<Bundle> bundles;
            LinkedHashSet<String> contributors = new LinkedHashSet<String>();
            if (this.trustedKeys.all().contains(key)) {
                contributors.add(ProvSDKMessages.TrustPreferencePage_PreferenceContributor);
            }
            if ((bundles = this.contributedTrustedKeys.get(key)) != null) {
                TreeSet bundleContributors = new TreeSet(Policy.getComparator());
                bundles.stream().map(bundle -> this.getBundleName((Bundle)bundle)).forEach(bundleContributors::add);
                contributors.addAll(bundleContributors);
            }
            return String.join((CharSequence)", ", contributors);
        }, cert -> ProvSDKMessages.TrustPreferencePage_PreferenceContributor, tableColumnLayout, this.contributedTrustedKeys.isEmpty() ? 8 : 15);
        this.createColumn(this.viewer, ProvSDKMessages.TrustPreferencePage_ValidityColumn, pgp -> {
            if (pgp.getCreationTime().after(Date.from(Instant.now()))) {
                return NLS.bind((String)ProvSDKMessages.TrustPreferencePage_DateNotYetValid, (Object)pgp.getCreationTime());
            }
            long validSeconds = pgp.getValidSeconds();
            if (validSeconds == 0L) {
                return ProvSDKMessages.TrustPreferencePage_DateValid;
            }
            Instant expires = pgp.getCreationTime().toInstant().plus(validSeconds, ChronoUnit.SECONDS);
            return expires.isBefore(Instant.now()) ? NLS.bind((String)ProvSDKMessages.TrustPreferencePage_DateExpiredSince, (Object)expires) : NLS.bind((String)ProvSDKMessages.TrustPreferencePage_DataValidExpires, (Object)expires);
        }, x509 -> {
            try {
                x509.checkValidity();
                return ProvSDKMessages.TrustPreferencePage_DateValid;
            }
            catch (CertificateExpiredException certificateExpiredException) {
                return ProvSDKMessages.TrustPreferencePage_DateExpired;
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                return ProvSDKMessages.TrustPreferencePage_DateNotYetvalid;
            }
        }, tableColumnLayout, 8);
        this.updateInput();
        Composite buttonComposite = this.createVerticalButtonBar(res);
        buttonComposite.setLayoutData((Object)new GridData(-1, 1, false, false));
        Button exportButton = new Button(buttonComposite, 8);
        exportButton.setText(ProvSDKMessages.TrustPreferencePage_export);
        this.setVerticalButtonLayoutData(exportButton);
        exportButton.setEnabled(false);
        exportButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            Object element = this.viewer.getStructuredSelection().getFirstElement();
            FileDialog dialog = new FileDialog(this.getShell(), 8192);
            dialog.setFilterPath(this.getFilterPath(EXPORT_FILTER_PATH));
            dialog.setText(ProvSDKMessages.TrustPreferencePage_fileExportTitle);
            dialog.setFilterExtensions(new String[]{"*.asc"});
            FileDialog destination = new FileDialog(exportButton.getShell(), 8192);
            destination.setFilterPath(this.getFilterPath(EXPORT_FILTER_PATH));
            destination.setText(ProvSDKMessages.TrustPreferencePage_Export);
            if (element instanceof X509Certificate) {
                X509Certificate cert = (X509Certificate)element;
                destination.setFilterExtensions(new String[]{"*.der"});
                destination.setFileName(String.valueOf(cert.getSerialNumber().toString()) + ".der");
                String path = destination.open();
                this.setFilterPath(EXPORT_FILTER_PATH, destination.getFilterPath());
                if (path == null) {
                    return;
                }
                File destinationFile = new File(path);
                try {
                    Throwable throwable = null;
                    Object var10_18 = null;
                    try (FileOutputStream output = new FileOutputStream(destinationFile);){
                        output.write(cert.getEncoded());
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException | CertificateEncodingException ex) {
                    ProvSDKUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.equinox.p2.ui.sdk", ex.getMessage(), (Throwable)ex));
                }
            } else {
                PGPPublicKey key = (PGPPublicKey)element;
                destination.setFilterExtensions(new String[]{"*.asc"});
                destination.setFileName(String.valueOf(PGPPublicKeyService.toHexFingerprint((PGPPublicKey)key)) + ".asc");
                String path = destination.open();
                this.setFilterPath(EXPORT_FILTER_PATH, destination.getFilterPath());
                if (path == null) {
                    return;
                }
                File destinationFile = new File(path);
                try {
                    Throwable ex = null;
                    Object var10_20 = null;
                    try (ArmoredOutputStream output = new ArmoredOutputStream((OutputStream)new FileOutputStream(destinationFile));){
                        key.encode((OutputStream)output);
                    }
                    catch (Throwable throwable) {
                        if (ex == null) {
                            ex = throwable;
                        } else if (ex != throwable) {
                            ex.addSuppressed(throwable);
                        }
                        throw ex;
                    }
                }
                catch (IOException ex) {
                    ProvSDKUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.equinox.p2.ui.sdk", ex.getMessage(), (Throwable)ex));
                }
            }
        }));
        Button addButton = new Button(buttonComposite, 8);
        addButton.setText(ProvSDKMessages.TrustPreferencePage_addPGPKeyButtonLabel);
        addButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            FileDialog dialog = new FileDialog(this.getShell(), 4096);
            dialog.setFilterPath(this.getFilterPath(ADD_FILTER_PATH));
            dialog.setText(ProvSDKMessages.TrustPreferencePage_fileImportTitle);
            dialog.setFilterExtensions(new String[]{"*.asc;*.der"});
            String path = dialog.open();
            this.setFilterPath(ADD_FILTER_PATH, dialog.getFilterPath());
            if (path == null) {
                return;
            }
            if (path.endsWith(".der")) {
                try {
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    Throwable throwable = null;
                    Object var6_10 = null;
                    try (InputStream input = Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]);){
                        Collection<? extends Certificate> certificates = certificateFactory.generateCertificates(input);
                        this.trustedCertificates.addAll(certificates);
                        this.updateInput();
                        this.viewer.setSelection((ISelection)new StructuredSelection(certificates.toArray()), true);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException | CertificateException ex) {
                    ProvSDKUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.equinox.p2.ui.sdk", ex.getMessage(), (Throwable)ex));
                }
            } else {
                HashSet oldKeys = new HashSet(this.trustedKeys.all());
                this.trustedKeys.add(new File(path));
                HashSet newKeys = new HashSet(this.trustedKeys.all());
                newKeys.removeAll(oldKeys);
                this.updateInput();
                this.viewer.setSelection((ISelection)new StructuredSelection(newKeys.toArray()), true);
            }
            this.dirty = true;
        }));
        this.setVerticalButtonLayoutData(addButton);
        Button removeButton = new Button(buttonComposite, 8);
        removeButton.setText(ProvSDKMessages.TrustPreferencePage_removePGPKeyButtonLabel);
        removeButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            for (Object key : this.getSelectedKeys()) {
                if (key instanceof PGPPublicKey) {
                    this.trustedKeys.remove((PGPPublicKey)key);
                    continue;
                }
                this.trustedCertificates.remove(key);
            }
            this.updateInput();
            this.dirty = true;
        }));
        removeButton.setEnabled(false);
        this.setVerticalButtonLayoutData(removeButton);
        Runnable details = () -> {
            Object element = this.viewer.getStructuredSelection().getFirstElement();
            if (element instanceof X509Certificate) {
                CertificateLabelProvider.openDialog((Shell)this.getShell(), (X509Certificate)((X509Certificate)element));
            } else {
                new PGPPublicKeyViewDialog(this.getShell(), (PGPPublicKey)element, (PGPPublicKeyService)provisioningAgent.getService(PGPPublicKeyService.class)).open();
            }
        };
        Button detailsButton = new Button(buttonComposite, 8);
        detailsButton.setText(ProvSDKMessages.TrustPreferencePage_Details);
        detailsButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> details.run()));
        detailsButton.setEnabled(false);
        this.setVerticalButtonLayoutData(detailsButton);
        this.viewer.addPostSelectionChangedListener(e -> {
            List<Object> selectedKeys = this.getSelectedKeys();
            exportButton.setEnabled(selectedKeys.size() == 1);
            Collection keys = this.trustedKeys.all();
            removeButton.setEnabled(selectedKeys.stream().anyMatch(o -> keys.contains(o) || this.trustedCertificates.contains(o)));
            detailsButton.setEnabled(selectedKeys.size() == 1);
        });
        Button trustAllButton = (Button)((ButtonFactory)WidgetFactory.button((int)32).text(ProvSDKMessages.TrustPreferencePage_TrustAll).font(JFaceResources.getDialogFont())).create((Widget)res);
        this.setButtonLayoutData((Button)trustAllButton).verticalSpan = 2;
        trustAllButton.setSelection(this.certificateChecker.isTrustAlways());
        trustAllButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (trustAllButton.getSelection()) {
                MessageDialog messageDialog = new MessageDialog(this.getShell(), ProvSDKMessages.TrustPreferencePage_TrustAllConfirmationTitle, null, ProvSDKMessages.TrustPreferencePage_TrustAllConfirmationDescription, 3, new String[]{ProvSDKMessages.TrustPreferencePage_TrustAllYes, ProvSDKMessages.TrustPreferencePage_TrustAllNo}, 1){

                    public Image getImage() {
                        return this.getWarningImage();
                    }
                };
                int result = messageDialog.open();
                if (result != 0) {
                    this.certificateChecker.setTrustAlways(false);
                    trustAllButton.setSelection(false);
                } else {
                    this.certificateChecker.setTrustAlways(true);
                }
            } else {
                this.certificateChecker.setTrustAlways(false);
            }
        }));
        this.viewer.addDoubleClickListener(e -> details.run());
        typeColumn.getColumn().pack();
        this.createMenu();
        return res;
    }

    private void createMenu() {
        Control control = this.viewer.getControl();
        Menu menu = new Menu(control);
        control.setMenu(menu);
        MenuItem item = new MenuItem(menu, 8);
        item.setText(ProvSDKMessages.TrustPreferencePage_CopyFingerprint);
        item.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            Object element = this.viewer.getStructuredSelection().getFirstElement();
            if (element instanceof PGPPublicKey) {
                Clipboard clipboard = new Clipboard(this.getShell().getDisplay());
                clipboard.setContents(new Object[]{PGPPublicKeyService.toHexFingerprint((PGPPublicKey)((PGPPublicKey)element))}, new Transfer[]{TextTransfer.getInstance()});
                clipboard.dispose();
            }
        }));
        this.viewer.addSelectionChangedListener(e -> item.setEnabled(this.viewer.getStructuredSelection().getFirstElement() instanceof PGPPublicKey));
    }

    private TableViewerColumn createColumn(TableViewer tableViewer, String text, Function<PGPPublicKey, String> pgpMap, Function<X509Certificate, String> x509Map, TableColumnLayout tableColumnLayout, int columnWeight) {
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        column.getColumn().setText(text);
        column.setLabelProvider((CellLabelProvider)new PGPOrX509ColumnLabelProvider(pgpMap, x509Map));
        tableColumnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(columnWeight));
        return column;
    }

    private void updateInput() {
        AbstractSet input = new TreeSet((k1, k2) -> Arrays.compare(k1.getFingerprint(), k2.getFingerprint()));
        input = new LinkedHashSet();
        Collection all = this.trustedKeys.all();
        input = new TreeSet((k1, k2) -> {
            boolean contains2;
            boolean contains1 = all.contains(k1);
            if (contains1 != (contains2 = all.contains(k2))) {
                if (contains1) {
                    return -1;
                }
                return 1;
            }
            return PGPPublicKeyService.toHexFingerprint((PGPPublicKey)k1).compareTo(PGPPublicKeyService.toHexFingerprint((PGPPublicKey)k2));
        });
        input.addAll(all);
        input.addAll(this.contributedTrustedKeys.keySet());
        LinkedHashSet<Certificate> allInput = new LinkedHashSet<Certificate>();
        allInput.addAll(this.trustedCertificates);
        allInput.addAll(input);
        this.viewer.setInput(allInput);
    }

    private List<Object> getSelectedKeys() {
        return this.viewer.getStructuredSelection().toList();
    }

    private Composite createVerticalButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.initializeDialogUnits((Control)composite);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 5;
        layout.marginHeight = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        return composite;
    }

    private GridData setVerticalButtonLayoutData(Button button) {
        GridData data = new GridData(256);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        Point minSize = button.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minSize.x);
        button.setLayoutData((Object)data);
        return data;
    }

    private String getFilterPath(String key) {
        IDialogSettings dialogSettings = DialogSettings.getOrCreateSection((IDialogSettings)ProvSDKUIActivator.getDefault().getDialogSettings(), (String)((Object)((Object)this)).getClass().getName());
        String filterPath = dialogSettings.get(key);
        if (filterPath == null) {
            filterPath = System.getProperty("user.home");
        }
        return filterPath;
    }

    private void setFilterPath(String key, String filterPath) {
        if (filterPath != null) {
            IDialogSettings dialogSettings = DialogSettings.getOrCreateSection((IDialogSettings)ProvSDKUIActivator.getDefault().getDialogSettings(), (String)((Object)((Object)this)).getClass().getName());
            dialogSettings.put(key, filterPath);
        }
    }

    private String getBundleName(Bundle bundle) {
        String value = (String)bundle.getHeaders().get("Bundle-Name");
        return value == null ? bundle.getSymbolicName() : Platform.getResourceString((Bundle)bundle, (String)value);
    }

    protected void performDefaults() {
        this.trustedCertificates = new LinkedHashSet<Certificate>(this.certificateChecker.getPreferenceTrustedCertificates());
        this.trustedKeys = this.certificateChecker.getPreferenceTrustedKeys();
        this.updateInput();
        super.performDefaults();
    }

    public boolean performOk() {
        if (this.dirty) {
            IStatus persistTrustedCertificates = this.certificateChecker.persistTrustedCertificates(this.trustedCertificates);
            IStatus persistTrustedKeys = this.certificateChecker.persistTrustedKeys(this.trustedKeys);
            this.dirty = false;
            return persistTrustedKeys.isOK() && persistTrustedCertificates.isOK();
        }
        return true;
    }

    private static class PGPOrX509ColumnLabelProvider
    extends ColumnLabelProvider {
        private Function<PGPPublicKey, String> pgpMap;
        private Function<X509Certificate, String> x509map;

        public PGPOrX509ColumnLabelProvider(Function<PGPPublicKey, String> pgpMap, Function<X509Certificate, String> x509map) {
            this.pgpMap = pgpMap;
            this.x509map = x509map;
        }

        public String getText(Object element) {
            if (element instanceof PGPPublicKey) {
                return this.pgpMap.apply((PGPPublicKey)element);
            }
            if (element instanceof X509Certificate) {
                return this.x509map.apply((X509Certificate)element);
            }
            return super.getText(element);
        }
    }
}

