/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.handlers;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.dialogs.ShowViewDialog;
import org.eclipse.ui.internal.misc.StatusUtil;

public final class ShowViewHandler
extends AbstractHandler {
    public ShowViewHandler() {
    }

    public ShowViewHandler(boolean makeFast) {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow workbenchWindow = HandlerUtil.getActiveWorkbenchWindowChecked(event);
        EPartService partService = (EPartService)workbenchWindow.getService(EPartService.class);
        MApplication app = (MApplication)workbenchWindow.getService(MApplication.class);
        Object id = event.getParameters().get("org.eclipse.ui.views.showView.viewId");
        if (!(id instanceof String)) {
            ShowViewHandler.openOther(event, workbenchWindow, app, partService);
            return null;
        }
        MPartDescriptor viewDescriptor = ShowViewHandler.getViewDescriptor(app, (String)id);
        if (viewDescriptor == null) {
            ShowViewHandler.handleMissingView(id);
            return null;
        }
        ShowViewHandler.openView(workbenchWindow, viewDescriptor, partService);
        return null;
    }

    private static void openOther(ExecutionEvent event, IWorkbenchWindow workbenchWindow, MApplication app, EPartService partService) {
        MPartDescriptor[] descriptors;
        Shell shell = HandlerUtil.getActiveShell(event);
        IEclipseContext ctx = (IEclipseContext)workbenchWindow.getService(IEclipseContext.class);
        EModelService modelService = (EModelService)workbenchWindow.getService(EModelService.class);
        MWindow window = (MWindow)workbenchWindow.getService(MWindow.class);
        ShowViewDialog dialog = new ShowViewDialog(shell, app, window, modelService, partService, ctx);
        dialog.open();
        if (dialog.getReturnCode() == 1) {
            return;
        }
        MPartDescriptor[] mPartDescriptorArray = descriptors = dialog.getSelection();
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            MPartDescriptor descriptor = mPartDescriptorArray[n2];
            ShowViewHandler.openView(workbenchWindow, descriptor, partService);
            ++n2;
        }
    }

    private static void openView(IWorkbenchWindow window, MPartDescriptor viewDescriptor, EPartService partService) {
        String viewId = viewDescriptor.getElementId();
        if ("bundleclass://org.eclipse.ui.workbench/org.eclipse.ui.internal.e4.compatibility.CompatibilityView".equals(viewDescriptor.getContributionURI())) {
            IWorkbenchPage page = window.getActivePage();
            if (page != null) {
                try {
                    page.showView(viewId);
                }
                catch (PartInitException e) {
                    ShowViewHandler.handleViewError(viewId, e);
                }
            }
        } else {
            MPart part = partService.findPart(viewId);
            if (part == null) {
                MPlaceholder placeholder = partService.createSharedPart(viewId);
                part = (MPart)placeholder.getRef();
            }
            partService.showPart(part, EPartService.PartState.ACTIVATE);
        }
    }

    private static MPartDescriptor getViewDescriptor(MApplication app, String id) {
        List descriptors = app.getDescriptors();
        for (MPartDescriptor descriptor : descriptors) {
            if (!id.equals(descriptor.getElementId()) || !ShowViewHandler.isView(descriptor)) continue;
            return descriptor;
        }
        return null;
    }

    private static boolean isView(MPartDescriptor descriptor) {
        return descriptor.getTags().contains("View");
    }

    private static void handleViewError(String id, PartInitException e) {
        StatusUtil.handleStatus(e.getStatus(), "View could not be opened: " + id, 2);
    }

    private static void handleMissingView(Object id) {
        ExecutionException e = new ExecutionException("View could not be found: " + id);
        StatusUtil.handleStatus(e, 2);
    }
}

