/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.net.HttpCookie;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.NumberFormat;
import java.time.Instant;
import java.util.Arrays;
import java.util.Base64;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.AuthenticationEvent;
import org.eclipse.swt.browser.AuthenticationListener;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WebBrowser;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.internal.chromium.CEFFactory;
import org.eclipse.swt.internal.chromium.lib.ChromiumLib;
import org.eclipse.swt.internal.chromium.lib.FunctionSt;
import org.eclipse.swt.internal.chromium.lib.cef_app_t;
import org.eclipse.swt.internal.chromium.lib.cef_browser_process_handler_t;
import org.eclipse.swt.internal.chromium.lib.cef_client_t;
import org.eclipse.swt.internal.chromium.lib.cef_context_menu_handler_t;
import org.eclipse.swt.internal.chromium.lib.cef_cookie_visitor_t;
import org.eclipse.swt.internal.chromium.lib.cef_display_handler_t;
import org.eclipse.swt.internal.chromium.lib.cef_focus_handler_t;
import org.eclipse.swt.internal.chromium.lib.cef_jsdialog_handler_t;
import org.eclipse.swt.internal.chromium.lib.cef_life_span_handler_t;
import org.eclipse.swt.internal.chromium.lib.cef_load_handler_t;
import org.eclipse.swt.internal.chromium.lib.cef_popup_features_t;
import org.eclipse.swt.internal.chromium.lib.cef_request_handler_t;
import org.eclipse.swt.internal.chromium.lib.cef_string_visitor_t;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

abstract class Chromium
extends WebBrowser {
    private static final String SET_TEXT_URL = "swt.chromium.setText.";
    private static final String DATA_TEXT_URL = "data:text/html;base64,";
    private static final String VERSION = Library.getVersionString();
    private static final String CEFVERSION = "3071";
    private static final String SHARED_LIB_V = "chromium_swt_" + VERSION;
    private static final String JNI_LIB_V = "swt-chromium";
    private static final int MAX_PROGRESS = 100;
    private static final int LOOP = 75;
    private static final boolean debug = Boolean.valueOf(System.getProperty("swt.chromium.debug", "false"));
    private static Object lib = Chromium.loadLib();
    private static String cefrustPath;
    private static String cefPath;
    private static cef_app_t app;
    private static cef_browser_process_handler_t browserProcessHandler;
    private static boolean shuttindDown;
    private static cef_cookie_visitor_t cookieVisitor;
    private static CompletableFuture<Boolean> cookieVisited;
    private static AtomicInteger browsers;
    private static Map<Integer, Chromium> instances;
    private static int EVAL;
    private static int INSTANCES;
    private static Runnable loopWork;
    private static boolean loopDisable;
    private static boolean pumpDisable;
    private static int disposingAny;
    private static int popupHandlers;
    private static cef_client_t clientHandler;
    private static cef_focus_handler_t focusHandler;
    private static cef_life_span_handler_t lifeSpanHandler;
    private static cef_load_handler_t loadHandler;
    private static cef_display_handler_t displayHandler;
    private static cef_request_handler_t requestHandler;
    private static cef_jsdialog_handler_t jsDialogHandler;
    private static cef_context_menu_handler_t contextMenuHandler;
    private static cef_client_t popupClientHandler;
    private static cef_life_span_handler_t popupLifeSpanHandler;
    private cef_string_visitor_t textVisitor;
    Browser chromium;
    private long hwnd;
    private long browser;
    private FocusListener focusListener;
    private String url;
    private String postData;
    private String[] headers;
    private String text = "";
    private CompletableFuture<String> textReady;
    private boolean canGoBack;
    private boolean canGoForward;
    private CompletableFuture<Boolean> enableProgress = new CompletableFuture();
    private CompletableFuture<Boolean> created = new CompletableFuture();
    private Dispose disposing = Dispose.No;
    private int instance;
    private boolean hasFocus;
    private boolean ignoreFirstFocus = true;
    private PaintListener paintListener;
    private WindowEvent isPopup;
    static Runnable loopWorkRunnable;

    static {
        browsers = new AtomicInteger(0);
        instances = new HashMap<Integer, Chromium>();
        EVAL = 1;
        INSTANCES = 0;
        disposingAny = 0;
        popupHandlers = 0;
        loopWorkRunnable = () -> {
            Display display = Display.getCurrent();
            if (display == null || display.isDisposed()) {
                return;
            }
            Chromium.safe_loop_work("pump");
        };
    }

    public void setBrowser(Browser browser) {
        this.chromium = browser;
    }

    public void createFunction(BrowserFunction function) {
        this.created.thenRun(() -> {
            this.checkBrowser();
            for (BrowserFunction current : this.functions.values()) {
                if (!current.name.equals(browserFunction.name)) continue;
                this.deregisterFunction(current);
                break;
            }
            browserFunction.index = this.getNextFunctionIndex();
            this.registerFunction(function);
            if (!ChromiumLib.cefswt_function(this.browser, browserFunction.name, browserFunction.index)) {
                throw new SWTException("Cannot create BrowserFunction");
            }
        });
    }

    public void destroyFunction(BrowserFunction function) {
        this.checkBrowser();
        this.deregisterFunction(function);
    }

    public void create(Composite parent, int style) {
        this.initCEF(this.chromium.getDisplay());
        this.chromium.setBackground(parent.getDisplay().getSystemColor(37));
        this.paintListener = new PaintListener(){

            public void paintControl(PaintEvent e) {
                Chromium.this.debugPrint("paintControl");
                Chromium.this.chromium.removePaintListener((PaintListener)this);
                Chromium.this.createBrowser();
                Chromium.this.paintListener = null;
            }
        };
        this.chromium.addPaintListener(this.paintListener);
    }

    private void debugPrint(String log) {
        if (debug) {
            System.out.println("J" + this.instance + ":" + Thread.currentThread().getName() + ":" + log + (this.url != null ? " (" + Chromium.getPlainUrl(this.url) + ")" : " empty-url"));
        }
    }

    private static void debug(String log) {
        if (debug) {
            System.out.println("J:" + log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCEF(Display display) {
        Object object = lib;
        synchronized (object) {
            if (app == null) {
                Thread t;
                int i;
                app = CEFFactory.newApp();
                browserProcessHandler = CEFFactory.newBrowserProcessHandler();
                Chromium.browserProcessHandler.on_schedule_message_pump_work_cb = new Callback(Chromium.class, "on_schedule_message_pump_work", Void.TYPE, new Type[]{Long.TYPE, Integer.TYPE, Integer.TYPE});
                Chromium.browserProcessHandler.on_schedule_message_pump_work = Chromium.checkGetAddress(Chromium.browserProcessHandler.on_schedule_message_pump_work_cb);
                Chromium.app.get_browser_process_handler_cb = new Callback(Chromium.class, "get_browser_process_handler", Long.TYPE, new Type[]{Long.TYPE});
                Chromium.app.get_browser_process_handler = Chromium.checkGetAddress(Chromium.app.get_browser_process_handler_cb);
                Chromium.browserProcessHandler.ptr = C.malloc((long)cef_browser_process_handler_t.sizeof);
                ChromiumLib.memmove(Chromium.browserProcessHandler.ptr, browserProcessHandler, cef_browser_process_handler_t.sizeof);
                int debugPort = 0;
                try {
                    debugPort = Integer.parseInt(System.getProperty("org.eclipse.swt.chromium.remote-debugging-port", "0"));
                }
                catch (NumberFormatException numberFormatException) {
                    debugPort = 0;
                }
                Chromium.app.ptr = C.malloc((long)cef_app_t.sizeof);
                ChromiumLib.memmove(Chromium.app.ptr, app, cef_app_t.sizeof);
                boolean suspend = "win32".equals(SWT.getPlatform()) ? false : Boolean.getBoolean("swt.chromium.suspendThreads");
                Thread main = null;
                Thread[] threads = null;
                int threadsCount = 0;
                if (suspend) {
                    main = Thread.currentThread();
                    threads = new Thread[Thread.activeCount() * 2];
                    threadsCount = Thread.enumerate(threads);
                    i = 0;
                    while (i < threadsCount) {
                        t = threads[i];
                        if (t != main) {
                            t.suspend();
                        }
                        ++i;
                    }
                }
                ChromiumLib.cefswt_init(Chromium.app.ptr, cefrustPath, cefPath, VERSION, debugPort);
                if (suspend) {
                    i = 0;
                    while (i < threadsCount) {
                        t = threads[i];
                        if (t != main) {
                            t.resume();
                        }
                        ++i;
                    }
                }
                display.disposeExec(() -> {
                    if (app == null || shuttindDown) {
                        return;
                    }
                    Chromium.internalShutdown();
                });
            }
        }
    }

    static long get_browser_process_handler(long app) {
        if (browserProcessHandler == null) {
            return 0L;
        }
        return Chromium.browserProcessHandler.ptr;
    }

    static void on_schedule_message_pump_work(long pbrowserProcessHandler, int delay, int _delay2) {
        if (browsers.get() <= 0 || pumpDisable || disposingAny > 0) {
            return;
        }
        Display display = Display.getDefault();
        Runnable scheduleWork = () -> {
            Chromium.restartLoop(display, delay);
            display.timerExec(-1, loopWorkRunnable);
            display.timerExec(delay, loopWorkRunnable);
        };
        if (Display.getCurrent() != null) {
            if (delay <= 0) {
                Chromium.restartLoop(display, 0);
                display.asyncExec(loopWorkRunnable);
            } else {
                scheduleWork.run();
            }
        } else if (delay <= 0) {
            display.asyncExec(() -> {
                Chromium.restartLoop(display, 0);
                loopWorkRunnable.run();
            });
        } else {
            display.asyncExec(scheduleWork);
        }
    }

    private static void safe_loop_work(String from) {
        if (browsers.get() > 0 && !loopDisable) {
            if (ChromiumLib.cefswt_do_message_loop_work() == 0) {
                System.err.println("error looping chromium");
            }
            if (pumpDisable) {
                pumpDisable = false;
            }
        }
    }

    private static void restartLoop(Display display, int ms) {
        if (loopWork != null) {
            display.timerExec(-1, loopWork);
            display.timerExec(75 + ms, loopWork);
        }
    }

    protected abstract long getHandle(Composite var1);

    private void prepareBrowser() {
        this.hwnd = this.getHandle((Composite)this.chromium);
        this.chromium.addDisposeListener(e -> {
            this.debugPrint("disposing chromium");
            this.dispose();
        });
        this.focusListener = new CefFocusListener();
        this.chromium.addFocusListener(this.focusListener);
        if (INSTANCES == 0) {
            Chromium.set_client_handler();
        }
        this.chromium.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (!Chromium.this.isDisposed() && Chromium.this.browser != 0L) {
                    Point size = Chromium.this.getChromiumSize();
                    ChromiumLib.cefswt_resized(Chromium.this.browser, size.x, size.y);
                }
            }
        });
    }

    private void createBrowser() {
        if (this.url == null) {
            this.url = "about:blank";
        }
        this.prepareBrowser();
        Display display = this.chromium.getDisplay();
        Color bg = this.chromium.getBackground();
        Color bgColor = bg != null ? bg : display.getSystemColor(22);
        int cefBgColor = this.cefColor(bgColor.getAlpha(), bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue());
        Point size = this.getChromiumSize();
        this.instance = ++INSTANCES;
        Chromium.debug("Registering chromium instance " + this.instance);
        instances.put(this.instance, this);
        ChromiumLib.cefswt_create_browser(this.hwnd, this.url, Chromium.clientHandler.ptr, size.x, size.y, this.jsEnabledOnNextPage ? 1 : 0, cefBgColor);
    }

    private void createPopup(long windowInfo, long client, WindowEvent event) {
        if (this.paintListener != null) {
            this.chromium.removePaintListener(this.paintListener);
            this.paintListener = null;
        } else {
            Chromium.debug("Unregistering chromium phantom popup " + this.instance);
            instances.remove(this.instance);
        }
        this.instance = ++INSTANCES;
        Chromium.debug("Registering chromium popup " + this.instance);
        instances.put(this.instance, this);
        this.isPopup = event;
        String platform = SWT.getPlatform();
        if ("gtk".equals(platform) && this.chromium.getDisplay().getActiveShell() != this.chromium.getShell()) {
            boolean visible = this.chromium.getShell().isVisible();
            this.chromium.getShell().open();
            this.chromium.getShell().setVisible(visible);
        }
        this.prepareBrowser();
        long popupHandle = this.hwnd;
        this.debugPrint("popup will use hwnd:" + popupHandle);
        Point size = new Point(0, 0);
        if ("gtk".equals(SWT.getPlatform())) {
            size = this.chromium.getParent().getSize();
            size = DPIUtil.autoScaleUp((Point)size);
        }
        ChromiumLib.cefswt_set_window_info_parent(windowInfo, client, Chromium.clientHandler.ptr, popupHandle, 0, 0, size.x, size.y);
        this.debugPrint("reparent popup");
    }

    private void createDefaultPopup(long windowInfo, long client, WindowEvent event) {
        this.debugPrint("default popup");
        this.instance = ++INSTANCES;
        Chromium.debug("Registering chromium default popup " + this.instance);
        if (popupHandlers == 0) {
            popupLifeSpanHandler = CEFFactory.newLifeSpanHandler();
            Chromium.popupLifeSpanHandler.on_after_created_cb = new Callback(Chromium.class, "popup_on_after_created", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE});
            Chromium.popupLifeSpanHandler.on_after_created = Chromium.checkGetAddress(Chromium.popupLifeSpanHandler.on_after_created_cb);
            Chromium.popupLifeSpanHandler.on_before_close_cb = new Callback(Chromium.class, "popup_on_before_close", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE});
            Chromium.popupLifeSpanHandler.on_before_close = Chromium.checkGetAddress(Chromium.popupLifeSpanHandler.on_before_close_cb);
            Chromium.popupLifeSpanHandler.do_close_cb = new Callback(Chromium.class, "popup_do_close", Integer.TYPE, new Type[]{Long.TYPE, Long.TYPE});
            Chromium.popupLifeSpanHandler.do_close = Chromium.checkGetAddress(Chromium.popupLifeSpanHandler.do_close_cb);
            Chromium.popupLifeSpanHandler.ptr = C.malloc((long)cef_life_span_handler_t.sizeof);
            ChromiumLib.memmove(Chromium.popupLifeSpanHandler.ptr, popupLifeSpanHandler, cef_life_span_handler_t.sizeof);
            if (popupClientHandler == null) {
                popupClientHandler = CEFFactory.newClient();
                Chromium.popupClientHandler.get_life_span_handler_cb = new Callback(Chromium.class, "popup_get_life_span_handler", Long.TYPE, new Type[]{Long.TYPE});
                Chromium.popupClientHandler.get_life_span_handler = Chromium.checkGetAddress(Chromium.popupClientHandler.get_life_span_handler_cb);
                Chromium.popupClientHandler.ptr = C.malloc((long)cef_client_t.sizeof);
                ChromiumLib.memmove(Chromium.popupClientHandler.ptr, popupClientHandler, cef_client_t.sizeof);
            }
        }
        ++popupHandlers;
        ChromiumLib.cefswt_set_window_info_parent(windowInfo, client, Chromium.popupClientHandler.ptr, 0L, event.location != null ? event.location.x : 0, event.location != null ? event.location.y : 0, event.size != null ? event.size.x : 0, event.size != null ? event.size.y : 0);
    }

    static long popup_get_life_span_handler(long client) {
        if (popupLifeSpanHandler == null) {
            return 0L;
        }
        return Chromium.popupLifeSpanHandler.ptr;
    }

    static void popup_on_after_created(long plifeSpanHandler, long browser) {
        int id = ChromiumLib.cefswt_get_id(browser);
        Chromium.debug("popup on_after_created: " + id);
        try {
            Thread.sleep(75L);
        }
        catch (InterruptedException interruptedException) {}
    }

    static void popup_on_before_close(long plifeSpanHandler, long browser) {
        Chromium.debug("popup OnBeforeClose");
        if (--popupHandlers == 0) {
            Chromium.disposeCallback(Chromium.popupLifeSpanHandler.on_after_created_cb);
            Chromium.disposeCallback(Chromium.popupLifeSpanHandler.do_close_cb);
            Chromium.disposeCallback(Chromium.popupLifeSpanHandler.on_before_close_cb);
            C.free((long)Chromium.popupLifeSpanHandler.ptr);
            popupLifeSpanHandler = null;
        }
        --disposingAny;
    }

    static int popup_do_close(long plifeSpanHandler, long browser) {
        Chromium.debug("popup DoClose");
        ++disposingAny;
        return 0;
    }

    private int cefColor(int a, int r, int g, int b) {
        return a << 24 | r << 16 | g << 8 | b << 0;
    }

    private Point getChromiumSize() {
        Point size = this.chromium.getSize();
        if ("cocoa".equals(SWT.getPlatform())) {
            return size;
        }
        return DPIUtil.autoScaleUp((Point)size);
    }

    private static void set_client_handler() {
        clientHandler = CEFFactory.newClient();
        Chromium.set_focus_handler();
        Chromium.set_life_span_handler();
        Chromium.set_load_handler();
        Chromium.set_display_handler();
        Chromium.set_request_handler();
        Chromium.set_jsdialog_handler();
        Chromium.set_context_menu_handler();
        Chromium.clientHandler.on_process_message_received_cb = new Callback(Chromium.class, "on_process_message_received", Integer.TYPE, new Type[]{Long.TYPE, Long.TYPE, Integer.TYPE, Long.TYPE});
        Chromium.clientHandler.on_process_message_received = Chromium.checkGetAddress(Chromium.clientHandler.on_process_message_received_cb);
        Chromium.clientHandler.ptr = C.malloc((long)cef_client_t.sizeof);
        ChromiumLib.memmove(Chromium.clientHandler.ptr, clientHandler, cef_client_t.sizeof);
    }

    private static void set_life_span_handler() {
        lifeSpanHandler = CEFFactory.newLifeSpanHandler();
        Chromium.lifeSpanHandler.on_before_close_cb = new Callback(Chromium.class, "on_before_close", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE});
        Chromium.lifeSpanHandler.on_before_close = Chromium.checkGetAddress(Chromium.lifeSpanHandler.on_before_close_cb);
        Chromium.lifeSpanHandler.do_close_cb = new Callback(Chromium.class, "do_close", Integer.TYPE, new Type[]{Long.TYPE, Long.TYPE});
        Chromium.lifeSpanHandler.do_close = Chromium.checkGetAddress(Chromium.lifeSpanHandler.do_close_cb);
        Chromium.lifeSpanHandler.on_after_created_cb = new Callback(Chromium.class, "on_after_created", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE});
        Chromium.lifeSpanHandler.on_after_created = Chromium.checkGetAddress(Chromium.lifeSpanHandler.on_after_created_cb);
        Chromium.lifeSpanHandler.on_before_popup_cb = new Callback(Chromium.class, "on_before_popup", Integer.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Integer.TYPE});
        Chromium.lifeSpanHandler.on_before_popup = Chromium.checkGetAddress(Chromium.lifeSpanHandler.on_before_popup_cb);
        Chromium.clientHandler.get_life_span_handler_cb = new Callback(Chromium.class, "get_life_span_handler", Long.TYPE, new Type[]{Long.TYPE});
        Chromium.clientHandler.get_life_span_handler = Chromium.checkGetAddress(Chromium.clientHandler.get_life_span_handler_cb);
        Chromium.lifeSpanHandler.ptr = C.malloc((long)cef_life_span_handler_t.sizeof);
        ChromiumLib.memmove(Chromium.lifeSpanHandler.ptr, lifeSpanHandler, cef_life_span_handler_t.sizeof);
    }

    static long get_life_span_handler(long client) {
        if (lifeSpanHandler == null) {
            return 0L;
        }
        return Chromium.lifeSpanHandler.ptr;
    }

    static void on_before_close(long plifeSpanHandler, long browser) {
        int id = ChromiumLib.cefswt_get_id(browser);
        Chromium.debug("OnBeforeClose" + id);
        instances.remove(id).on_before_close(browser);
        int decrementAndGet = browsers.decrementAndGet();
        ChromiumLib.cefswt_free(browser);
        --disposingAny;
        if (decrementAndGet == 0 && shuttindDown) {
            Chromium.internalShutdown();
        }
    }

    private void on_before_close(long browser) {
        if (this.disposing == Dispose.FromBrowser && "gtk".equals(SWT.getPlatform())) {
            this.chromium.dispose();
        }
        this.browser = 0L;
        this.chromium = null;
        this.debugPrint("closed");
        if (this.textVisitor != null) {
            Display.getCurrent().asyncExec(() -> {
                if (this.textVisitor != null) {
                    this.freeTextVisitor();
                }
            });
        }
    }

    private static synchronized void freeAll(Display display) {
        if (!instances.isEmpty()) {
            System.err.println("freeing all handlers, but there are instances");
        }
        if (clientHandler != null) {
            C.free((long)Chromium.clientHandler.ptr);
            Chromium.disposeCallback(Chromium.clientHandler.get_context_menu_handler_cb);
            Chromium.disposeCallback(Chromium.clientHandler.get_display_handler_cb);
            Chromium.disposeCallback(Chromium.clientHandler.get_focus_handler_cb);
            Chromium.disposeCallback(Chromium.clientHandler.get_jsdialog_handler_cb);
            Callback get_life_span_handler_cb = Chromium.clientHandler.get_life_span_handler_cb;
            Callback get_request_handler_cb = Chromium.clientHandler.get_request_handler_cb;
            Chromium.disposeCallback(get_life_span_handler_cb);
            Chromium.disposeCallback(get_request_handler_cb);
            Chromium.disposeCallback(Chromium.clientHandler.get_load_handler_cb);
            Chromium.disposeCallback(Chromium.clientHandler.on_process_message_received_cb);
            clientHandler = null;
        }
        if (focusHandler != null) {
            C.free((long)Chromium.focusHandler.ptr);
            Chromium.disposeCallback(Chromium.focusHandler.on_got_focus_cb);
            Chromium.disposeCallback(Chromium.focusHandler.on_set_focus_cb);
            Chromium.disposeCallback(Chromium.focusHandler.on_take_focus_cb);
            focusHandler = null;
        }
        if (lifeSpanHandler != null) {
            Chromium.disposeCallback(Chromium.lifeSpanHandler.do_close_cb);
            Chromium.disposeCallback(Chromium.lifeSpanHandler.on_after_created_cb);
            Chromium.disposeCallback(Chromium.lifeSpanHandler.on_before_close_cb);
            Chromium.disposeCallback(Chromium.lifeSpanHandler.on_before_popup_cb);
            C.free((long)Chromium.lifeSpanHandler.ptr);
            lifeSpanHandler = null;
        }
        if (loadHandler != null) {
            Chromium.disposeCallback(Chromium.loadHandler.on_loading_state_change_cb);
            C.free((long)Chromium.loadHandler.ptr);
            loadHandler = null;
        }
        if (displayHandler != null) {
            Chromium.disposeCallback(Chromium.displayHandler.on_address_change_cb);
            Chromium.disposeCallback(Chromium.displayHandler.on_status_message_cb);
            Chromium.disposeCallback(Chromium.displayHandler.on_title_change_cb);
            C.free((long)Chromium.displayHandler.ptr);
            displayHandler = null;
        }
        if (requestHandler != null) {
            Chromium.disposeCallback(Chromium.requestHandler.on_before_browse_cb);
            Chromium.disposeCallback(Chromium.requestHandler.get_auth_credentials_cb);
            C.free((long)Chromium.requestHandler.ptr);
            requestHandler = null;
        }
        if (jsDialogHandler != null) {
            Chromium.disposeCallback(Chromium.jsDialogHandler.on_jsdialog_cb);
            Chromium.disposeCallback(Chromium.jsDialogHandler.on_dialog_closed_cb);
            Chromium.disposeCallback(Chromium.jsDialogHandler.on_before_unload_dialog_cb);
            C.free((long)Chromium.jsDialogHandler.ptr);
            jsDialogHandler = null;
        }
        if (contextMenuHandler != null) {
            Chromium.disposeCallback(Chromium.contextMenuHandler.run_context_menu_cb);
            C.free((long)Chromium.contextMenuHandler.ptr);
            contextMenuHandler = null;
        }
        if (popupClientHandler != null) {
            Chromium.disposeCallback(Chromium.popupClientHandler.get_life_span_handler_cb);
            C.free((long)Chromium.popupClientHandler.ptr);
            popupClientHandler = null;
        }
        Chromium.debug("all dipsosed");
    }

    static int do_close(long plifeSpanHandler, long browser) {
        int id = ChromiumLib.cefswt_get_id(browser);
        Chromium.debug("DoClose: " + id);
        return Chromium.safeGeInstance(id).do_close(browser);
    }

    private int do_close(long browser) {
        if (!ChromiumLib.cefswt_is_same(this.browser, browser)) {
            this.debugPrint("DoClose popup:" + this.browser + ":" + browser);
            return 0;
        }
        Display display = Display.getDefault();
        if (!this.isDisposed() && this.closeWindowListeners != null) {
            WindowEvent event = new WindowEvent((Widget)this.chromium);
            event.display = display;
            event.widget = this.chromium;
            CloseWindowListener[] closeWindowListenerArray = this.closeWindowListeners;
            int n = this.closeWindowListeners.length;
            int n2 = 0;
            while (n2 < n) {
                CloseWindowListener listener = closeWindowListenerArray[n2];
                listener.close(event);
                ++n2;
            }
        }
        if (this.disposing == Dispose.FromClose || this.disposing == Dispose.Unload || this.disposing == Dispose.UnloadClosed || this.disposing == Dispose.WaitIfClosed) {
            this.disposing = Dispose.DoIt;
        } else if (this.disposing == Dispose.No && this.chromium != null) {
            this.disposing = Dispose.FromBrowser;
            if (!"gtk".equals(SWT.getPlatform())) {
                this.chromium.dispose();
            }
        }
        this.debugPrint("AFTER DoClose");
        return this.disposing == Dispose.FromBrowser && "gtk".equals(SWT.getPlatform()) ? 0 : 1;
    }

    static void on_after_created(long self, long browser) {
        int id = ChromiumLib.cefswt_get_id(browser);
        Chromium.debug("on_after_created: " + id);
        if (browser != 0L) {
            browsers.incrementAndGet();
        }
        Chromium.safeGeInstance(id).on_after_created(browser);
    }

    private void on_after_created(long browser) {
        if (this.isDisposed() || this.visibilityWindowListeners == null) {
            return;
        }
        this.debugPrint("on_after_created: " + browser);
        if (browser != 0L) {
            this.browser = browser;
            if (this.isPopup == null) {
                Point size = this.getChromiumSize();
                ChromiumLib.cefswt_resized(browser, size.x, size.y);
            }
            if (this.isPopup != null && this.url != null) {
                this.debugPrint("load url after created");
                Chromium.doSetUrlPost(browser, this.url, this.postData, this.headers);
            } else if (!"about:blank".equals(this.url)) {
                this.enableProgress.complete(true);
            }
        }
        this.created.complete(true);
        if (browsers.get() == 1) {
            this.debugPrint("STARTING MSG LOOP");
            Display display = this.chromium.getDisplay();
            Chromium.doMessageLoop(display);
        }
        this.debugPrint("on_after_created handling " + browser);
        if (this.isDisposed() || this.visibilityWindowListeners == null) {
            return;
        }
        WindowEvent event = new WindowEvent((Widget)this.chromium);
        event.display = this.chromium.getDisplay();
        event.widget = this.chromium;
        event.size = new Point(0, 0);
        event.location = new Point(0, 0);
        if (this.isPopup != null) {
            event.size = this.isPopup.size;
            event.location = this.isPopup.location;
            event.addressBar = this.isPopup.addressBar;
            event.menuBar = this.isPopup.menuBar;
            event.statusBar = this.isPopup.statusBar;
            event.toolBar = this.isPopup.toolBar;
            if (event.size != null && !event.size.equals((Object)new Point(0, 0))) {
                Point size = event.size;
                this.chromium.getShell().setSize(this.chromium.getShell().computeSize(size.x, size.y));
            }
            VisibilityWindowListener[] visibilityWindowListenerArray = this.visibilityWindowListeners;
            int n = this.visibilityWindowListeners.length;
            int n2 = 0;
            while (n2 < n) {
                VisibilityWindowListener listener = visibilityWindowListenerArray[n2];
                listener.show(event);
                ++n2;
            }
        }
        try {
            Thread.sleep(75L);
        }
        catch (InterruptedException interruptedException) {}
    }

    static int on_before_popup(long self, long browser, long frame, long target_url, long target_frame_name, int target_disposition, int user_gesture, long popupFeaturesPtr, long windowInfo, long client, long settings, int no_javascript_access) {
        loopDisable = true;
        pumpDisable = true;
        int id = ChromiumLib.cefswt_get_id(browser);
        Chromium.debug("on_before_popup: " + id);
        int ret = Chromium.safeGeInstance(id).on_before_popup(browser, popupFeaturesPtr, windowInfo, client);
        loopDisable = false;
        return ret;
    }

    private int on_before_popup(long browser, long popupFeaturesPtr, long windowInfo, long client) {
        if (this.isDisposed()) {
            return 1;
        }
        if (this.openWindowListeners == null) {
            return 0;
        }
        WindowEvent event = new WindowEvent((Widget)this.chromium);
        cef_popup_features_t popupFeatures = new cef_popup_features_t();
        ChromiumLib.memmove(popupFeatures, popupFeaturesPtr, ChromiumLib.cef_popup_features_t_sizeof());
        try {
            Thread.sleep(75L);
        }
        catch (InterruptedException interruptedException) {}
        this.chromium.getDisplay().syncExec(() -> {
            this.debugPrint("on_before_popup syncExec" + browser);
            windowEvent.display = this.chromium.getDisplay();
            windowEvent.widget = this.chromium;
            windowEvent.required = false;
            windowEvent.addressBar = cef_popup_features_t2.locationBarVisible == 1;
            windowEvent.menuBar = cef_popup_features_t2.menuBarVisible == 1;
            windowEvent.statusBar = cef_popup_features_t2.statusBarVisible == 1;
            windowEvent.toolBar = cef_popup_features_t2.toolBarVisible == 1;
            int x = cef_popup_features_t2.xSet == 1 ? cef_popup_features_t2.x : 0;
            int y = cef_popup_features_t2.ySet == 1 ? cef_popup_features_t2.y : 0;
            windowEvent.location = cef_popup_features_t2.xSet == 1 || cef_popup_features_t2.ySet == 1 ? new Point(x, y) : null;
            int width = cef_popup_features_t2.widthSet == 1 ? cef_popup_features_t2.width : 0;
            int height = cef_popup_features_t2.heightSet == 1 ? cef_popup_features_t2.height : 0;
            windowEvent.size = cef_popup_features_t2.widthSet == 1 || cef_popup_features_t2.heightSet == 1 ? new Point(width, height) : null;
            OpenWindowListener[] openWindowListenerArray = this.openWindowListeners;
            int n = this.openWindowListeners.length;
            int n2 = 0;
            while (n2 < n) {
                OpenWindowListener listener = openWindowListenerArray[n2];
                listener.open(event);
                ++n2;
            }
            if (windowEvent.browser != null) {
                if (((Chromium)windowEvent.browser.webBrowser).instance == 0) {
                    ((Chromium)windowEvent.browser.webBrowser).createPopup(windowInfo, client, event);
                } else {
                    windowEvent.required = true;
                }
            } else if (!windowEvent.required) {
                this.createDefaultPopup(windowInfo, client, event);
            }
        });
        if (event.browser == null && event.required) {
            return 1;
        }
        if (event.browser != null && event.required) {
            return 1;
        }
        return 0;
    }

    private void waitForClose(Display display) {
        if (display == null || display.isDisposed()) {
            return;
        }
        display.asyncExec(() -> {
            if (this.browser != 0L) {
                this.waitForClose(display);
            }
        });
    }

    private static void set_load_handler() {
        loadHandler = CEFFactory.newLoadHandler();
        Chromium.loadHandler.on_loading_state_change_cb = new Callback(Chromium.class, "on_loading_state_change", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE});
        Chromium.loadHandler.on_loading_state_change = Chromium.checkGetAddress(Chromium.loadHandler.on_loading_state_change_cb);
        Chromium.clientHandler.get_load_handler_cb = new Callback(Chromium.class, "get_load_handler", Long.TYPE, new Type[]{Long.TYPE});
        Chromium.clientHandler.get_load_handler = Chromium.checkGetAddress(Chromium.clientHandler.get_load_handler_cb);
        Chromium.loadHandler.ptr = C.malloc((long)cef_load_handler_t.sizeof);
        ChromiumLib.memmove(Chromium.loadHandler.ptr, loadHandler, cef_load_handler_t.sizeof);
    }

    static long get_load_handler(long client) {
        if (loadHandler == null) {
            return 0L;
        }
        return Chromium.loadHandler.ptr;
    }

    static void on_loading_state_change(long self_, long browser, int isLoading, int canGoBack, int canGoForward) {
        int id = ChromiumLib.cefswt_get_id(browser);
        Chromium.debug("on_loading_state_change: " + id);
        Chromium.safeGeInstance(id).on_loading_state_change(browser, isLoading, canGoBack, canGoForward);
    }

    private void on_loading_state_change(long browser, int isLoading, int canGoBack, int canGoForward) {
        this.canGoBack = canGoBack == 1;
        boolean bl = this.canGoForward = canGoForward == 1;
        if (this.isDisposed() || this.progressListeners == null) {
            return;
        }
        if (isLoading == 0) {
            for (BrowserFunction function : this.functions.values()) {
                if (function.index == 0 || ChromiumLib.cefswt_function(browser, function.name, function.index)) continue;
                throw new SWTException("Cannot create BrowserFunction");
            }
        }
        this.updateText();
        if (this.isPopup != null) {
            this.textReady.thenRun(() -> {
                boolean bl = this.enableProgress.complete(true);
            });
        } else {
            if (!this.enableProgress.isDone() && isLoading == 0) {
                this.textReady.thenRun(() -> this.enableProgress.complete(true));
                return;
            }
            if (!this.enableProgress.isDone()) {
                return;
            }
        }
        ProgressEvent event = new ProgressEvent((Widget)this.chromium);
        event.display = this.chromium.getDisplay();
        event.widget = this.chromium;
        event.current = 100;
        event.current = isLoading == 1 ? 1 : 100;
        event.total = 100;
        if (isLoading == 1) {
            this.debugPrint("progress changed");
            ProgressListener[] progressListenerArray = this.progressListeners;
            int n = this.progressListeners.length;
            int n2 = 0;
            while (n2 < n) {
                ProgressListener listener = progressListenerArray[n2];
                listener.changed(event);
                ++n2;
            }
        } else {
            this.textReady.thenRun(() -> {
                this.debugPrint("progress completed");
                this.chromium.getDisplay().asyncExec(() -> {
                    ProgressListener[] progressListenerArray = this.progressListeners;
                    int n = this.progressListeners.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ProgressListener listener = progressListenerArray[n2];
                        listener.completed(event);
                        ++n2;
                    }
                });
            });
        }
    }

    private static void set_display_handler() {
        displayHandler = CEFFactory.newDisplayHandler();
        Chromium.displayHandler.on_title_change_cb = new Callback(Chromium.class, "on_title_change", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE});
        Chromium.displayHandler.on_title_change = Chromium.checkGetAddress(Chromium.displayHandler.on_title_change_cb);
        Chromium.displayHandler.on_address_change_cb = new Callback(Chromium.class, "on_address_change", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE});
        Chromium.displayHandler.on_address_change = Chromium.checkGetAddress(Chromium.displayHandler.on_address_change_cb);
        Chromium.displayHandler.on_status_message_cb = new Callback(Chromium.class, "on_status_message", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE});
        Chromium.displayHandler.on_status_message = Chromium.checkGetAddress(Chromium.displayHandler.on_status_message_cb);
        Chromium.clientHandler.get_display_handler_cb = new Callback(Chromium.class, "get_display_handler", Long.TYPE, new Type[]{Long.TYPE});
        Chromium.clientHandler.get_display_handler = Chromium.checkGetAddress(Chromium.clientHandler.get_display_handler_cb);
        Chromium.displayHandler.ptr = C.malloc((long)cef_display_handler_t.sizeof);
        ChromiumLib.memmove(Chromium.displayHandler.ptr, displayHandler, cef_display_handler_t.sizeof);
    }

    static long get_display_handler(long client) {
        if (displayHandler == null) {
            return 0L;
        }
        return Chromium.displayHandler.ptr;
    }

    static void on_title_change(long self, long browser, long title) {
        int id = ChromiumLib.cefswt_get_id(browser);
        Chromium.debug("on_title_change: " + id);
        Chromium.safeGeInstance(id).on_title_change(browser, title);
    }

    private void on_title_change(long browser, long title) {
        if (this.isDisposed() || this.titleListeners == null) {
            return;
        }
        String full_str = ChromiumLib.cefswt_cefstring_to_java(title);
        String str = Chromium.getPlainUrl(full_str);
        TitleEvent event = new TitleEvent((Widget)this.chromium);
        event.display = this.chromium.getDisplay();
        event.widget = this.chromium;
        event.title = str;
        TitleListener[] titleListenerArray = this.titleListeners;
        int n = this.titleListeners.length;
        int n2 = 0;
        while (n2 < n) {
            TitleListener listener = titleListenerArray[n2];
            listener.changed(event);
            ++n2;
        }
    }

    static void on_address_change(long self, long browser, long frame, long url) {
        int id = ChromiumLib.cefswt_get_id(browser);
        Chromium.debug("on_address_change: " + id);
        Chromium.safeGeInstance(id).on_address_change(browser, frame, url);
    }

    private void on_address_change(long browser, long frame, long url) {
        if (this.isDisposed() || this.locationListeners == null) {
            return;
        }
        LocationEvent event = new LocationEvent((Widget)this.chromium);
        event.display = this.chromium.getDisplay();
        event.widget = this.chromium;
        event.doit = true;
        event.location = Chromium.getPlainUrl(ChromiumLib.cefswt_cefstring_to_java(url));
        event.top = ChromiumLib.cefswt_is_main_frame(frame);
        if (!this.enableProgress.isDone()) {
            this.debugPrint("!on_address_change to " + event.location + " " + (event.top ? "main" : "!main"));
            return;
        }
        this.debugPrint("on_address_change to " + event.location + " " + (event.top ? "main" : "!main"));
        this.chromium.getDisplay().asyncExec(() -> {
            LocationListener[] locationListenerArray = this.locationListeners;
            int n = this.locationListeners.length;
            int n2 = 0;
            while (n2 < n) {
                LocationListener listener = locationListenerArray[n2];
                listener.changed(event);
                ++n2;
            }
        });
    }

    static void on_status_message(long self, long browser, long status) {
        int id = ChromiumLib.cefswt_get_id(browser);
        Chromium.safeGeInstance(id).on_status_message(browser, status);
    }

    private void on_status_message(long browser, long status) {
        if (this.isDisposed() || this.statusTextListeners == null) {
            return;
        }
        String str = status == 0L ? "" : ChromiumLib.cefswt_cefstring_to_java(status);
        StatusTextEvent event = new StatusTextEvent((Widget)this.chromium);
        event.display = this.chromium.getDisplay();
        event.widget = this.chromium;
        event.text = str;
        StatusTextListener[] statusTextListenerArray = this.statusTextListeners;
        int n = this.statusTextListeners.length;
        int n2 = 0;
        while (n2 < n) {
            StatusTextListener listener = statusTextListenerArray[n2];
            listener.changed(event);
            ++n2;
        }
    }

    private static void set_request_handler() {
        requestHandler = CEFFactory.newRequestHandler();
        Chromium.requestHandler.on_before_browse_cb = new Callback(Chromium.class, "on_before_browse", Integer.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Integer.TYPE});
        Chromium.requestHandler.on_before_browse = Chromium.checkGetAddress(Chromium.requestHandler.on_before_browse_cb);
        Chromium.requestHandler.get_auth_credentials_cb = new Callback(Chromium.class, "get_auth_credentials", Integer.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Long.TYPE, Long.TYPE, Long.TYPE});
        Chromium.requestHandler.get_auth_credentials = Chromium.checkGetAddress(Chromium.requestHandler.get_auth_credentials_cb);
        Chromium.clientHandler.get_request_handler_cb = new Callback(Chromium.class, "get_request_handler", Long.TYPE, new Type[]{Long.TYPE});
        Chromium.clientHandler.get_request_handler = Chromium.checkGetAddress(Chromium.clientHandler.get_request_handler_cb);
        Chromium.requestHandler.ptr = C.malloc((long)cef_request_handler_t.sizeof);
        ChromiumLib.memmove(Chromium.requestHandler.ptr, requestHandler, cef_request_handler_t.sizeof);
    }

    static long get_request_handler(long client) {
        if (requestHandler == null) {
            return 0L;
        }
        return Chromium.requestHandler.ptr;
    }

    static int on_before_browse(long self, long browser, long frame, long request, int is_redirect) {
        int id = ChromiumLib.cefswt_get_id(browser);
        return Chromium.safeGeInstance(id).on_before_browse(browser, frame, request);
    }

    private int on_before_browse(long browser2, long frame, long request) {
        if (this.isDisposed() || this.locationListeners == null) {
            return 0;
        }
        if (ChromiumLib.cefswt_is_main_frame(frame)) {
            LocationEvent event = new LocationEvent((Widget)this.chromium);
            event.display = this.chromium.getDisplay();
            event.widget = this.chromium;
            event.doit = true;
            event.location = Chromium.getPlainUrl(ChromiumLib.cefswt_request_to_java(request));
            this.debugPrint("on_before_browse:" + event.location);
            try {
                loopDisable = true;
                LocationListener[] locationListenerArray = this.locationListeners;
                int n = this.locationListeners.length;
                int n2 = 0;
                while (n2 < n) {
                    LocationListener listener = locationListenerArray[n2];
                    listener.changing(event);
                    ++n2;
                }
            }
            finally {
                loopDisable = false;
            }
            if (!event.doit) {
                this.debugPrint("canceled nav, dependats:" + this.enableProgress.getNumberOfDependents());
                this.enableProgress = new CompletableFuture();
            }
            return event.doit ? 0 : 1;
        }
        return 0;
    }

    static int get_auth_credentials(long self, long browser, long frame, int isProxy, long host, int port, long realm, long scheme, long callback) {
        int id = ChromiumLib.cefswt_get_id(browser);
        return Chromium.safeGeInstance(id).get_auth_credentials(browser, frame, host, port, realm, callback);
    }

    private int get_auth_credentials(long browser2, long frame, long host, int port, long realm, long callback) {
        if (this.isDisposed()) {
            return 0;
        }
        AuthenticationEvent event = new AuthenticationEvent((Widget)this.chromium);
        event.display = this.chromium.getDisplay();
        event.widget = this.chromium;
        event.doit = true;
        String protocol = "http";
        try {
            URL u = new URL(this.url);
            protocol = u.getProtocol();
        }
        catch (MalformedURLException malformedURLException) {}
        String hostStr = host != 0L ? ChromiumLib.cefswt_cefstring_to_java(host) : "";
        String realmStr = realm != 0L ? ChromiumLib.cefswt_cefstring_to_java(realm) : null;
        event.location = String.valueOf(protocol) + "://" + hostStr;
        this.debugPrint("get_auth_credentials:" + event.location);
        this.chromium.getDisplay().syncExec(() -> {
            AuthenticationListener[] authenticationListenerArray = this.authenticationListeners;
            int n = this.authenticationListeners.length;
            int n2 = 0;
            while (n2 < n) {
                AuthenticationListener listener = authenticationListenerArray[n2];
                listener.authenticate(event);
                ++n2;
            }
            if (authenticationEvent.doit && authenticationEvent.user == null && authenticationEvent.password == null) {
                new AuthDialog(this.chromium.getShell()).open(event, realmStr);
            }
        });
        ChromiumLib.cefswt_auth_callback(callback, event.user, event.password, event.doit ? 1 : 0);
        return event.doit ? 1 : 0;
    }

    private static void set_jsdialog_handler() {
        jsDialogHandler = CEFFactory.newJsDialogHandler();
        if (Chromium.useSwtDialogs()) {
            Chromium.jsDialogHandler.on_jsdialog_cb = new Callback(Chromium.class, "on_jsdialog", Integer.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE, Integer.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Integer.TYPE});
            Chromium.jsDialogHandler.on_jsdialog = Chromium.checkGetAddress(Chromium.jsDialogHandler.on_jsdialog_cb);
        }
        Chromium.jsDialogHandler.on_dialog_closed_cb = new Callback(Chromium.class, "on_dialog_closed", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE});
        Chromium.jsDialogHandler.on_dialog_closed = Chromium.checkGetAddress(Chromium.jsDialogHandler.on_dialog_closed_cb);
        Chromium.jsDialogHandler.on_before_unload_dialog_cb = new Callback(Chromium.class, "on_before_unload_dialog", Integer.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE, Integer.TYPE, Long.TYPE});
        Chromium.jsDialogHandler.on_before_unload_dialog = Chromium.checkGetAddress(Chromium.jsDialogHandler.on_before_unload_dialog_cb);
        Chromium.clientHandler.get_jsdialog_handler_cb = new Callback(Chromium.class, "get_jsdialog_handler", Long.TYPE, new Type[]{Long.TYPE});
        Chromium.clientHandler.get_jsdialog_handler = Chromium.checkGetAddress(Chromium.clientHandler.get_jsdialog_handler_cb);
        Chromium.jsDialogHandler.ptr = C.malloc((long)cef_jsdialog_handler_t.sizeof);
        ChromiumLib.memmove(Chromium.jsDialogHandler.ptr, jsDialogHandler, cef_jsdialog_handler_t.sizeof);
    }

    static long get_jsdialog_handler(long client) {
        if (jsDialogHandler == null) {
            return 0L;
        }
        return Chromium.jsDialogHandler.ptr;
    }

    static int on_jsdialog(long self_, long browser, long origin_url, int dialog_type, long message_text, long default_prompt_text, long callback, int suppress_message) {
        int id = ChromiumLib.cefswt_get_id(browser);
        Chromium.debug("on_jsdialog: " + id);
        return Chromium.safeGeInstance(id).on_jsdialog(browser, origin_url, dialog_type, message_text, default_prompt_text, callback);
    }

    private int on_jsdialog(long browser, long origin_url, int dialog_type, long message_text, long default_prompt_text, long callback) {
        if (this.isDisposed()) {
            return 0;
        }
        String url = ChromiumLib.cefswt_cefstring_to_java(origin_url);
        String title = Chromium.getPlainUrl(url);
        String msg = ChromiumLib.cefswt_cefstring_to_java(message_text);
        this.openJsDialog(dialog_type, title, msg, default_prompt_text, callback);
        return 1;
    }

    private void openJsDialog(int dialog_type, String title, String msg, long default_prompt_text, long callback) {
        int style = 16;
        switch (dialog_type) {
            case 0: {
                style = 2;
                break;
            }
            case 1: {
                style = 8;
                break;
            }
            case 2: {
                style = 196;
            }
        }
        Consumer<Integer> close = open -> {
            int r = open == 32 || open == 64 ? 1 : 0;
            Chromium.debug("JS Dialog Closed with " + r);
            ChromiumLib.cefswt_dialog_close(callback, r, default_prompt_text);
            this.chromium.getShell().forceActive();
        };
        if (!"test".equals(System.getProperty("swt.chromium.dialogs", ""))) {
            MessageBox box = new MessageBox(this.chromium.getShell(), style);
            box.setText(title);
            box.setMessage(msg);
            int open2 = box.open();
            close.accept(open2);
        } else {
            CompletableFuture f = (CompletableFuture)this.chromium.getData("swt.chromium.dialogs");
            if (f != null) {
                f.thenAccept(close);
                this.chromium.setData("swt.chromium.dialogs", null);
                while (!f.isDone()) {
                    if (this.chromium.getDisplay().readAndDispatch()) continue;
                    this.chromium.getDisplay().sleep();
                }
            }
        }
    }

    static void on_dialog_closed(long self_, long browser) {
        int id = ChromiumLib.cefswt_get_id(browser);
        Chromium.safeGeInstance(id).on_dialog_closed(browser);
    }

    private void on_dialog_closed(long browser) {
        Chromium.debug("on_dialog_closed_cb disposing: " + (Object)((Object)this.disposing));
        if (this.disposing == Dispose.Unload) {
            this.disposing = Dispose.UnloadClosed;
        }
    }

    static int on_before_unload_dialog(long self_, long browser, long msg, int is_reload, long callback) {
        int id = ChromiumLib.cefswt_get_id(browser);
        return Chromium.safeGeInstance(id).on_before_unload_dialog(browser, msg, is_reload, callback);
    }

    private int on_before_unload_dialog(long browser, long message_text, int is_reload, long callback) {
        Chromium.debug("on_before_unload_dialog disposing: " + (Object)((Object)this.disposing));
        if (this.disposing == Dispose.FromClose) {
            this.disposing = Dispose.Unload;
            if (Chromium.useSwtDialogs()) {
                String msg = ChromiumLib.cefswt_cefstring_to_java(message_text);
                this.openJsDialog(2, "Are you sure you want to leave this page?", msg, 0L, callback);
                this.disposing = Dispose.UnloadClosed;
                return 1;
            }
        }
        return 0;
    }

    private static boolean useSwtDialogs() {
        return "gtk".equals(SWT.getPlatform()) || !"native".equals(System.getProperty("swt.chromium.dialogs", "swt"));
    }

    private static void set_context_menu_handler() {
        contextMenuHandler = CEFFactory.newContextMenuHandler();
        Chromium.contextMenuHandler.run_context_menu_cb = new Callback(Chromium.class, "run_context_menu", Integer.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE});
        Chromium.contextMenuHandler.run_context_menu = Chromium.checkGetAddress(Chromium.contextMenuHandler.run_context_menu_cb);
        Chromium.clientHandler.get_context_menu_handler_cb = new Callback(Chromium.class, "get_context_menu_handler", Long.TYPE, new Type[]{Long.TYPE});
        Chromium.clientHandler.get_context_menu_handler = Chromium.checkGetAddress(Chromium.clientHandler.get_context_menu_handler_cb);
        Chromium.contextMenuHandler.ptr = C.malloc((long)cef_context_menu_handler_t.sizeof);
        ChromiumLib.memmove(Chromium.contextMenuHandler.ptr, contextMenuHandler, cef_context_menu_handler_t.sizeof);
    }

    static long get_context_menu_handler(long client) {
        if (contextMenuHandler == null) {
            return 0L;
        }
        return Chromium.contextMenuHandler.ptr;
    }

    static int run_context_menu(long self, long browser, long frame, long params, long model, long callback) {
        int id = ChromiumLib.cefswt_get_id(browser);
        Chromium.debug("run_context_menu: " + id);
        return Chromium.safeGeInstance(id).run_context_menu(browser, callback);
    }

    private int run_context_menu(long browser2, long callback) {
        if (this.chromium.getMenu() != null) {
            this.chromium.getMenu().setVisible(true);
            ChromiumLib.cefswt_context_menu_cancel(callback);
            return 1;
        }
        return 0;
    }

    private void updateText() {
        if (this.browser != 0L && !this.isDisposed() && this.disposing == Dispose.No) {
            this.debugPrint("update text");
            if (this.textVisitor != null) {
                ++this.textVisitor.refs;
            } else {
                this.set_text_visitor();
            }
            this.textReady = new CompletableFuture();
            ChromiumLib.cefswt_get_text(this.browser, this.textVisitor.ptr);
        }
    }

    private void set_text_visitor() {
        this.textVisitor = CEFFactory.newStringVisitor();
        this.textVisitor.visit_cb = new Callback((Object)this, "textVisitor_visit", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE});
        this.textVisitor.visit = Chromium.checkGetAddress(this.textVisitor.visit_cb);
        this.textVisitor.ptr = C.malloc((long)cef_string_visitor_t.sizeof);
        this.textVisitor.refs = 1;
        ChromiumLib.memmove(this.textVisitor.ptr, this.textVisitor, cef_string_visitor_t.sizeof);
    }

    void textVisitor_visit(long self, long cefString) {
        String newtext;
        if (--this.textVisitor.refs == 0) {
            this.freeTextVisitor();
        }
        String string = newtext = cefString != 0L ? ChromiumLib.cefswt_cefstring_to_java(cefString) : null;
        if (newtext != null) {
            this.text = newtext;
            this.debugPrint("text visited completed");
            this.textReady.complete(this.text);
        } else {
            this.debugPrint("text visited null");
        }
    }

    private void freeTextVisitor() {
        this.debugPrint("free text visitor");
        Chromium.disposeCallback(this.textVisitor.visit_cb);
        Chromium.freeDelayed(this.textVisitor.ptr);
        this.textVisitor = null;
    }

    private static void set_focus_handler() {
        focusHandler = CEFFactory.newFocusHandler();
        Chromium.focusHandler.on_got_focus_cb = new Callback(Chromium.class, "on_got_focus", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE});
        Chromium.focusHandler.on_got_focus = Chromium.checkGetAddress(Chromium.focusHandler.on_got_focus_cb);
        Chromium.focusHandler.on_set_focus_cb = new Callback(Chromium.class, "on_set_focus", Integer.TYPE, new Type[]{Long.TYPE, Long.TYPE, Integer.TYPE});
        Chromium.focusHandler.on_set_focus = Chromium.checkGetAddress(Chromium.focusHandler.on_set_focus_cb);
        Chromium.focusHandler.on_take_focus_cb = new Callback(Chromium.class, "on_take_focus", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE, Integer.TYPE});
        Chromium.focusHandler.on_take_focus = Chromium.checkGetAddress(Chromium.focusHandler.on_take_focus_cb);
        Chromium.clientHandler.get_focus_handler_cb = new Callback(Chromium.class, "get_focus_handler", Long.TYPE, new Type[]{Long.TYPE});
        Chromium.clientHandler.get_focus_handler = Chromium.checkGetAddress(Chromium.clientHandler.get_focus_handler_cb);
        Chromium.focusHandler.ptr = C.malloc((long)cef_focus_handler_t.sizeof);
        ChromiumLib.memmove(Chromium.focusHandler.ptr, focusHandler, cef_focus_handler_t.sizeof);
    }

    static long get_focus_handler(long client) {
        if (focusHandler == null) {
            return 0L;
        }
        return Chromium.focusHandler.ptr;
    }

    static void on_got_focus(long focusHandler, long browser) {
        int id = ChromiumLib.cefswt_get_id(browser);
        Chromium.debug("on_got_focus: " + id);
        Chromium.safeGeInstance(id).on_got_focus(browser);
    }

    private void on_got_focus(long browser2) {
        if (!this.isDisposed()) {
            this.hasFocus = true;
            if (!this.isDisposed() && this.chromium.getDisplay().getFocusControl() != null) {
                this.chromium.setFocus();
            }
            this.browserFocus(true);
        }
    }

    static int on_set_focus(long focusHandler, long browser, int focusSource) {
        int id = ChromiumLib.cefswt_get_id(browser);
        Chromium.debug("on_set_focus: " + id);
        return Chromium.safeGeInstance(id).on_set_focus(browser);
    }

    private int on_set_focus(long browser) {
        if (this.ignoreFirstFocus) {
            this.ignoreFirstFocus = false;
            return 1;
        }
        return 0;
    }

    static void on_take_focus(long focusHandler, long browser, int next) {
        int id = ChromiumLib.cefswt_get_id(browser);
        Chromium.debug("on_take_focus: " + id);
        Chromium.safeGeInstance(id).on_take_focus(browser, next);
    }

    private void on_take_focus(long browser, int next) {
        int indexOf;
        this.hasFocus = false;
        Control[] tabOrder = this.chromium.getParent().getTabList();
        if (tabOrder.length == 0) {
            tabOrder = this.chromium.getParent().getChildren();
        }
        if ((indexOf = Arrays.asList(tabOrder).indexOf(this.chromium)) != -1) {
            int newIndex;
            int n = newIndex = next == 1 ? indexOf + 1 : indexOf - 1;
            if (newIndex > 0 && newIndex < tabOrder.length && !tabOrder[newIndex].isDisposed()) {
                tabOrder[newIndex].setFocus();
                return;
            }
        }
        if (!this.isDisposed() && !this.chromium.getParent().isDisposed()) {
            this.chromium.getParent().setFocus();
        }
    }

    public boolean isFocusControl() {
        return this.hasFocus;
    }

    private static void doMessageLoop(Display display) {
        loopWork = () -> {
            if (lib != null && !display.isDisposed()) {
                Chromium.safe_loop_work("timer");
                display.timerExec(150, loopWork);
            } else {
                Chromium.debug("STOPPING MSG LOOP");
            }
        };
        display.timerExec(75, loopWork);
    }

    private synchronized void checkBrowser() {
        if (lib == null) {
            SWT.error((int)47);
        }
        if (this.browser == 0L) {
            SWT.error((int)24);
        }
    }

    static int on_process_message_received(long client, long browser, int source, long processMessage) {
        int id = ChromiumLib.cefswt_get_id(browser);
        Chromium.debug("on_process_message_received: " + id);
        return Chromium.safeGeInstance(id).on_process_message_received(browser, source, processMessage);
    }

    private int on_process_message_received(long browser, int source, long processMessage) {
        if (source != 1 || !this.jsEnabled || this.chromium == null) {
            return 0;
        }
        FunctionSt fn = new FunctionSt();
        ChromiumLib.cefswt_function_id(processMessage, fn);
        int id = fn.id;
        if (id < 0) {
            return 0;
        }
        int argsSize = fn.args;
        Object[] args = new Object[argsSize];
        int i = 0;
        while (i < argsSize) {
            int arg = i;
            EvalReturned callback = (loop, type, valuePtr) -> {
                if (loop == 0) {
                    String value = ChromiumLib.cefswt_cstring_to_java(valuePtr);
                    objectArray[n] = this.mapType(type, value);
                }
            };
            Callback callback_cb = new Callback((Object)callback, "invoke", Void.TYPE, new Type[]{Integer.TYPE, Integer.TYPE, Long.TYPE});
            ChromiumLib.cefswt_function_arg(processMessage, i, Chromium.checkGetAddress(callback_cb));
            Chromium.disposeCallback(callback_cb);
            ++i;
        }
        Object ret = ((BrowserFunction)this.functions.get(id)).function(args);
        Object[] returnPair = this.convertType(ret);
        CEFFactory.ReturnType returnType = (CEFFactory.ReturnType)((Object)returnPair[0]);
        String returnStr = (String)returnPair[1];
        ChromiumLib.cefswt_function_return(browser, id, fn.port, returnType.intValue(), returnStr);
        return 1;
    }

    private Object[] convertType(Object ret) {
        CEFFactory.ReturnType returnType = CEFFactory.ReturnType.Error;
        String returnStr = "";
        if (ret == null) {
            returnType = CEFFactory.ReturnType.Null;
            returnStr = "null";
        } else if (Boolean.class.isInstance(ret)) {
            returnType = CEFFactory.ReturnType.Bool;
            returnStr = Boolean.TRUE.equals(ret) ? "1" : "0";
        } else if (Number.class.isInstance(ret)) {
            returnType = CEFFactory.ReturnType.Double;
            returnStr = NumberFormat.getInstance(Locale.US).format(ret);
        } else if (String.class.isInstance(ret)) {
            returnType = CEFFactory.ReturnType.Str;
            returnStr = ret.toString();
        } else if (ret.getClass().isArray()) {
            returnType = CEFFactory.ReturnType.Array;
            StringBuilder buffer = new StringBuilder();
            buffer.append("\"");
            int i = 0;
            while (i < Array.getLength(ret)) {
                if (i > 0) {
                    buffer.append(";");
                }
                Object[] arrayElem = this.convertType(Array.get(ret, i));
                buffer.append("'");
                buffer.append(((CEFFactory.ReturnType)((Object)arrayElem[0])).intValue());
                buffer.append(",");
                buffer.append((String)arrayElem[1]);
                buffer.append("'");
                ++i;
            }
            buffer.append("\"");
            returnStr = buffer.toString();
        } else {
            returnStr = "Unsupported return type " + ret.getClass().getName();
        }
        return new Object[]{returnType, returnStr};
    }

    protected void browserFocus(boolean set) {
        if (!this.isDisposed() && this.browser != 0L) {
            long parent;
            long l = parent = Display.getDefault().getActiveShell() == null ? 0L : this.getHandle(this.chromium.getParent());
            if (this.chromium.getDisplay().getActiveShell() != this.chromium.getShell()) {
                return;
            }
            ChromiumLib.cefswt_set_focus(this.browser, set, parent);
        }
    }

    public boolean close() {
        if (this.disposing != Dispose.No || this.isDisposed()) {
            return false;
        }
        if (this.browser == 0L) {
            return true;
        }
        boolean closed = false;
        this.debugPrint("call try_close_browser");
        this.disposing = Dispose.FromClose;
        ChromiumLib.cefswt_close_browser(this.browser, 0);
        long t = System.currentTimeMillis();
        long end = t + 10000L;
        Shell shell = this.chromium.getShell();
        Display display = shell.getDisplay();
        while (!shell.isDisposed() && System.currentTimeMillis() < end) {
            if (this.disposing == Dispose.Unload) {
                end += 1000L;
            } else if (this.disposing == Dispose.UnloadClosed) {
                Chromium.debug("in close, disposing:" + (Object)((Object)this.disposing));
                this.disposing = Dispose.WaitIfClosed;
                end = System.currentTimeMillis() + 150L;
            } else if (this.disposing == Dispose.DoIt) {
                Chromium.debug("in close, disposing:" + (Object)((Object)this.disposing));
                closed = true;
                break;
            }
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (!closed) {
            this.disposing = Dispose.No;
        }
        return closed;
    }

    public void dispose() {
        this.debugPrint("in dispose, disposing " + (Object)((Object)this.disposing));
        if (this.disposing == Dispose.FromDispose || this.isDisposed()) {
            return;
        }
        boolean callClose = this.disposing == Dispose.No;
        this.disposing = Dispose.FromDispose;
        ++disposingAny;
        if (this.focusListener != null) {
            this.chromium.removeFocusListener(this.focusListener);
        }
        this.focusListener = null;
        if (this.browser != 0L && callClose) {
            this.debugPrint("call close_browser");
            ChromiumLib.cefswt_close_browser(this.browser, 1);
            this.waitForClose(Display.getDefault());
        }
    }

    public static void shutdown() {
        String platform = SWT.getPlatform();
        if ("cocoa".equals(platform)) {
            return;
        }
        Chromium.debug("Shutdown from API");
        Chromium.internalShutdown();
    }

    private static void internalShutdown() {
        if (lib == null || app == null) {
            return;
        }
        if (browsers.get() == 0) {
            Chromium.debug("shutting down CEF on exit from thread " + Thread.currentThread().getName());
            Chromium.freeAll(null);
            ChromiumLib.cefswt_shutdown();
            if (cookieVisitor != null) {
                Chromium.disposeCallback(Chromium.cookieVisitor.visit_cb);
                C.free((long)Chromium.cookieVisitor.ptr);
                cookieVisitor = null;
            }
            Chromium.disposeCallback(Chromium.app.get_browser_process_handler_cb);
            C.free((long)Chromium.app.ptr);
            app = null;
            Chromium.disposeCallback(Chromium.browserProcessHandler.on_schedule_message_pump_work_cb);
            C.free((long)Chromium.browserProcessHandler.ptr);
            browserProcessHandler = null;
            Chromium.debug("after shutting down CEF");
        } else if (!shuttindDown) {
            shuttindDown = true;
            Chromium.debug("delaying shutdown due browsers not disposed yet");
        }
    }

    private static Object loadLib() {
        String subDir = "chromium-3071";
        File cefrustlib = null;
        try {
            String mapLibraryName = System.mapLibraryName(SHARED_LIB_V);
            String mapJniName = JNI_LIB_V;
            Enumeration<URL> fragments = Library.class.getClassLoader().getResources(String.valueOf(subDir) + "/chromium.properties");
            while (fragments.hasMoreElements()) {
                URL url = fragments.nextElement();
                Throwable throwable = null;
                Object var7_13 = null;
                try (InputStream is = url.openStream();){
                    Properties props = new Properties();
                    props.load(is);
                    for (String prop : props.stringPropertyNames()) {
                        String propValue;
                        Path path;
                        String fileName;
                        if ("cefVersion".equals(prop) || mapLibraryName.equals(fileName = (path = Paths.get(propValue = props.getProperty(prop), new String[0])).getFileName().toString()) || fileName.contains(mapJniName)) continue;
                        File resolved = Library.findResource((String)path.getParent().toString(), (String)fileName, (boolean)false, (boolean)false, (boolean)false);
                        if (cefPath != null || !path.endsWith(CEFFactory.getCefLibName())) continue;
                        Path resolvedPath = resolved.toPath();
                        cefPath = resolvedPath.getRoot().resolve(resolvedPath.subpath(0, resolvedPath.getNameCount() - Paths.get(CEFFactory.getCefLibName(), new String[0]).getNameCount())).toString();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            cefrustlib = Library.findResource((String)subDir, (String)mapLibraryName, (boolean)false, (boolean)false, (boolean)false);
            File jnilib = Library.findResource((String)subDir, (String)mapJniName, (boolean)true, (boolean)true, (boolean)false);
            cefrustPath = cefrustlib.getParentFile().getCanonicalPath();
            CEFFactory.create(cefPath != null ? cefPath : cefrustPath);
            if (cefPath == null) {
                cefPath = cefrustPath;
            }
            System.load(cefrustlib.getAbsolutePath());
            System.load(jnilib.getAbsolutePath());
            Chromium.setupCookies();
            return new Object();
        }
        catch (UnsatisfiedLinkError e) {
            String cefLib = CEFFactory.getCefLibName();
            if (cefrustlib != null && !new File(cefrustlib.getParentFile(), cefLib).exists()) {
                SWTError swtError = new SWTError(47, "Missing CEF binaries for Chromium Browser. Extract CEF binaries to " + cefrustPath);
                swtError.throwable = e;
                throw swtError;
            }
            throw e;
        }
        catch (IOException e) {
            SWTError swtError = new SWTError(47, e.getMessage());
            swtError.throwable = e;
            throw swtError;
        }
    }

    private static void setupCookies() {
        WebBrowser.NativeClearSessions = () -> ChromiumLib.cefswt_delete_cookies();
        WebBrowser.NativeSetCookie = () -> {
            List<HttpCookie> cookies = HttpCookie.parse(WebBrowser.CookieValue);
            Iterator<HttpCookie> iterator = cookies.iterator();
            if (iterator.hasNext()) {
                HttpCookie cookie = iterator.next();
                long age = cookie.getMaxAge();
                if (age != -1L) {
                    age = Instant.now().plusSeconds(age).getEpochSecond();
                }
                WebBrowser.CookieResult = ChromiumLib.cefswt_set_cookie(WebBrowser.CookieUrl, cookie.getName(), cookie.getValue(), cookie.getDomain(), cookie.getPath(), cookie.getSecure() ? 1 : 0, cookie.isHttpOnly() ? 1 : 0, age);
            }
        };
        WebBrowser.NativeGetCookie = () -> {
            if (cookieVisitor == null) {
                Chromium.setCookieVisitor();
            }
            cookieVisited = new CompletableFuture();
            boolean result = ChromiumLib.cefswt_get_cookie(WebBrowser.CookieUrl, Chromium.cookieVisitor.ptr);
            if (!result) {
                cookieVisited = null;
                throw new SWTException("Failed to get cookies");
            }
            try {
                try {
                    cookieVisited.get(100L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException | ExecutionException | TimeoutException exception) {
                    cookieVisited = null;
                }
            }
            finally {
                cookieVisited = null;
            }
        };
    }

    private static void setCookieVisitor() {
        cookieVisitor = CEFFactory.newCookieVisitor();
        Chromium.cookieVisitor.visit_cb = new Callback(Chromium.class, "cookieVisitor_visit", Integer.TYPE, new Type[]{Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE});
        Chromium.cookieVisitor.visit = Chromium.checkGetAddress(Chromium.cookieVisitor.visit_cb);
        Chromium.cookieVisitor.ptr = C.malloc((long)cef_cookie_visitor_t.sizeof);
        ChromiumLib.memmove(Chromium.cookieVisitor.ptr, cookieVisitor, cef_cookie_visitor_t.sizeof);
    }

    static int cookieVisitor_visit(long self, long cefcookie, int count, int total, int delete) {
        String name = ChromiumLib.cefswt_cookie_to_java(cefcookie);
        Chromium.debug("Visitor " + count + "/" + total + ": " + name + ":" + Thread.currentThread());
        if (WebBrowser.CookieName != null && WebBrowser.CookieName.equals(name)) {
            String value = ChromiumLib.cefswt_cookie_value(cefcookie);
            Chromium.debug("cookie value: " + value);
            WebBrowser.CookieValue = value;
            cookieVisited.complete(true);
            return 0;
        }
        return 1;
    }

    public boolean back() {
        if (lib == null) {
            SWT.error((int)47);
        }
        if (this.canGoBack) {
            ChromiumLib.cefswt_go_back(this.browser);
            return true;
        }
        return false;
    }

    public boolean execute(String script) {
        if (!this.jsEnabled) {
            return false;
        }
        this.enableProgress.thenRun(() -> ChromiumLib.cefswt_execute(this.browser, script));
        return true;
    }

    public Object evaluate(String script) throws SWTException {
        if (lib == null) {
            SWT.error((int)47);
        }
        if (!this.jsEnabled) {
            return null;
        }
        if (this.browser == 0L && this.paintListener != null) {
            this.chromium.removePaintListener(this.paintListener);
            this.paintListener = null;
            this.createBrowser();
        }
        this.checkBrowser();
        Object[] ret = new Object[1];
        EvalReturned callback = (loop, type, valuePtr) -> {
            if (loop == 1) {
                if (!loopDisable || !"cocoa".equals(SWT.getPlatform()) && !"gtk".equals(SWT.getPlatform())) {
                    this.chromium.getDisplay().readAndDispatch();
                }
            } else {
                String value = ChromiumLib.cefswt_cstring_to_java(valuePtr);
                this.debugPrint("eval returned: " + type + ":" + value);
                objectArray[0] = this.mapType(type, value);
            }
        };
        Callback callback_cb = new Callback((Object)callback, "invoke", Void.TYPE, new Type[]{Integer.TYPE, Integer.TYPE, Long.TYPE});
        StringBuilder buffer = new StringBuilder("(function() {");
        buffer.append("\n");
        buffer.append(script);
        buffer.append("\n})()");
        boolean returnSt = ChromiumLib.cefswt_eval(this.browser, buffer.toString(), EVAL++, Chromium.checkGetAddress(callback_cb));
        Chromium.disposeCallback(callback_cb);
        if (!returnSt) {
            throw new SWTException("Script that was evaluated failed");
        }
        return ret[0];
    }

    private Object mapType(int type, String value) throws SWTException {
        if (type == CEFFactory.ReturnType.Error.intValue()) {
            if ("51".equals(value)) {
                throw new SWTException(51);
            }
            throw new SWTException(50, value);
        }
        if (type == CEFFactory.ReturnType.Null.intValue()) {
            return null;
        }
        if (type == CEFFactory.ReturnType.Bool.intValue()) {
            return "1".equals(value) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (type == CEFFactory.ReturnType.Double.intValue()) {
            return Double.parseDouble(value);
        }
        if (type == CEFFactory.ReturnType.Array.intValue()) {
            String value_unquoted = value.substring(1, value.length() - 1);
            String[] elements = value_unquoted.split(";(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)");
            Object[] array = new Object[elements.length];
            int i = 0;
            while (i < array.length) {
                Object elemValue;
                String elemUnquoted = elements[i].substring(1, elements[i].length() - 1);
                String[] parts = elemUnquoted.split(",(?=(?:[^']*'[^']*')*[^']*$)", 2);
                CEFFactory.ReturnType elemType = CEFFactory.ReturnType.from(parts[0]);
                array[i] = elemValue = this.mapType(elemType.intValue(), parts[1]);
                ++i;
            }
            return array;
        }
        return value;
    }

    public boolean forward() {
        if (lib == null) {
            SWT.error((int)47);
        }
        if (this.canGoForward) {
            ChromiumLib.cefswt_go_forward(this.browser);
            return true;
        }
        return false;
    }

    public String getBrowserType() {
        return "chromium";
    }

    public String getText() {
        this.checkBrowser();
        return this.text;
    }

    public String getUrl() {
        if (lib == null) {
            SWT.error((int)47);
        }
        if (this.browser == 0L) {
            if (this.url == null) {
                return "about:blank";
            }
            return Chromium.getPlainUrl(this.url);
        }
        long urlPtr = ChromiumLib.cefswt_get_url(this.browser);
        String cefurl = null;
        if (urlPtr != 0L) {
            cefurl = ChromiumLib.cefswt_cstring_to_java(urlPtr);
        }
        cefurl = cefurl == null ? Chromium.getPlainUrl(this.url) : Chromium.getPlainUrl(cefurl);
        return cefurl;
    }

    public boolean isBackEnabled() {
        return this.canGoBack;
    }

    public boolean isForwardEnabled() {
        return this.canGoForward;
    }

    public void refresh() {
        if (lib == null) {
            SWT.error((int)47);
        }
        this.jsEnabled = this.jsEnabledOnNextPage;
        if (this.browser != 0L) {
            ChromiumLib.cefswt_reload(this.browser);
        }
    }

    public boolean setText(String html, boolean trusted) {
        if (html.contains("file:/")) {
            try {
                Path tmp = Files.createTempFile(SET_TEXT_URL, ".html", new FileAttribute[0]);
                Files.write(tmp, html.getBytes(), new OpenOption[0]);
                tmp.toFile().deleteOnExit();
                boolean s = this.setUrl(tmp.toUri().toString(), null, null);
                return s;
            }
            catch (IOException iOException) {}
        }
        String texturl = DATA_TEXT_URL + Base64.getEncoder().encodeToString(html.getBytes());
        return this.setUrl(texturl, null, null);
    }

    private static String getPlainUrl(String url) {
        if (url != null && url.startsWith(DATA_TEXT_URL)) {
            return url.substring(0, DATA_TEXT_URL.length() - 8);
        }
        if (url != null && url.startsWith("file:/") && url.contains(SET_TEXT_URL)) {
            return "about:blank";
        }
        return url;
    }

    public boolean setUrl(String url, String postData, String[] headers) {
        this.url = url;
        this.postData = postData;
        this.headers = headers;
        this.jsEnabled = this.jsEnabledOnNextPage;
        if (!this.isDisposed() && this.browser != 0L) {
            this.debugPrint("set url: " + url);
            this.doSetUrl(url, postData, headers);
        }
        return true;
    }

    private CompletableFuture<Void> doSetUrl(String url, String postData, String[] headers) {
        return this.enableProgress.thenRun(() -> {
            this.debugPrint("load url");
            Chromium.doSetUrlPost(this.browser, url, postData, headers);
        });
    }

    private static void doSetUrlPost(long browser, String url, String postData, String[] headers) {
        byte[] bytes = postData != null ? postData.getBytes(Charset.forName("ASCII")) : null;
        int bytesLength = postData != null ? bytes.length : 0;
        int headersLength = headers != null ? headers.length : 0;
        String joinHeaders = headers == null ? null : String.join((CharSequence)"::", headers);
        ChromiumLib.cefswt_load_url(browser, url, bytes, bytesLength, joinHeaders, headersLength);
    }

    public void stop() {
        if (lib == null) {
            SWT.error((int)47);
        }
        if (this.browser != 0L) {
            ChromiumLib.cefswt_stop(this.browser);
        }
    }

    boolean isDisposed() {
        return this.chromium == null || this.chromium.isDisposed();
    }

    private static Chromium safeGeInstance(int id) {
        Chromium c = instances.get(id);
        if (c == null) {
            throw new SWTError("Wrong chromium id " + id);
        }
        return c;
    }

    private static void freeDelayed(long ptr) {
        Display.getDefault().asyncExec(() -> C.free((long)ptr));
    }

    static long checkGetAddress(Callback cb) {
        long address = cb.getAddress();
        if (address == 0L) {
            throw new SWTError(3);
        }
        return address;
    }

    static void disposeCallback(Callback cb) {
        if (cb != null) {
            cb.dispose();
        }
    }

    class AuthDialog
    extends Dialog {
        public AuthDialog(Shell parent) {
            super(parent);
        }

        public void open(AuthenticationEvent authEvent, String realm) {
            Shell parent = this.getParent();
            Shell shell = new Shell(parent, 67696);
            shell.setText("Authentication Required");
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 10;
            layout.marginWidth = 10;
            shell.setLayout((Layout)layout);
            Label info = new Label((Composite)shell, 64);
            StringBuilder infoText = new StringBuilder(authEvent.location);
            infoText.append(" is requesting you username and password.");
            if (realm != null) {
                infoText.append(" The site says: \"").append(realm).append("\"");
            }
            info.setText(infoText.toString());
            info.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            Label label1 = new Label((Composite)shell, 0);
            label1.setText("User Name: ");
            Text username = new Text((Composite)shell, 2052);
            username.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            Label label2 = new Label((Composite)shell, 0);
            label2.setText("Password: ");
            Text password = new Text((Composite)shell, 2052);
            password.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            password.setEchoChar('*');
            Composite bar = new Composite((Composite)shell, 0);
            bar.setLayoutData((Object)new GridData(0x1000008, 0x1000008, false, true, 2, 1));
            bar.setLayout((Layout)new GridLayout(2, true));
            Button cancelButton = new Button(bar, 8);
            cancelButton.setText("Cancel");
            cancelButton.addListener(13, event -> {
                authenticationEvent.doit = false;
                shell.close();
            });
            GridData cancelData = new GridData(0x1000000, 0x1000008, false, false);
            cancelData.widthHint = 80;
            cancelButton.setLayoutData((Object)cancelData);
            Button okButton = new Button(bar, 8);
            okButton.setText("Ok");
            okButton.addListener(13, event -> {
                authenticationEvent.user = username.getText();
                authenticationEvent.password = password.getText();
                shell.close();
            });
            GridData okData = new GridData(0x1000000, 0x1000008, false, false);
            okData.minimumWidth = -1;
            okData.widthHint = 80;
            okButton.setLayoutData((Object)okData);
            shell.pack();
            shell.open();
            Display display = parent.getDisplay();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
    }

    private final class CefFocusListener
    implements FocusListener {
        private boolean enabled = true;

        private CefFocusListener() {
        }

        public void focusLost(FocusEvent e) {
            if (!this.enabled) {
                return;
            }
            this.enabled = false;
            Chromium.this.browserFocus(false);
            this.enabled = true;
        }

        public void focusGained(FocusEvent e) {
            if (!this.enabled) {
                return;
            }
            Chromium.this.browserFocus(true);
        }
    }

    static enum Dispose {
        No,
        FromDispose,
        FromClose,
        FromBrowser,
        Unload,
        UnloadClosed,
        WaitIfClosed,
        DoIt;

    }

    public static interface EvalReturned {
        public void invoke(int var1, int var2, long var3);
    }
}

