/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.gitbash.repository;

import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.oomph.gitbash.AbstractAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListFilesAction
extends AbstractAction<Repository> {
    private static final IWorkbench WORKBENCH = PlatformUI.getWorkbench();

    public ListFilesAction() {
        super(Repository.class);
    }

    @Override
    protected void run(final Shell shell, final Repository repository) throws Exception {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                long start = System.currentTimeMillis();
                try {
                    try {
                        final File file = ListFilesAction.this.checkHistory(repository, monitor);
                        shell.getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                try {
                                    IFileStore fileStore = EFS.getLocalFileSystem().getStore(file.toURI());
                                    IDE.openEditorOnFileStore((IWorkbenchPage)WORKBENCH.getActiveWorkbenchWindow().getActivePage(), (IFileStore)fileStore);
                                }
                                catch (PartInitException ex) {
                                    ex.printStackTrace();
                                }
                            }
                        });
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        System.out.println();
                        System.out.println("Took " + (System.currentTimeMillis() - start) + " millis");
                    }
                    catch (Exception ex) {
                        throw new InvocationTargetException(ex);
                    }
                }
                finally {
                    System.out.println();
                    System.out.println("Took " + (System.currentTimeMillis() - start) + " millis");
                }
            }
        };
        WORKBENCH.getProgressService().run(true, true, runnable);
    }

    private File checkHistory(Repository repository, IProgressMonitor monitor) throws Exception {
        Git git = new Git(repository);
        int commitCount = this.getCommitCount(git);
        monitor.beginTask("Listing all files", commitCount);
        HashMap<String, HashSet<String>> namesByExtension = new HashMap<String, HashSet<String>>();
        for (RevCommit commit : git.log().call()) {
            TreeWalk walk = new TreeWalk(repository);
            walk.setRecursive(true);
            walk.addTree((AnyObjectId)commit.getTree());
            while (walk.next()) {
                String extension;
                this.checkCancelation(monitor);
                String name = walk.getNameString();
                int lastDot = name.lastIndexOf(46);
                if (lastDot == -1) {
                    extension = "";
                } else {
                    extension = name.substring(lastDot + 1);
                    name = name.substring(0, lastDot);
                }
                HashSet<String> names = (HashSet<String>)namesByExtension.get(extension);
                if (names == null) {
                    names = new HashSet<String>();
                    namesByExtension.put(extension, names);
                }
                names.add(name);
            }
            try {
                walk.close();
            }
            catch (Throwable throwable) {
                try {
                    Method method = walk.getClass().getMethod("release", new Class[0]);
                    method.invoke((Object)walk, new Object[0]);
                }
                catch (Throwable throwable2) {}
            }
            monitor.worked(1);
        }
        File file = new File("files-in-" + repository.getWorkTree().getName() + ".txt");
        PrintStream stream = new PrintStream(file);
        try {
            for (String extension : this.sort(namesByExtension.keySet())) {
                List<String> names = this.sort((Collection)namesByExtension.get(extension));
                System.out.println(String.valueOf(extension) + "\t" + names.size());
                stream.println(String.valueOf(extension) + "\t" + names.size());
                for (String name : names) {
                    stream.println("\t" + name);
                }
            }
        }
        finally {
            stream.close();
        }
        return file;
    }

    private List<String> sort(Collection<String> c) {
        ArrayList<String> list = new ArrayList<String>(c);
        Collections.sort(list);
        return list;
    }

    private int getCommitCount(Git git) throws GitAPIException, NoHeadException {
        int commitCount = 0;
        Iterator iterator = git.log().call().iterator();
        while (iterator.hasNext()) {
            RevCommit cfr_ignored_0 = (RevCommit)iterator.next();
            ++commitCount;
        }
        return commitCount;
    }

    private void checkCancelation(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }
}

