/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.recorder;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.oomph.base.provider.BaseEditUtil;
import org.eclipse.oomph.setup.Installation;
import org.eclipse.oomph.setup.Product;
import org.eclipse.oomph.setup.Project;
import org.eclipse.oomph.setup.Scope;
import org.eclipse.oomph.setup.Stream;
import org.eclipse.oomph.setup.Workspace;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.setup.ui.SetupEditorSupport;
import org.eclipse.oomph.setup.ui.SetupLabelProvider;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.recorder.RecorderManager;
import org.eclipse.oomph.setup.ui.recorder.RecorderPoliciesComposite;
import org.eclipse.oomph.setup.ui.recorder.RecorderTransaction;
import org.eclipse.oomph.setup.ui.synchronizer.SynchronizerManager;
import org.eclipse.oomph.ui.SearchField;
import org.eclipse.oomph.ui.ToolButton;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecorderPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static RecorderPreferencePage instance;
    private final URIConverter uriConverter = SetupCoreUtil.createResourceSet().getURIConverter();
    private RecorderTransaction transaction;
    private Button enableButton;
    private TableCombo targetCombo;
    private ToolButton editButton;
    private Label policiesLabel;
    private SearchField policiesFilter;
    private RecorderPoliciesComposite policiesComposite;

    public RecorderPreferencePage() {
        instance = this;
    }

    public void init(IWorkbench workbench) {
    }

    public void dispose() {
        if (this.transaction != null && !this.enableButton.getSelection()) {
            this.transaction.close();
            this.transaction = null;
        }
        instance = null;
        super.dispose();
    }

    protected Control createContents(Composite parent) {
        if (!RecorderManager.INSTANCE.isUser()) {
            Label label = new Label(parent, 0);
            label.setText("The preference recorder settings are unavailable while recording into the selected file.");
            return label;
        }
        int columns = 3;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)UIUtil.createGridLayout((int)columns));
        this.enableButton = new Button(composite, 32);
        this.enableButton.setText("Record into:");
        this.enableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enableRecorder = RecorderPreferencePage.this.enableButton.getSelection();
                RecorderManager.INSTANCE.setRecorderEnabled(enableRecorder);
                if (!enableRecorder) {
                    RecorderPreferencePage.this.policiesFilter.getFilterControl().setText("");
                }
                RecorderPreferencePage.updateEnablement();
                RecorderManager.updateRecorderCheckboxState();
                if (enableRecorder) {
                    SynchronizerManager.INSTANCE.offerFirstTimeConnect(RecorderPreferencePage.this.getShell());
                }
            }
        });
        this.targetCombo = new TableCombo(composite, 2056);
        this.targetCombo.setLayoutData((Object)new GridData(768));
        this.targetCombo.defineColumns(2);
        this.targetCombo.setToolTipText("Select the recorder target file");
        this.targetCombo.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item;
                URI uri;
                URI oldURI;
                if (e.item instanceof TableItem && (oldURI = RecorderManager.INSTANCE.setRecorderTarget(uri = (URI)(item = (TableItem)e.item).getData())) != null) {
                    if (RecorderPreferencePage.this.transaction != null) {
                        int dirtyPolicies = RecorderPreferencePage.this.transaction.getPolicies(false).size();
                        if (dirtyPolicies != 0 && MessageDialog.openQuestion((Shell)RecorderPreferencePage.this.getShell(), (String)"Changed Recorder Policies", (String)"Do you want to save the changed policies before you change the recorder target?")) {
                            RecorderPreferencePage.this.transaction.commit();
                        }
                        RecorderPreferencePage.this.transaction.close();
                        RecorderPreferencePage.this.transaction = null;
                    }
                    RecorderPreferencePage.this.openRecorderTransaction(null);
                }
            }
        });
        ComposedAdapterFactory adapterFactory = BaseEditUtil.createAdapterFactory();
        SetupContext setupContext = SetupContext.getSelf();
        HashSet<Scope> targets = new HashSet<Scope>();
        this.addTarget(adapterFactory, targets, (Scope)setupContext.getUser());
        Installation installation = setupContext.getInstallation();
        this.addTarget(adapterFactory, targets, (Scope)installation);
        Workspace workspace = setupContext.getWorkspace();
        this.addTarget(adapterFactory, targets, (Scope)workspace);
        if (installation != null) {
            this.addTarget(adapterFactory, targets, (Scope)installation.getProductVersion());
        }
        if (workspace != null) {
            for (Stream stream : workspace.getStreams()) {
                this.addTarget(adapterFactory, targets, (Scope)stream);
            }
        }
        URI uri = RecorderManager.INSTANCE.getRecorderTarget();
        this.selectRecorderTarget(uri);
        adapterFactory.dispose();
        this.editButton = new ToolButton(composite, 0, SetupUIPlugin.INSTANCE.getSWTImage("edit.gif"), false);
        this.editButton.setToolTipText("Open the recorder target file");
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SetupEditorSupport.getEditor(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), RecorderManager.INSTANCE.getRecorderTarget(), true, new SetupEditorSupport.LoadHandler[0]);
                Map<String, Boolean> policies = null;
                if (RecorderPreferencePage.this.transaction != null) {
                    policies = RecorderPreferencePage.this.transaction.getPolicies(false);
                    RecorderPreferencePage.this.transaction.close();
                    RecorderPreferencePage.this.transaction = null;
                }
                RecorderPreferencePage.this.openRecorderTransaction(policies);
                RecorderPreferencePage.updateEnablement();
            }
        });
        Label separator = new Label(composite, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, columns, 1));
        this.policiesLabel = new Label(composite, 0);
        this.policiesLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, columns, 1));
        this.policiesLabel.setText("Check the preferences to record and uncheck those to ignore:");
        SearchField.FilterHandler filterHandler = new SearchField.FilterHandler(){

            public void handleFilter(String filter) {
                ViewerFilter viewerFilter = null;
                if (filter.length() != 0) {
                    final String subString = filter.toLowerCase();
                    viewerFilter = new ViewerFilter(){

                        public boolean select(Viewer viewer, Object parentElement, Object element) {
                            return ((String)element).toLowerCase().contains(subString);
                        }
                    };
                }
                RecorderPreferencePage.this.policiesComposite.setFilter(viewerFilter);
                RecorderPreferencePage.this.policiesComposite.selectFirstPolicy();
            }
        };
        this.policiesFilter = new SearchField(composite, filterHandler){

            protected void finishFilter() {
                RecorderPreferencePage.this.policiesComposite.setFocus();
                RecorderPreferencePage.this.policiesComposite.selectFirstPolicy();
            }
        };
        this.policiesFilter.setLayoutData((Object)new GridData(4, 0x1000000, true, false, columns, 1));
        this.policiesComposite = new RecorderPoliciesComposite(composite, 67584, true);
        this.policiesComposite.setLayoutData(new GridData(4, 4, true, true, columns, 1));
        this.policiesComposite.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                RecorderPreferencePage.updateEnablement();
            }
        });
        RecorderPreferencePage.updateEnablement();
        this.openRecorderTransaction(null);
        return composite;
    }

    private void openRecorderTransaction(final Map<String, Boolean> policies) {
        Job job = new Job("Open recorder transaction"){

            protected IStatus run(IProgressMonitor monitor) {
                RecorderPreferencePage.this.transaction = RecorderTransaction.open();
                RecorderPreferencePage.this.transaction.setPolicies(policies);
                UIUtil.asyncExec((Runnable)new Runnable(){

                    public void run() {
                        RecorderPreferencePage.updateEnablement();
                        RecorderPreferencePage.this.policiesComposite.setRecorderTransaction(RecorderPreferencePage.this.transaction);
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    protected void performDefaults() {
        this.transaction.resetPolicies();
        this.policiesComposite.setRecorderTransaction(this.transaction);
        super.performDefaults();
    }

    protected void performApply() {
        super.performApply();
        RecorderPreferencePage.updateEnablement();
    }

    public boolean performOk() {
        if (this.transaction != null) {
            this.transaction.commit();
        }
        return super.performOk();
    }

    private boolean needsApply() {
        return this.transaction != null && this.transaction.isDirty();
    }

    private void selectRecorderTarget(URI uri) {
        uri = RecorderManager.normalize(this.uriConverter, uri);
        int i = 0;
        TableItem[] tableItemArray = this.targetCombo.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            URI itemURI = (URI)item.getData();
            if (ObjectUtil.equals((Object)itemURI, (Object)uri)) {
                this.targetCombo.select(i);
                return;
            }
            ++i;
            ++n2;
        }
    }

    private boolean addTarget(ComposedAdapterFactory adapterFactory, Set<Scope> targets, Scope target) {
        URI uri;
        if (target != null && targets.add(target) && (uri = EcoreUtil.getURI((EObject)target)) != null) {
            boolean writable;
            Map<String, Set<String>> options;
            Map attributes = this.uriConverter.getAttributes(uri = RecorderManager.normalize(this.uriConverter, uri), options = Collections.singletonMap("requestedAttributes", Collections.singleton("readOnly")));
            boolean bl = writable = !Boolean.TRUE.equals(attributes.get("readOnly"));
            if (writable) {
                Scope parentScope = target.getParentScope();
                if (parentScope instanceof Product || parentScope instanceof Project) {
                    this.addTarget(adapterFactory, targets, parentScope);
                }
                String location = uri.trimFragment().toString();
                ItemProviderAdapter itemProvider = (ItemProviderAdapter)adapterFactory.adapt((Notifier)target, IItemLabelProvider.class);
                TableItem item = new TableItem(this.targetCombo.getTable(), 0);
                item.setData((Object)uri);
                item.setImage(0, SetupUIPlugin.INSTANCE.getSWTImage(SetupLabelProvider.getImageDescriptor(itemProvider, (EObject)target)));
                item.setText(0, SetupLabelProvider.getText(itemProvider, (EObject)target));
                item.setText(1, location);
                return true;
            }
        }
        return false;
    }

    static void updateEnablement() {
        if (instance != null) {
            Button applyButton;
            boolean recorderEnabled = RecorderManager.INSTANCE.isRecorderEnabled();
            if (RecorderPreferencePage.instance.enableButton != null) {
                RecorderPreferencePage.instance.enableButton.setSelection(recorderEnabled);
                RecorderPreferencePage.instance.targetCombo.setEnabled(recorderEnabled);
                RecorderPreferencePage.instance.editButton.setEnabled(recorderEnabled && (RecorderPreferencePage.instance.transaction == null || RecorderPreferencePage.instance.transaction.getEditor() == null));
                RecorderPreferencePage.instance.policiesLabel.setEnabled(recorderEnabled);
                RecorderPreferencePage.instance.policiesFilter.setEnabled(recorderEnabled);
                RecorderPreferencePage.instance.policiesComposite.setEnabled(recorderEnabled);
            }
            if ((applyButton = instance.getApplyButton()) != null) {
                boolean needsApply = instance.needsApply();
                applyButton.setEnabled(needsApply);
            }
        }
    }
}

