/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.core;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.oomph.p2.P2Exception;
import org.eclipse.oomph.p2.core.Agent;
import org.eclipse.oomph.p2.core.AgentManager;
import org.eclipse.oomph.p2.core.BundlePool;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.internal.core.AgentImpl;
import org.eclipse.oomph.p2.internal.core.P2CorePlugin;
import org.eclipse.oomph.p2.internal.core.PersistentMap;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.MonitorUtil;
import org.eclipse.oomph.util.PropertiesUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentManagerImpl
implements AgentManager {
    private static final String AGENT_SUFFIX = ":agent";
    public static AgentManager instance;
    private final PersistentMap<Agent> agentMap;
    private final File defaultAgentLocation;
    private final File defaultsFile;
    private Agent currentAgent;
    private boolean currentAgentInMap;

    public AgentManagerImpl() {
        this(new File(PropertiesUtil.getUserHome()));
    }

    public AgentManagerImpl(final File userHome) {
        this.defaultAgentLocation = new File(userHome, ".p2");
        File folder = P2CorePlugin.getUserStateFolder(userHome);
        File infoFile = new File(folder, "agents.info");
        this.defaultsFile = new File(folder, "defaults.info");
        this.agentMap = new PersistentMap<Agent>(infoFile){

            @Override
            protected Agent loadElement(String key, String extraInfo) {
                File location = new File(key);
                if (AgentImpl.isValid(location)) {
                    return (Agent)super.loadElement(key, extraInfo);
                }
                return null;
            }

            @Override
            protected Agent createElement(String key, String extraInfo) {
                return new AgentImpl(AgentManagerImpl.this, new File(key));
            }

            @Override
            protected void initializeFirstTime() {
                Collection<BundlePool> bundlePools;
                this.initializeFirstTime(AgentManagerImpl.this.defaultAgentLocation);
                this.initializeFirstTime(new File(userHome, "p2"));
                this.initializeFirstTime(new File(userHome, ".eclipse"));
                this.initializeFirstTime(new File(userHome, "eclipse"));
                if (this.getElements().isEmpty()) {
                    AgentManagerImpl.this.addAgent(AgentManagerImpl.this.defaultAgentLocation);
                }
                if ((bundlePools = AgentManagerImpl.this.getBundlePools()).isEmpty()) {
                    Agent agent = AgentManagerImpl.this.getAgent(AgentManagerImpl.this.defaultAgentLocation);
                    if (agent == null) {
                        Collection<Agent> agents = AgentManagerImpl.this.getAgents();
                        agent = agents.iterator().next();
                    }
                    File poolLocation = new File(agent.getLocation(), "pool");
                    agent.addBundlePool(poolLocation);
                }
            }

            private void initializeFirstTime(File location) {
                if (IOUtil.isValidFolder((File)location)) {
                    if (AgentImpl.isValid(location)) {
                        AgentManagerImpl.this.addAgent(location);
                    } else {
                        File[] fileArray = location.listFiles();
                        int n = fileArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File child = fileArray[n2];
                            this.initializeFirstTime(child);
                            ++n2;
                        }
                    }
                }
            }
        };
        this.agentMap.load();
    }

    public PersistentMap<Agent> getAgentMap() {
        return this.agentMap;
    }

    public void dispose() {
        for (Agent agent : this.getAgents()) {
            ((AgentImpl)agent).dispose();
        }
        if (!this.currentAgentInMap && this.currentAgent != null) {
            ((AgentImpl)this.currentAgent).dispose();
        }
    }

    @Override
    public synchronized Agent getCurrentAgent() {
        if (this.currentAgent == null) {
            BundleContext context = P2CorePlugin.INSTANCE.getBundleContext();
            ServiceReference reference = context.getServiceReference(IProvisioningAgent.class);
            if (reference == null) {
                throw new P2Exception("Current provisioning agent could not be loaded");
            }
            try {
                IProvisioningAgent provisioningAgent = (IProvisioningAgent)context.getService(reference);
                File agentLocation = P2Util.getAgentLocation(provisioningAgent);
                Agent agent = this.getAgent(agentLocation);
                if (agent != null) {
                    this.currentAgent = agent;
                    this.currentAgentInMap = true;
                } else {
                    this.currentAgent = new AgentImpl(this, agentLocation);
                }
                ((AgentImpl)this.currentAgent).initializeProvisioningAgent(provisioningAgent);
            }
            finally {
                context.ungetService(reference);
            }
        }
        return this.currentAgent;
    }

    @Override
    public File getDefaultAgentLocation() {
        return this.defaultAgentLocation;
    }

    @Override
    public Set<File> getAgentLocations() {
        return AgentManagerImpl.getLocations(this.agentMap.getElementKeys());
    }

    @Override
    public Collection<Agent> getAgents() {
        return this.agentMap.getElements();
    }

    @Override
    public Agent getAgent(File location) {
        return this.agentMap.getElement(location.getAbsolutePath());
    }

    @Override
    public Agent addAgent(File location) {
        return this.agentMap.addElement(location.getAbsolutePath(), null);
    }

    public void deleteAgent(Agent agent) {
        this.agentMap.removeElement(agent.getLocation().getAbsolutePath());
    }

    @Override
    public void refreshAgents(IProgressMonitor monitor) {
        monitor.beginTask("Refreshing agents...", 21);
        try {
            this.agentMap.refresh();
            monitor.worked(1);
            Collection<Agent> agents = this.getAgents();
            this.refreshAgents(agents, (IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)20));
        }
        finally {
            monitor.done();
        }
    }

    private void refreshAgents(Collection<Agent> agents, IProgressMonitor monitor) {
        monitor.beginTask("", 21 * agents.size());
        try {
            for (Agent agent : agents) {
                P2CorePlugin.checkCancelation((IProgressMonitor)monitor);
                monitor.subTask("Refreshing " + agent.getLocation());
                agent.refreshBundlePools((IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)1));
                agent.refreshProfiles((IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)20));
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public Collection<BundlePool> getBundlePools() {
        ArrayList<BundlePool> bundlePools = new ArrayList<BundlePool>();
        for (Agent agent : this.getAgents()) {
            bundlePools.addAll(agent.getBundlePools());
        }
        return bundlePools;
    }

    @Override
    public BundlePool getBundlePool(File location) throws P2Exception {
        for (Agent agent : this.getAgents()) {
            BundlePool bundlePool = agent.getBundlePool(location);
            if (bundlePool == null) continue;
            return bundlePool;
        }
        return null;
    }

    private BundlePool getBundlePool(String path) throws P2Exception {
        File location = new File(path);
        if (location.isDirectory()) {
            return this.getBundlePool(location);
        }
        return null;
    }

    @Override
    public BundlePool getDefaultBundlePool(String client) throws P2Exception {
        Properties defaults = this.loadDefaults();
        BundlePool bundlePool = null;
        try {
            bundlePool = this.restoreBundlePool(client, defaults);
            if (bundlePool != null) {
                return bundlePool;
            }
        }
        catch (Exception ex) {
            P2CorePlugin.INSTANCE.log(ex);
        }
        for (Object otherClient : defaults.keySet()) {
            String clientId = (String)otherClient;
            if (clientId == null || clientId.equals(client) || clientId.endsWith(AGENT_SUFFIX)) continue;
            try {
                bundlePool = this.restoreBundlePool(clientId, defaults);
                if (bundlePool == null) continue;
                return bundlePool;
            }
            catch (Exception ex) {
                P2CorePlugin.INSTANCE.log(ex);
            }
        }
        return this.getDefaultBundlePool();
    }

    private BundlePool getDefaultBundlePool() throws P2Exception {
        File defaultPoolLocation = new File(this.defaultAgentLocation, "pool");
        BundlePool bundlePool = this.getBundlePool(defaultPoolLocation);
        if (bundlePool != null) {
            return bundlePool;
        }
        Agent agent = this.addAgent(this.defaultAgentLocation);
        Collection<BundlePool> bundlePools = agent.getBundlePools();
        if (!bundlePools.isEmpty()) {
            return bundlePools.iterator().next();
        }
        return agent.addBundlePool(defaultPoolLocation);
    }

    @Override
    public void setDefaultBundlePool(String client, BundlePool bundlePool) {
        Properties defaults = this.loadDefaults();
        String bundlePoolLocation = bundlePool.getLocation().getAbsolutePath();
        Object oldBundlePoolLocation = defaults.put(client, bundlePoolLocation);
        String agentLocation = bundlePool.getAgent().getLocation().getAbsolutePath();
        Object oldAgentLocation = defaults.put(String.valueOf(client) + AGENT_SUFFIX, agentLocation);
        if (!bundlePoolLocation.equals(oldBundlePoolLocation) || !agentLocation.equals(oldAgentLocation)) {
            this.saveDefaults(defaults);
        }
    }

    private BundlePool restoreBundlePool(String client, Properties defaults) {
        String location = defaults.getProperty(client);
        if (location != null) {
            File agentDir;
            Agent agent;
            String agentLocation;
            BundlePool bundlePool = this.getBundlePool(location);
            if (bundlePool == null && (agentLocation = defaults.getProperty(String.valueOf(client) + AGENT_SUFFIX)) != null && (agent = this.addAgent(agentDir = new File(agentLocation))) != null) {
                File poolDir = new File(location);
                bundlePool = agent.addBundlePool(poolDir);
            }
            return bundlePool;
        }
        return null;
    }

    public Set<String> getClientsFor(String bundlePoolLocation) {
        HashSet<String> clients = new HashSet<String>();
        Properties defaults = this.loadDefaults();
        for (Map.Entry<Object, Object> entry : defaults.entrySet()) {
            String location;
            String client = (String)entry.getKey();
            if (client == null || client.endsWith(AGENT_SUFFIX) || !(location = (String)entry.getValue()).equals(bundlePoolLocation)) continue;
            clients.add(client);
        }
        return clients;
    }

    private Properties loadDefaults() {
        Properties defaults = new Properties();
        if (this.defaultsFile.exists()) {
            FileInputStream stream = null;
            try {
                try {
                    stream = new FileInputStream(this.defaultsFile);
                    defaults.load(stream);
                }
                catch (IOException ex) {
                    throw new P2Exception((Throwable)ex);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(stream);
                throw throwable;
            }
            IOUtil.close((Closeable)stream);
        }
        return defaults;
    }

    private void saveDefaults(Properties defaults) {
        block5: {
            FileOutputStream stream = null;
            try {
                try {
                    stream = new FileOutputStream(this.defaultsFile);
                    defaults.store(stream, "P2 clients store their default bundle pool locations here");
                }
                catch (IOException ex) {
                    P2CorePlugin.INSTANCE.log(ex);
                    IOUtil.close((Closeable)stream);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(stream);
                throw throwable;
            }
            IOUtil.close((Closeable)stream);
        }
    }

    public static Set<File> getLocations(Set<String> keys) {
        HashSet<File> locations = new HashSet<File>();
        for (String key : keys) {
            locations.add(new File(key));
        }
        return locations;
    }
}

