/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.jdt.provider;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.oomph.setup.jdt.JDTFactory;
import org.eclipse.oomph.setup.jdt.JDTPackage;
import org.eclipse.oomph.setup.jdt.JRETask;
import org.eclipse.oomph.setup.jdt.provider.JDTEditPlugin;
import org.eclipse.oomph.setup.provider.SetupTaskItemProvider;
import org.eclipse.oomph.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRETaskItemProvider
extends SetupTaskItemProvider {
    private static Map<String, String> VERSION_VARIABLES = new LinkedHashMap<String, String>();

    static {
        VERSION_VARIABLES.put("JRE-1.1", "${jre.location-1.1}");
        VERSION_VARIABLES.put("J2SE-1.2", "${jre.location-1.2}");
        VERSION_VARIABLES.put("J2SE-1.3", "${jre.location-1.3}");
        VERSION_VARIABLES.put("J2SE-1.4", "${jre.location-1.4}");
        VERSION_VARIABLES.put("J2SE-1.5", "${jre.location-1.5}");
        VERSION_VARIABLES.put("JavaSE-1.6", "${jre.location-1.6}");
        VERSION_VARIABLES.put("JavaSE-1.7", "${jre.location-1.7}");
        VERSION_VARIABLES.put("JavaSE-1.8", "${jre.location-1.8}");
        VERSION_VARIABLES.put("JavaSE-9", "${jre.location-9}");
    }

    public JRETaskItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addVersionPropertyDescriptor(object);
            this.addLocationPropertyDescriptor(object);
            this.addNamePropertyDescriptor(object);
            this.addVMInstallTypePropertyDescriptor(object);
            this.addExecutionEnvironmentDefaultPropertyDescriptor(object);
            this.addVMArgumentsPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addVersionPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_JRETask_version_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_JRETask_version_feature", "_UI_JRETask_type"), (EStructuralFeature)JDTPackage.Literals.JRE_TASK__VERSION, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null){

            public Collection<?> getChoiceOfValues(Object object) {
                return VERSION_VARIABLES.keySet();
            }
        });
    }

    protected Command createSetCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value) {
        Command result = super.createSetCommand(domain, owner, feature, value);
        if (feature == JDTPackage.Literals.JRE_TASK__VERSION) {
            CompoundCommand compoundCommand = new CompoundCommand(0);
            compoundCommand.append(result);
            compoundCommand.append(this.createSetCommand(domain, owner, (EStructuralFeature)JDTPackage.Literals.JRE_TASK__LOCATION, VERSION_VARIABLES.get(value)));
            result = compoundCommand;
        }
        return result;
    }

    protected void addLocationPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_JRETask_location_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_JRETask_location_feature", "_UI_JRETask_type"), (EStructuralFeature)JDTPackage.Literals.JRE_TASK__LOCATION, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addNamePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_JRETask_name_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_JRETask_name_feature", "_UI_JRETask_type"), (EStructuralFeature)JDTPackage.Literals.JRE_TASK__NAME, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addVMInstallTypePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_JRETask_vMInstallType_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_JRETask_vMInstallType_feature", "_UI_JRETask_type"), (EStructuralFeature)JDTPackage.Literals.JRE_TASK__VM_INSTALL_TYPE, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null){

            public Collection<?> getChoiceOfValues(Object object) {
                IVMInstallType[] vmInstallTypes;
                UniqueEList result = new UniqueEList();
                IVMInstallType[] iVMInstallTypeArray = vmInstallTypes = JavaRuntime.getVMInstallTypes();
                int n = vmInstallTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    IVMInstallType vmInstallType = iVMInstallTypeArray[n2];
                    result.add(vmInstallType.getId());
                    ++n2;
                }
                JRETask jreTask = (JRETask)object;
                String vmInstallType = jreTask.getVMInstallType();
                if (vmInstallType != null) {
                    result.add(vmInstallType);
                }
                return result;
            }
        });
    }

    protected void addExecutionEnvironmentDefaultPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_JRETask_executionEnvironmentDefault_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_JRETask_executionEnvironmentDefault_feature", "_UI_JRETask_type"), (EStructuralFeature)JDTPackage.Literals.JRE_TASK__EXECUTION_ENVIRONMENT_DEFAULT, true, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
    }

    protected void addVMArgumentsPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_JRETask_vMArguments_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_JRETask_vMArguments_feature", "_UI_JRETask_type"), (EStructuralFeature)JDTPackage.Literals.JRE_TASK__VM_ARGUMENTS, true, true, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(JDTPackage.Literals.JRE_TASK__JRE_LIBRARIES);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/JRETask"));
    }

    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getText(Object object) {
        JRETask jre = (JRETask)object;
        String name = jre.getName();
        String location = jre.getLocation();
        if (StringUtil.isEmpty((String)name)) {
            return this.getString("_UI_JRETask_type");
        }
        String label = name;
        if (location != null) {
            label = location.length() == 0 ? String.valueOf(label) + " = \"\"" : String.valueOf(label) + " = " + location;
        }
        return label;
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(JRETask.class)) {
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 16: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(JDTPackage.Literals.JRE_TASK__JRE_LIBRARIES, JDTFactory.eINSTANCE.createJRELibrary()));
    }

    public ResourceLocator getResourceLocator() {
        return JDTEditPlugin.INSTANCE;
    }
}

