/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.equinox.p2.core.UIServices;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.oomph.base.provider.BaseEditUtil;
import org.eclipse.oomph.p2.internal.ui.P2ServiceUI;
import org.eclipse.oomph.setup.Index;
import org.eclipse.oomph.setup.Installation;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.Trigger;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.Workspace;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.SetupTaskPerformer;
import org.eclipse.oomph.setup.internal.core.util.CatalogManager;
import org.eclipse.oomph.setup.internal.core.util.ECFURIHandlerImpl;
import org.eclipse.oomph.setup.internal.core.util.ResourceMirror;
import org.eclipse.oomph.setup.internal.core.util.SetupUtil;
import org.eclipse.oomph.setup.ui.SetupPropertyTester;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.wizards.ConfirmationPage;
import org.eclipse.oomph.setup.ui.wizards.ProductPage;
import org.eclipse.oomph.setup.ui.wizards.ProgressPage;
import org.eclipse.oomph.setup.ui.wizards.ProjectPage;
import org.eclipse.oomph.setup.ui.wizards.SetupWizardDialog;
import org.eclipse.oomph.setup.ui.wizards.SetupWizardPage;
import org.eclipse.oomph.setup.ui.wizards.VariablePage;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public abstract class SetupWizard
extends Wizard
implements IPageChangedListener {
    public static final String HELP_FOLDER = "/org.eclipse.oomph.setup.doc/html/user/wizard/";
    static boolean ecfWorkAround;
    private Trigger trigger;
    private Object lastPage;
    private ResourceSet resourceSet;
    private CatalogManager catalogManager;
    private SetupContext setupContext;
    private SetupTaskPerformer performer;
    private Runnable finishAction;
    private ComposedAdapterFactory adapterFactory;
    private boolean isCanceled;

    public SetupWizard() {
        this((SetupTaskPerformer)null);
    }

    public SetupWizard(SetupTaskPerformer performer) {
        this.initUI();
        if (performer == null) {
            this.resourceSet = SetupUtil.createResourceSet();
            this.setTrigger(Trigger.STARTUP);
            if (SetupContext.WORKSPACE_LOCATION_URI != null) {
                this.setSetupContext(SetupContext.create((ResourceSet)this.resourceSet));
            }
        } else {
            this.performer = performer;
            this.setTrigger(performer.getTrigger());
            this.setSetupContext(performer.getSetupContext());
            this.resourceSet = performer.getUser().eResource().getResourceSet();
        }
    }

    public SetupWizard(SetupContext setupContext) {
        this.initUI();
        this.setTrigger(Trigger.STARTUP);
        this.setSetupContext(setupContext);
        this.resourceSet = setupContext.getUser().eResource().getResourceSet();
    }

    private void initUI() {
        this.setDefaultPageImageDescriptor(SetupUIPlugin.INSTANCE.getImageDescriptor("install_wiz.png"));
        this.setNeedsProgressMonitor(false);
    }

    public abstract String getHelpPath();

    public ComposedAdapterFactory getAdapterFactory() {
        if (this.adapterFactory == null) {
            this.adapterFactory = BaseEditUtil.createAdapterFactory();
        }
        return this.adapterFactory;
    }

    public void setTrigger(Trigger trigger) {
        this.trigger = trigger;
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public void setFinishAction(Runnable finishAction) {
        this.finishAction = finishAction;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public CatalogManager getCatalogManager() {
        if (this.catalogManager == null) {
            this.catalogManager = new CatalogManager();
        }
        return this.catalogManager;
    }

    public SetupContext getSetupContext() {
        return this.setupContext;
    }

    public void setSetupContext(SetupContext setupContext) {
        this.setupContext = setupContext;
    }

    public Installation getInstallation() {
        return this.setupContext == null ? null : this.setupContext.getInstallation();
    }

    public Workspace getWorkspace() {
        return this.setupContext == null ? null : this.setupContext.getWorkspace();
    }

    public User getUser() {
        return this.setupContext == null ? null : this.setupContext.getUser();
    }

    public SetupTaskPerformer getPerformer() {
        return this.performer;
    }

    public void setPerformer(SetupTaskPerformer performer) {
        this.performer = performer;
    }

    public void setContainer(IWizardContainer newContainer) {
        IWizardContainer oldContainer = this.getContainer();
        if (oldContainer instanceof IPageChangeProvider) {
            ((IPageChangeProvider)oldContainer).removePageChangedListener((IPageChangedListener)this);
        }
        super.setContainer(newContainer);
        if (newContainer instanceof IPageChangeProvider) {
            ((IPageChangeProvider)newContainer).addPageChangedListener((IPageChangedListener)this);
        }
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        if (SetupPropertyTester.getHandlingShell() == null) {
            SetupPropertyTester.setHandlingShell(pageContainer.getShell());
        }
    }

    public void addPages() {
        IDialogSettings wizardSection = SetupUIPlugin.INSTANCE.getDialogSettings(((Object)((Object)this)).getClass().getSimpleName());
        this.setDialogSettings(wizardSection);
        this.addPage((IWizardPage)new VariablePage());
        this.addPage((IWizardPage)new ConfirmationPage());
        this.addPage((IWizardPage)new ProgressPage());
    }

    public void pageChanged(PageChangedEvent event) {
        Object targetPage = event.getSelectedPage();
        boolean forward = true;
        if (this.lastPage != null) {
            IWizardPage[] iWizardPageArray = this.getPages();
            int n = iWizardPageArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWizardPage page = iWizardPageArray[n2];
                if (page == this.lastPage) break;
                if (page == targetPage) {
                    forward = false;
                    break;
                }
                ++n2;
            }
            if (this.lastPage instanceof SetupWizardPage) {
                ((SetupWizardPage)((Object)this.lastPage)).leavePage(forward);
            }
        }
        this.lastPage = targetPage;
        if (this.isCanceled) {
            this.dispose();
            this.getContainer().getShell().dispose();
        } else if (targetPage instanceof SetupWizardPage) {
            SetupWizardPage setupWizardPage = (SetupWizardPage)((Object)targetPage);
            setupWizardPage.enterPage(forward);
        }
    }

    public boolean performCancel() {
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (!((SetupWizardPage)page).performCancel()) {
                return false;
            }
            ++n2;
        }
        this.isCanceled = true;
        this.clearStartupProperties();
        return true;
    }

    public boolean canFinish() {
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (!page.isPageComplete()) {
                if (page instanceof ProgressPage && this.lastPage instanceof ConfirmationPage) break;
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean performFinish() {
        if (this.lastPage instanceof ProgressPage) {
            this.clearStartupProperties();
            if (this.finishAction != null) {
                UIUtil.syncExec((Runnable)this.finishAction);
            }
            return true;
        }
        ((SetupWizardPage)((Object)this.lastPage)).advanceToNextPage();
        return false;
    }

    private void clearStartupProperties() {
        System.clearProperty("oomph.setup.offline.startup");
        System.clearProperty("oomph.setup.mirrors.startup");
    }

    public int openDialog(Shell parentShell) {
        SetupWizardDialog dialog = new SetupWizardDialog(parentShell, this);
        return dialog.open();
    }

    protected void reloadIndex() {
        Workspace workspace;
        HashSet<Resource> excludedResources = new HashSet<Resource>();
        Resource selectionResource = this.getCatalogManager().getSelection().eResource();
        excludedResources.add(selectionResource);
        Installation installation = this.setupContext.getInstallation();
        if (installation != null) {
            excludedResources.add(installation.eResource());
        }
        if ((workspace = this.setupContext.getWorkspace()) != null) {
            excludedResources.add(workspace.eResource());
        }
        User user = this.setupContext.getUser();
        excludedResources.add(user.eResource());
        EList resources = this.resourceSet.getResources();
        Iterator it = resources.iterator();
        while (it.hasNext()) {
            Resource resource = (Resource)it.next();
            if (excludedResources.contains(resource)) continue;
            if ("ecore".equals(resource.getURI().fileExtension())) {
                it.remove();
                continue;
            }
            resource.unload();
        }
        resources.remove((Object)selectionResource);
        ECFURIHandlerImpl.clearExpectedETags();
        this.resourceSet.getLoadOptions().put("OPTION_CACHE_HANDLING", ECFURIHandlerImpl.CacheHandling.CACHE_WITH_ETAG_CHECKING);
        this.resourceSet.getPackageRegistry().clear();
        this.loadIndex();
        for (Resource resource : excludedResources) {
            EcoreUtil.resolveAll((Resource)resource);
        }
    }

    protected void loadIndex() {
        this.loadIndex(SetupContext.INDEX_SETUP_URI, SetupContext.USER_SETUP_URI);
    }

    protected void loadIndex(final URI ... uris) {
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.getShell());
        try {
            progressMonitorDialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    ResourceMirror resourceMirror = new ResourceMirror(SetupWizard.this.resourceSet){

                        protected void run(String taskName, IProgressMonitor monitor) {
                            this.perform(uris);
                        }
                    };
                    resourceMirror.begin(monitor);
                    if (resourceMirror.isCanceled()) {
                        SetupWizard.this.getShell().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                SetupWizard.this.resourceSet.getLoadOptions().put("OPTION_CACHE_HANDLING", ECFURIHandlerImpl.CacheHandling.CACHE_WITHOUT_ETAG_CHECKING);
                                LinkedHashSet<URI> uris = new LinkedHashSet<URI>();
                                for (Resource resource : SetupWizard.this.resourceSet.getResources()) {
                                    URI uri = resource.getURI();
                                    if ("ecore".equals(uri.fileExtension())) continue;
                                    uris.add(resource.getURI());
                                }
                                SetupWizard.this.loadIndex(uris.toArray(new URI[uris.size()]));
                            }
                        });
                    } else {
                        Resource resource = SetupWizard.this.resourceSet.getResource(SetupContext.INDEX_SETUP_URI, false);
                        final Index index = (Index)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)SetupPackage.Literals.INDEX);
                        if (index != null) {
                            SetupWizard.this.getShell().getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    SetupWizard.this.indexLoaded(index);
                                }
                            });
                        }
                    }
                }
            });
        }
        catch (InvocationTargetException ex) {
            SetupUIPlugin.INSTANCE.log(ex);
        }
        catch (InterruptedException interruptedException) {}
    }

    protected void indexLoaded(Index index) {
    }

    public void dispose() {
        super.dispose();
        this.adapterFactory.dispose();
    }

    public static class Importer
    extends SetupWizard
    implements IImportWizard {
        public Importer() {
            this.setTrigger(Trigger.MANUAL);
            this.setSetupContext(SetupContext.create((ResourceSet)this.getResourceSet()));
            this.setWindowTitle("Oomph Importer");
        }

        public String getHelpPath() {
            return "/org.eclipse.oomph.setup.doc/html/user/wizard/DocImportWizard.html";
        }

        public void init(IWorkbench workbench, IStructuredSelection selection) {
        }

        public void addPages() {
            this.addPage((IWizardPage)new ProjectPage());
            super.addPages();
            UIUtil.getDisplay().timerExec(500, new Runnable(){

                public void run() {
                    Importer.this.getResourceSet().getLoadOptions().put("OPTION_CACHE_HANDLING", ECFURIHandlerImpl.CacheHandling.CACHE_WITHOUT_ETAG_CHECKING);
                    Importer.this.loadIndex();
                }
            });
        }

        protected void indexLoaded(Index index) {
            this.getCatalogManager().indexLoaded(index);
        }
    }

    public static class Installer
    extends SetupWizard {
        public static final P2ServiceUI SERVICE_UI = new P2ServiceUI();

        public Installer() {
            this.setTrigger(Trigger.BOOTSTRAP);
            this.setSetupContext(SetupContext.createUserOnly((ResourceSet)this.getResourceSet()));
            this.setWindowTitle("Oomph Installer");
        }

        public String getHelpPath() {
            return "/org.eclipse.oomph.setup.doc/html/user/wizard/DocInstallWizard.html";
        }

        public void addPages() {
            this.addPage((IWizardPage)new ProductPage());
            this.addPage((IWizardPage)new ProjectPage());
            super.addPages();
            this.getShell().getDisplay().timerExec(500, new Runnable(){

                public void run() {
                    Installer.this.getResourceSet().getLoadOptions().put("OPTION_CACHE_HANDLING", ECFURIHandlerImpl.CacheHandling.CACHE_WITHOUT_ETAG_CHECKING);
                    Installer.this.loadIndex();
                }
            });
        }

        protected void indexLoaded(Index index) {
            this.getCatalogManager().indexLoaded(index);
        }

        public void setPerformer(SetupTaskPerformer performer) {
            super.setPerformer(performer);
            if (performer != null) {
                performer.put(UIServices.class, (Object)SERVICE_UI);
            }
        }
    }

    public static class Updater
    extends SetupWizard {
        public Updater(boolean manual) {
            this.setTrigger(manual ? Trigger.MANUAL : Trigger.STARTUP);
            this.setSetupContext(SetupContext.create((ResourceSet)this.getResourceSet()));
            this.setWindowTitle("Oomph Updater");
        }

        public Updater(SetupTaskPerformer performer) {
            super(performer);
        }

        public Updater(SetupContext setupContext) {
            super(setupContext);
        }

        public String getHelpPath() {
            return "/org.eclipse.oomph.setup.doc/html/user/wizard/DocUpdateWizard.html";
        }
    }
}

