/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.recorder;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.oomph.setup.ui.recorder.RecorderManager;
import org.eclipse.oomph.setup.ui.recorder.RecorderPoliciesComposite;
import org.eclipse.oomph.setup.ui.recorder.RecorderTransaction;
import org.eclipse.oomph.ui.SearchField;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class RecorderPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static RecorderPreferencePage instance;
    private RecorderTransaction transaction;
    private Button enableButton;
    private Label policiesLabel;
    private SearchField searchField;
    private RecorderPoliciesComposite policiesComposite;

    public RecorderPreferencePage() {
        instance = this;
    }

    public void init(IWorkbench workbench) {
    }

    public void dispose() {
        if (this.transaction != null && !this.enableButton.getSelection()) {
            this.transaction.close();
            this.transaction = null;
        }
        instance = null;
        super.dispose();
    }

    protected Control createContents(Composite parent) {
        final Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.enableButton = new Button(composite, 32);
        this.enableButton.setText("Enabled");
        this.enableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean recorderEnabled = RecorderPreferencePage.this.enableButton.getSelection();
                RecorderManager.INSTANCE.setRecorderEnabled(recorderEnabled);
                if (!recorderEnabled) {
                    RecorderPreferencePage.this.searchField.getFilterControl().setText("");
                }
                RecorderPreferencePage.updateEnablement();
                RecorderManager.updateRecorderCheckboxState();
            }
        });
        Job job = new Job("Open recorder transaction"){

            protected IStatus run(IProgressMonitor monitor) {
                RecorderPreferencePage.this.transaction = RecorderTransaction.open();
                UIUtil.asyncExec((Runnable)new Runnable(){

                    public void run() {
                        Label separator = new Label(composite, 258);
                        separator.setLayoutData((Object)new GridData(768));
                        RecorderPreferencePage.this.policiesLabel = new Label(composite, 0);
                        RecorderPreferencePage.this.policiesLabel.setText("Policies define whether to record or ignore preference changes:");
                        SearchField.FilterHandler filterHandler = new SearchField.FilterHandler(){

                            public void handleFilter(String filter) {
                                ViewerFilter viewerFilter = null;
                                if (filter.length() != 0) {
                                    final String subString = filter.toLowerCase();
                                    viewerFilter = new ViewerFilter(){

                                        public boolean select(Viewer viewer, Object parentElement, Object element) {
                                            return ((String)element).toLowerCase().contains(subString);
                                        }
                                    };
                                }
                                RecorderPreferencePage.this.policiesComposite.setFilter(viewerFilter);
                                RecorderPreferencePage.this.policiesComposite.selectFirstPolicy();
                            }
                        };
                        RecorderPreferencePage.this.searchField = new SearchField(composite, filterHandler){

                            protected void finishFilter() {
                                RecorderPreferencePage.this.policiesComposite.setFocus();
                                RecorderPreferencePage.this.policiesComposite.selectFirstPolicy();
                            }
                        };
                        RecorderPreferencePage.this.searchField.setLayoutData((Object)new GridData(768));
                        RecorderPreferencePage.this.policiesComposite = new RecorderPoliciesComposite(composite, 67584, RecorderPreferencePage.this.transaction, true);
                        RecorderPreferencePage.this.policiesComposite.setLayoutData(new GridData(1808));
                        RecorderPreferencePage.this.policiesComposite.addCheckStateListener(new ICheckStateListener(){

                            public void checkStateChanged(CheckStateChangedEvent event) {
                                String key = (String)event.getElement();
                                boolean policy = event.getChecked();
                                RecorderPreferencePage.this.transaction.setPolicy(key, policy);
                                RecorderPreferencePage.updateEnablement();
                            }
                        });
                        composite.layout();
                        RecorderPreferencePage.updateEnablement();
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
        return composite;
    }

    protected void performDefaults() {
        this.transaction.resetPolicies();
        this.policiesComposite.refresh();
        super.performDefaults();
    }

    protected void performApply() {
        super.performApply();
        RecorderPreferencePage.updateEnablement();
    }

    public boolean performOk() {
        this.transaction.commit();
        return super.performOk();
    }

    private boolean needsApply() {
        return this.transaction != null && this.transaction.isDirty();
    }

    static void updateEnablement() {
        if (instance != null) {
            Button applyButton;
            boolean recorderEnabled = RecorderManager.INSTANCE.isRecorderEnabled();
            if (RecorderPreferencePage.instance.enableButton != null) {
                RecorderPreferencePage.instance.enableButton.setSelection(recorderEnabled);
            }
            if (RecorderPreferencePage.instance.policiesComposite != null) {
                RecorderPreferencePage.instance.policiesLabel.setEnabled(recorderEnabled);
                RecorderPreferencePage.instance.searchField.setEnabled(recorderEnabled);
                RecorderPreferencePage.instance.policiesComposite.setEnabled(recorderEnabled);
            }
            if ((applyButton = instance.getApplyButton()) != null) {
                boolean needsApply = instance.needsApply();
                applyButton.setEnabled(needsApply);
            }
        }
    }
}

