/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.oomph.internal.ui.UIPropertyTester;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.prefs.Preferences;

public class SetupPropertyTester
extends PropertyTester {
    private static boolean starting;
    private static Shell handlingShell;
    private static Shell performingShell;
    public static final String SHOW_TOOL_BAR_CONTRIBUTIONS = "showToolBarContributions";
    private static final Preferences PREFERENCES;

    static {
        PREFERENCES = SetupUIPlugin.INSTANCE.getInstancePreferences();
    }

    public SetupPropertyTester() {
        ((IEclipsePreferences)PREFERENCES).addPreferenceChangeListener(new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                if (SetupPropertyTester.SHOW_TOOL_BAR_CONTRIBUTIONS.equals(event.getKey())) {
                    UIPropertyTester.requestEvaluation((String)"org.eclipse.oomph.setup.ui.showToolBarContributions", (boolean)"true".equals(event.getNewValue()));
                }
            }
        });
    }

    public static void setStarting(boolean starting) {
        SetupPropertyTester.starting = starting;
        UIPropertyTester.requestEvaluation((String)"org.eclipse.oomph.setup.ui.starting", (boolean)false);
    }

    private boolean testStarting(Object receiver, Object[] args, Object expectedValue) {
        if (expectedValue == null) {
            expectedValue = Boolean.TRUE;
        }
        return expectedValue.equals(starting);
    }

    public static Shell getPerformingShell() {
        return performingShell;
    }

    public static void setPerformingShell(Shell shell) {
        performingShell = shell;
        if (shell != null) {
            shell.setVisible(false);
            shell.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    SetupPropertyTester.setPerformingShell(null);
                }
            });
        }
        UIPropertyTester.requestEvaluation((String)"org.eclipse.oomph.setup.ui.performing", (shell != null ? 1 : 0) != 0);
    }

    private boolean testPerforming(Object receiver, Object[] args, Object expectedValue) {
        if (expectedValue == null) {
            expectedValue = Boolean.TRUE;
        }
        return expectedValue.equals(performingShell != null);
    }

    public static Shell getHandlingShell() {
        return handlingShell;
    }

    public static void setHandlingShell(Shell shell) {
        handlingShell = shell;
        if (shell != null) {
            shell.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    SetupPropertyTester.setHandlingShell(null);
                }
            });
        }
        UIPropertyTester.requestEvaluation((String)"org.eclipse.oomph.setup.ui.handling", (boolean)false);
    }

    private boolean testHandling(Object receiver, Object[] args, Object expectedValue) {
        if (expectedValue == null) {
            expectedValue = Boolean.TRUE;
        }
        return expectedValue.equals(handlingShell != null);
    }

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if ("starting".equals(property)) {
            return this.testStarting(receiver, args, expectedValue);
        }
        if ("performing".equals(property)) {
            return this.testPerforming(receiver, args, expectedValue);
        }
        if ("handling".equals(property)) {
            return this.testHandling(receiver, args, expectedValue);
        }
        if (SHOW_TOOL_BAR_CONTRIBUTIONS.equals(property)) {
            if (expectedValue == null) {
                expectedValue = Boolean.TRUE;
            }
            return expectedValue.equals(PREFERENCES.getBoolean(SHOW_TOOL_BAR_CONTRIBUTIONS, false));
        }
        return false;
    }
}

