/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.core;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.internal.repository.mirroring.Mirroring;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.IRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.ArtifactKeyQuery;
import org.eclipse.oomph.p2.core.Agent;
import org.eclipse.oomph.p2.core.AgentManager;
import org.eclipse.oomph.p2.internal.core.AgentImpl;
import org.eclipse.oomph.p2.internal.core.AgentManagerImpl;
import org.eclipse.oomph.p2.internal.core.P2CorePlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class P2Util {
    private static final String SIMPLE_METADATA_REPOSITORY = "org.eclipse.equinox.p2.metadata.repository.simpleRepository";
    private static final String SIMPLE_ARTIFACT_REPOSITORY = "org.eclipse.equinox.p2.artifact.repository.simpleRepository";

    private P2Util() {
    }

    public static synchronized AgentManager getAgentManager() {
        if (AgentManagerImpl.instance == null) {
            AgentManagerImpl.instance = new AgentManagerImpl();
        }
        return AgentManagerImpl.instance;
    }

    public static File getAgentLocation(IProvisioningAgent agent) {
        IAgentLocation location = (IAgentLocation)agent.getService(IAgentLocation.SERVICE_NAME);
        return URIUtil.toFile((URI)location.getRootLocation());
    }

    public static IProvisioningAgent getCurrentProvisioningAgent() {
        return P2Util.getAgentManager().getCurrentAgent().getProvisioningAgent();
    }

    public static Agent createAgent(File agentLocation) {
        return new AgentImpl((AgentManagerImpl)P2Util.getAgentManager(), agentLocation);
    }

    public static Set<String> getKnownRepositories(IRepositoryManager<?> manager) {
        HashSet<String> result = new HashSet<String>();
        URI[] uRIArray = manager.getKnownRepositories(2);
        int n = uRIArray.length;
        int n2 = 0;
        while (n2 < n) {
            URI uri = uRIArray[n2];
            result.add(uri.toString());
            ++n2;
        }
        return result;
    }

    public static <T> Iterable<T> asIterable(final IQueryResult<T> queryResult) {
        if (queryResult instanceof Iterable) {
            return queryResult;
        }
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return queryResult.iterator();
            }
        };
    }

    public static void mirrorRepository(URI sourceURI, URI targetURI, VersionedIdFilter filter, IProgressMonitor monitor) throws CoreException {
        P2Util.mirrorMetadataRepository(sourceURI, targetURI, filter, monitor);
        P2Util.mirrorArtifactRepository(sourceURI, targetURI, filter, monitor);
    }

    /*
     * Iterators could be improved
     * Unable to fully structure code
     */
    public static void mirrorMetadataRepository(URI sourceURI, URI targetURI, VersionedIdFilter filter, IProgressMonitor monitor) throws CoreException {
        repositoriesToRemove = new ArrayList<URI>();
        repositoriesToRemove.add(targetURI);
        manager = P2Util.getAgentManager().getCurrentAgent().getMetadataRepositoryManager();
        if (!manager.contains(sourceURI)) {
            repositoriesToRemove.add(sourceURI);
        }
        try {
            sourceRepository = manager.loadRepository(sourceURI, 0, monitor);
            name = sourceRepository.getName();
            if (name == null) {
                name = sourceURI.toString();
            }
            targetRepository = manager.createRepository(targetURI, name, "org.eclipse.equinox.p2.metadata.repository.simpleRepository", sourceRepository.getProperties());
            targetRepository.setProperty("p2.compressed", "true");
            ius = new ArrayList<IInstallableUnit>();
            for (IInstallableUnit iu : P2Util.asIterable(sourceRepository.query(QueryUtil.createIUAnyQuery(), null))) {
                if (filter != null && !filter.matches((IVersionedId)iu)) continue;
                ius.add(iu);
            }
            targetRepository.addInstallableUnits(ius);
        }
        finally {
            ** for (uri : repositoriesToRemove)
        }
lbl-1000:
        // 1 sources

        {
            manager.removeRepository(uri);
            continue;
        }
lbl29:
        // 1 sources

    }

    /*
     * Iterators could be improved
     * Unable to fully structure code
     */
    public static void mirrorArtifactRepository(URI sourceURI, URI targetURI, VersionedIdFilter filter, IProgressMonitor monitor) throws CoreException {
        repositoriesToRemove = new ArrayList<URI>();
        repositoriesToRemove.add(targetURI);
        agent = P2Util.getAgentManager().getCurrentAgent();
        manager = agent.getArtifactRepositoryManager();
        if (!manager.contains(sourceURI)) {
            repositoriesToRemove.add(sourceURI);
        }
        try {
            sourceRepository = manager.loadRepository(sourceURI, 0, monitor);
            name = sourceRepository.getName();
            if (name == null) {
                name = sourceURI.toString();
            }
            targetRepository = manager.createRepository(targetURI, name, "org.eclipse.equinox.p2.artifact.repository.simpleRepository", sourceRepository.getProperties());
            targetRepository.setProperty("p2.compressed", "true");
            keys = new ArrayList<IArtifactKey>();
            for (IArtifactKey key : P2Util.asIterable(sourceRepository.query((IQuery)ArtifactKeyQuery.ALL_KEYS, null))) {
                if (filter != null && !filter.matches((IVersionedId)key)) continue;
                keys.add(key);
            }
            transport = (Transport)agent.getProvisioningAgent().getService(Transport.SERVICE_NAME);
            mirror = new Mirroring(sourceRepository, targetRepository, true);
            mirror.setCompare(false);
            mirror.setTransport(transport);
            mirror.setArtifactKeys(keys.toArray(new IArtifactKey[keys.size()]));
            result = mirror.run(true, false);
            P2CorePlugin.INSTANCE.coreException((IStatus)result);
        }
        finally {
            ** for (uri : repositoriesToRemove)
        }
lbl-1000:
        // 1 sources

        {
            manager.removeRepository(uri);
            continue;
        }
lbl36:
        // 1 sources

    }

    private static MetadataFactory.InstallableUnitDescription createDescription(IInstallableUnit iu) {
        MetadataFactory.InstallableUnitDescription description = new MetadataFactory.InstallableUnitDescription();
        description.setId(iu.getId());
        description.setVersion(iu.getVersion());
        Collection artifacts = iu.getArtifacts();
        description.setArtifacts(artifacts.toArray(new IArtifactKey[artifacts.size()]));
        Collection providedCapabilities = iu.getProvidedCapabilities();
        description.setCapabilities(providedCapabilities.toArray(new IProvidedCapability[providedCapabilities.size()]));
        description.setCopyright(iu.getCopyright());
        IMatchExpression filter = iu.getFilter();
        description.setFilter(filter);
        Collection licenses = iu.getLicenses();
        description.setLicenses(licenses.toArray(new ILicense[licenses.size()]));
        Collection metaRequirements = iu.getMetaRequirements();
        description.setMetaRequirements(metaRequirements.toArray(new IRequirement[metaRequirements.size()]));
        Collection requirements = iu.getRequirements();
        description.setRequirements(requirements.toArray(new IRequirement[requirements.size()]));
        description.setSingleton(iu.isSingleton());
        description.setTouchpointType(iu.getTouchpointType());
        description.setUpdateDescriptor(iu.getUpdateDescriptor());
        for (Map.Entry entry : iu.getProperties().entrySet()) {
            description.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        for (ITouchpointData touchpointData : iu.getTouchpointData()) {
            description.addTouchpointData(touchpointData);
        }
        return description;
    }

    public static interface VersionedIdFilter {
        public boolean matches(IVersionedId var1);
    }
}

