/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.filterrow;

import java.util.Collection;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.edit.command.UpdateDataCommand;
import org.eclipse.nebula.widgets.nattable.edit.command.UpdateDataCommandHandler;
import org.eclipse.nebula.widgets.nattable.filterrow.FilterRowDataProvider;
import org.eclipse.nebula.widgets.nattable.filterrow.IFilterStrategy;
import org.eclipse.nebula.widgets.nattable.filterrow.command.ClearAllFiltersCommand;
import org.eclipse.nebula.widgets.nattable.filterrow.command.ClearFilterCommand;
import org.eclipse.nebula.widgets.nattable.filterrow.config.DefaultFilterRowConfiguration;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.event.RowStructuralRefreshEvent;

public class FilterRowDataLayer<T>
extends DataLayer {
    public static final String FILTER_ROW_COLUMN_LABEL_PREFIX = "FILTER_COLUMN_";
    public static final String PERSISTENCE_KEY_FILTER_ROW_TOKENS = ".filterTokens";
    private ILayer columnHeaderLayer;

    public FilterRowDataLayer(IFilterStrategy<T> filterStrategy, ILayer columnHeaderLayer, IDataProvider columnHeaderDataProvider, IConfigRegistry configRegistry) {
        super(new FilterRowDataProvider<T>(filterStrategy, columnHeaderLayer, columnHeaderDataProvider, configRegistry));
        this.columnHeaderLayer = columnHeaderLayer;
        this.addConfiguration(new DefaultFilterRowConfiguration());
        this.unregisterCommandHandler(UpdateDataCommand.class);
        this.registerCommandHandler(new UpdateDataCommandHandler(this, false));
    }

    public FilterRowDataProvider<T> getFilterRowDataProvider() {
        return (FilterRowDataProvider)this.dataProvider;
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        boolean handled = false;
        if (command instanceof ClearFilterCommand && command.convertToTargetLayer(this)) {
            int columnPosition = ((ClearFilterCommand)command).getColumnPosition();
            this.setDataValueByPosition(columnPosition, 0, null);
            handled = true;
        } else if (command instanceof ClearAllFiltersCommand) {
            this.getFilterRowDataProvider().clearAllFilters();
            handled = true;
        }
        if (handled) {
            this.fireLayerEvent(new RowStructuralRefreshEvent(this));
            return true;
        }
        return super.doCommand(command);
    }

    @Override
    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        LabelStack labels = super.getConfigLabelsByPosition(columnPosition, rowPosition);
        labels.addLabel(FILTER_ROW_COLUMN_LABEL_PREFIX + this.getColumnIndexByPosition(columnPosition));
        labels.addLabel("FILTER_ROW");
        return labels;
    }

    @Override
    public int getColumnCount() {
        return this.columnHeaderLayer.getColumnCount();
    }

    @Override
    public int getPreferredColumnCount() {
        return this.columnHeaderLayer.getPreferredColumnCount();
    }

    @Override
    public int getColumnIndexByPosition(int columnPosition) {
        return this.columnHeaderLayer.getColumnIndexByPosition(columnPosition);
    }

    @Override
    public int localToUnderlyingColumnPosition(int localColumnPosition) {
        return this.columnHeaderLayer.localToUnderlyingColumnPosition(localColumnPosition);
    }

    @Override
    public int underlyingToLocalColumnPosition(ILayer sourceUnderlyingLayer, int underlyingColumnPosition) {
        if (sourceUnderlyingLayer == this.columnHeaderLayer) {
            return underlyingColumnPosition;
        }
        return this.columnHeaderLayer.underlyingToLocalColumnPosition(sourceUnderlyingLayer, underlyingColumnPosition);
    }

    @Override
    public Collection<Range> underlyingToLocalColumnPositions(ILayer sourceUnderlyingLayer, Collection<Range> underlyingColumnPositionRanges) {
        if (sourceUnderlyingLayer == this.columnHeaderLayer) {
            return underlyingColumnPositionRanges;
        }
        return this.columnHeaderLayer.underlyingToLocalColumnPositions(sourceUnderlyingLayer, underlyingColumnPositionRanges);
    }

    @Override
    public int getWidth() {
        return this.columnHeaderLayer.getWidth();
    }

    @Override
    public int getPreferredWidth() {
        return this.columnHeaderLayer.getPreferredWidth();
    }

    @Override
    public int getColumnWidthByPosition(int columnPosition) {
        return this.columnHeaderLayer.getColumnWidthByPosition(columnPosition);
    }

    @Override
    public boolean isColumnPositionResizable(int columnPosition) {
        return this.columnHeaderLayer.isColumnPositionResizable(columnPosition);
    }

    @Override
    public int getColumnPositionByX(int x) {
        return this.columnHeaderLayer.getColumnPositionByX(x);
    }

    @Override
    public int getStartXOfColumnPosition(int columnPosition) {
        return this.columnHeaderLayer.getStartXOfColumnPosition(columnPosition);
    }

    @Override
    public Collection<String> getProvidedLabels() {
        Collection<String> labels = super.getProvidedLabels();
        labels.add("FILTER_ROW");
        int i = 0;
        while (i < this.getColumnCount()) {
            labels.add(FILTER_ROW_COLUMN_LABEL_PREFIX + i);
            ++i;
        }
        return labels;
    }
}

