/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.performance.action;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.LayerCommandUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.ColumnPositionCoordinate;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.RowPositionCoordinate;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupUtils;
import org.eclipse.nebula.widgets.nattable.group.performance.ColumnGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.performance.GroupModel;
import org.eclipse.nebula.widgets.nattable.group.performance.command.ColumnGroupReorderEndCommand;
import org.eclipse.nebula.widgets.nattable.group.performance.command.ColumnGroupReorderStartCommand;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.reorder.action.ColumnReorderDragMode;
import org.eclipse.nebula.widgets.nattable.reorder.command.ColumnReorderEndCommand;
import org.eclipse.nebula.widgets.nattable.reorder.command.ColumnReorderStartCommand;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.command.ClearAllSelectionsCommand;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeDetectUtil;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeEnum;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class ColumnGroupHeaderReorderDragMode
extends ColumnReorderDragMode {
    protected final ColumnGroupHeaderLayer columnGroupHeaderLayer;
    protected int level;
    protected int dragFromGridRowPosition;

    public ColumnGroupHeaderReorderDragMode(ColumnGroupHeaderLayer columnGroupHeaderLayer) {
        this.columnGroupHeaderLayer = columnGroupHeaderLayer;
    }

    @Override
    public void mouseDown(NatTable natTable, MouseEvent event) {
        this.natTable = natTable;
        this.currentEvent = this.initialEvent = event;
        this.dragFromGridColumnPosition = this.natTable.getColumnPositionByX(this.initialEvent.x);
        this.dragFromGridRowPosition = this.natTable.getRowPositionByY(this.initialEvent.y);
        RowPositionCoordinate convertedRow = LayerCommandUtil.convertRowPositionToTargetContext(new RowPositionCoordinate(natTable, this.dragFromGridRowPosition), this.columnGroupHeaderLayer);
        ColumnPositionCoordinate convertedColumn = LayerCommandUtil.convertColumnPositionToTargetContext(new ColumnPositionCoordinate(natTable, this.dragFromGridColumnPosition), this.columnGroupHeaderLayer);
        this.calculateLevel(convertedRow.getRowPosition(), convertedColumn.getColumnPosition());
        natTable.addOverlayPainter(this.targetOverlayPainter);
        natTable.doCommand(new ClearAllSelectionsCommand());
        this.fireMoveStartCommand(natTable, this.dragFromGridColumnPosition);
    }

    @Override
    protected boolean isValidTargetColumnPosition(ILayer natLayer, int fromGridColumnPosition, int toGridColumnPosition) {
        if (!this.columnGroupHeaderLayer.isReorderSupportedOnLevel(this.level)) {
            return false;
        }
        if (this.currentEvent != null) {
            CellEdgeEnum moveDirection = this.getMoveDirection(this.currentEvent.x);
            toGridColumnPosition = this.getDragToGridColumnPosition(moveDirection, this.natTable.getColumnPositionByX(this.currentEvent.x));
        }
        int toPosition = LayerUtil.convertColumnPosition(natLayer, toGridColumnPosition, this.columnGroupHeaderLayer.getPositionLayer());
        int fromPosition = this.columnGroupHeaderLayer.getReorderFromColumnPosition();
        if (this.level >= 0) {
            GroupModel model;
            int lvl = this.level + 1;
            while (lvl < this.columnGroupHeaderLayer.getLevelCount()) {
                model = this.columnGroupHeaderLayer.getGroupModel(lvl);
                if (model.isPartOfAnUnbreakableGroup(fromPosition)) {
                    SelectionLayer.MoveDirectionEnum moveDirection;
                    int toCheck = toPosition;
                    toCheck = toPosition < 0 && toGridColumnPosition == natLayer.getColumnCount() ? LayerUtil.convertColumnPosition(natLayer, toGridColumnPosition - 1, this.columnGroupHeaderLayer.getPositionLayer()) : (SelectionLayer.MoveDirectionEnum.RIGHT == (moveDirection = PositionUtil.getHorizontalMoveDirection(fromPosition, toCheck)) ? toCheck - 1 : toCheck);
                    return ColumnGroupUtils.isInTheSameGroup(this.columnGroupHeaderLayer, lvl, fromPosition, toCheck);
                }
                ++lvl;
            }
            lvl = this.level + 1;
            while (lvl < this.columnGroupHeaderLayer.getLevelCount()) {
                model = this.columnGroupHeaderLayer.getGroupModel(lvl);
                boolean betweenTwoGroups = false;
                if (this.currentEvent != null) {
                    int minX = this.currentEvent.x - 4;
                    int maxX = this.currentEvent.x + 4;
                    betweenTwoGroups = ColumnGroupUtils.isBetweenTwoGroups(natLayer, minX, maxX, this.columnGroupHeaderLayer, lvl);
                }
                if (!betweenTwoGroups && model.isPartOfAnUnbreakableGroup(toPosition)) {
                    return false;
                }
                ++lvl;
            }
            return ColumnGroupUtils.isBetweenTwoGroups(this.columnGroupHeaderLayer, this.level, toPosition, toPosition < this.columnGroupHeaderLayer.getColumnCount(), PositionUtil.getHorizontalMoveDirection(fromGridColumnPosition, toGridColumnPosition));
        }
        int level = 0;
        while (level < this.columnGroupHeaderLayer.getLevelCount()) {
            if (!this.isValidTargetColumnPosition(natLayer, fromGridColumnPosition, toGridColumnPosition, level, fromPosition, toPosition)) {
                return false;
            }
            ++level;
        }
        return true;
    }

    protected boolean isValidTargetColumnPosition(ILayer natLayer, int fromGridColumnPosition, int toGridColumnPosition, int level, int fromPosition, int toPosition) {
        GroupModel model = this.columnGroupHeaderLayer.getGroupModel(level);
        if (model.isPartOfAnUnbreakableGroup(fromPosition) && model.getGroupByPosition(fromPosition).getOriginalSpan() > 1) {
            SelectionLayer.MoveDirectionEnum moveDirection;
            int toCheck = toPosition;
            toCheck = toPosition < 0 && toGridColumnPosition == natLayer.getColumnCount() ? LayerUtil.convertColumnPosition(natLayer, toGridColumnPosition - 1, this.columnGroupHeaderLayer.getPositionLayer()) : (SelectionLayer.MoveDirectionEnum.RIGHT == (moveDirection = PositionUtil.getHorizontalMoveDirection(fromPosition, toCheck)) ? toCheck - 1 : toCheck);
            return ColumnGroupUtils.isInTheSameGroup(this.columnGroupHeaderLayer, level, fromPosition, toCheck);
        }
        boolean betweenTwoGroups = false;
        if (this.currentEvent != null) {
            int minX = this.currentEvent.x - 4;
            int maxX = this.currentEvent.x + 4;
            betweenTwoGroups = ColumnGroupUtils.isBetweenTwoGroups(natLayer, minX, maxX, this.columnGroupHeaderLayer, level);
        }
        return betweenTwoGroups || !model.isPartOfAnUnbreakableGroup(toPosition);
    }

    @Override
    protected void fireMoveStartCommand(NatTable natTable, int dragFromGridColumnPosition) {
        if (this.level >= 0) {
            natTable.doCommand(new ColumnGroupReorderStartCommand(natTable, this.level, dragFromGridColumnPosition));
        } else {
            natTable.doCommand(new ColumnReorderStartCommand(natTable, dragFromGridColumnPosition));
        }
    }

    @Override
    protected void fireMoveEndCommand(NatTable natTable, int dragToGridColumnPosition) {
        if (this.level >= 0) {
            natTable.doCommand(new ColumnGroupReorderEndCommand(natTable, this.level, dragToGridColumnPosition));
        } else {
            natTable.doCommand(new ColumnReorderEndCommand(natTable, dragToGridColumnPosition));
        }
    }

    @Override
    protected CellEdgeEnum getMoveDirection(int x) {
        ILayerCell cell = this.getColumnCell(x);
        if (cell != null) {
            Rectangle selectedColumnHeaderRect = cell.getBounds();
            return CellEdgeDetectUtil.getHorizontalCellEdge(selectedColumnHeaderRect, new Point(x, this.natTable.getStartYOfRowPosition(this.dragFromGridRowPosition)));
        }
        return null;
    }

    @Override
    protected ILayerCell getColumnCell(int x) {
        int gridColumnPosition = this.natTable.getColumnPositionByX(x);
        return this.natTable.getCellByPosition(gridColumnPosition, this.dragFromGridRowPosition);
    }

    protected void calculateLevel(int rowPosition, int columnPosition) {
        this.level = this.columnGroupHeaderLayer.getLevelForRowPosition(rowPosition);
        GroupModel.Group group = this.columnGroupHeaderLayer.getGroupByPosition(this.level, columnPosition);
        while (group == null && this.level > 0) {
            --this.level;
            ++this.dragFromGridRowPosition;
            group = this.columnGroupHeaderLayer.getGroupByPosition(this.level, columnPosition);
        }
        if (group == null) {
            this.level = -1;
            this.dragFromGridRowPosition = this.columnGroupHeaderLayer.getRowCount() - 1;
        }
    }
}

