/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api.bimap;

import org.eclipse.collections.api.bag.ImmutableBagIterable;
import org.eclipse.collections.api.bimap.BiMap;
import org.eclipse.collections.api.bimap.MutableBiMap;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.factory.BiMaps;
import org.eclipse.collections.api.map.ImmutableMapIterable;
import org.eclipse.collections.api.multimap.set.ImmutableSetMultimap;
import org.eclipse.collections.api.partition.set.PartitionImmutableSet;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.tuple.Pair;

public interface ImmutableBiMap<K, V>
extends BiMap<K, V>,
ImmutableMapIterable<K, V> {
    @Override
    public ImmutableBiMap<K, V> newWithKeyValue(K var1, V var2);

    @Override
    public ImmutableBiMap<K, V> newWithAllKeyValues(Iterable<? extends Pair<? extends K, ? extends V>> var1);

    @Override
    public ImmutableBiMap<K, V> newWithAllKeyValueArguments(Pair<? extends K, ? extends V> ... var1);

    @Override
    public ImmutableBiMap<K, V> newWithoutKey(K var1);

    @Override
    public ImmutableBiMap<K, V> newWithoutAllKeys(Iterable<? extends K> var1);

    @Override
    public ImmutableBiMap<V, K> inverse();

    @Override
    public ImmutableSetMultimap<V, K> flip();

    @Override
    public ImmutableBiMap<V, K> flipUniqueValues();

    @Override
    public ImmutableBiMap<K, V> tap(Procedure<? super V> var1);

    @Override
    public ImmutableBiMap<K, V> select(Predicate2<? super K, ? super V> var1);

    @Override
    public ImmutableBiMap<K, V> reject(Predicate2<? super K, ? super V> var1);

    @Override
    public <K2, V2> ImmutableBiMap<K2, V2> collect(Function2<? super K, ? super V, Pair<K2, V2>> var1);

    @Override
    public <R> ImmutableBiMap<K, R> collectValues(Function2<? super K, ? super V, ? extends R> var1);

    @Override
    public ImmutableSet<V> select(Predicate<? super V> var1);

    @Override
    public <P> ImmutableSet<V> selectWith(Predicate2<? super V, ? super P> var1, P var2);

    @Override
    public ImmutableSet<V> reject(Predicate<? super V> var1);

    @Override
    public <P> ImmutableSet<V> rejectWith(Predicate2<? super V, ? super P> var1, P var2);

    @Override
    public PartitionImmutableSet<V> partition(Predicate<? super V> var1);

    @Override
    public <P> PartitionImmutableSet<V> partitionWith(Predicate2<? super V, ? super P> var1, P var2);

    @Override
    public <S> ImmutableSet<S> selectInstancesOf(Class<S> var1);

    @Override
    public <V1> ImmutableBagIterable<V1> collect(Function<? super V, ? extends V1> var1);

    @Override
    public <P, V1> ImmutableBagIterable<V1> collectWith(Function2<? super V, ? super P, ? extends V1> var1, P var2);

    @Override
    public <V1> ImmutableBagIterable<V1> collectIf(Predicate<? super V> var1, Function<? super V, ? extends V1> var2);

    @Override
    public <V1> ImmutableBagIterable<V1> flatCollect(Function<? super V, ? extends Iterable<V1>> var1);

    @Override
    default public <P, V1> ImmutableBagIterable<V1> flatCollectWith(Function2<? super V, ? super P, ? extends Iterable<V1>> function, P parameter) {
        return this.flatCollect((T each) -> (Iterable)function.apply((Object)each, (Object)parameter));
    }

    @Override
    public <V1> ImmutableSetMultimap<V1, V> groupBy(Function<? super V, ? extends V1> var1);

    @Override
    public <V1> ImmutableSetMultimap<V1, V> groupByEach(Function<? super V, ? extends Iterable<V1>> var1);

    @Override
    default public <VV> ImmutableBiMap<VV, V> groupByUniqueKey(Function<? super V, ? extends VV> function) {
        MutableBiMap target = BiMaps.mutable.empty();
        return this.groupByUniqueKey(function, target).toImmutable();
    }

    @Override
    @Deprecated
    public <S> ImmutableSet<Pair<V, S>> zip(Iterable<S> var1);

    @Override
    @Deprecated
    public ImmutableSet<Pair<V, Integer>> zipWithIndex();
}

