/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.performance.command;

import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.group.RowGroupUtils;
import org.eclipse.nebula.widgets.nattable.group.performance.GroupModel;
import org.eclipse.nebula.widgets.nattable.group.performance.RowGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.reorder.command.RowReorderEndCommand;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;

public class GroupRowReorderEndCommandHandler
extends AbstractLayerCommandHandler<RowReorderEndCommand> {
    private final RowGroupHeaderLayer rowGroupHeaderLayer;

    public GroupRowReorderEndCommandHandler(RowGroupHeaderLayer rowGroupHeaderLayer) {
        this.rowGroupHeaderLayer = rowGroupHeaderLayer;
    }

    @Override
    protected boolean doCommand(RowReorderEndCommand command) {
        boolean reorderToTopEdge;
        int toRowPosition;
        int fromRowPosition = this.rowGroupHeaderLayer.getReorderFromRowPosition();
        boolean isValid = RowGroupUtils.isReorderValid(this.rowGroupHeaderLayer, fromRowPosition, toRowPosition = command.getToRowPosition(), reorderToTopEdge = command.isReorderToTopEdge());
        if (isValid) {
            int fromIndex = this.rowGroupHeaderLayer.getPositionLayer().getRowIndexByPosition(fromRowPosition);
            int toIndex = this.rowGroupHeaderLayer.getPositionLayer().getRowIndexByPosition(toRowPosition);
            SelectionLayer.MoveDirectionEnum moveDirection = PositionUtil.getVerticalMoveDirection(fromRowPosition, toRowPosition);
            boolean updateToPosition = false;
            int level = 0;
            while (level < this.rowGroupHeaderLayer.getLevelCount()) {
                int toPositionToCheck = toRowPosition;
                if (SelectionLayer.MoveDirectionEnum.DOWN == moveDirection && reorderToTopEdge) {
                    --toPositionToCheck;
                }
                GroupModel.Group fromGroup = this.rowGroupHeaderLayer.getGroupByPosition(level, fromRowPosition);
                GroupModel.Group toGroup = this.rowGroupHeaderLayer.getGroupByPosition(level, toPositionToCheck);
                if (fromGroup != null) {
                    if (fromGroup.isCollapsed() && (!RowGroupUtils.isInTheSameGroup(this.rowGroupHeaderLayer, level, fromRowPosition, toPositionToCheck) || fromRowPosition == toPositionToCheck)) {
                        this.rowGroupHeaderLayer.expandGroup(this.rowGroupHeaderLayer.getGroupModel(level), fromGroup);
                        updateToPosition = true;
                    } else if (SelectionLayer.MoveDirectionEnum.DOWN == moveDirection && fromGroup.isGroupEnd(toPositionToCheck)) {
                        command.toggleCoordinateByEdge();
                    }
                } else if (toGroup != null && SelectionLayer.MoveDirectionEnum.DOWN == moveDirection && toGroup.isGroupEnd(toPositionToCheck)) {
                    command.toggleCoordinateByEdge();
                }
                ++level;
            }
            if (updateToPosition) {
                if (moveDirection != SelectionLayer.MoveDirectionEnum.DOWN) {
                    this.rowGroupHeaderLayer.setReorderFromRowPosition(this.rowGroupHeaderLayer.getPositionLayer().getRowPositionByIndex(fromIndex));
                } else {
                    command.updateToRowPosition(this.rowGroupHeaderLayer.getPositionLayer().getRowPositionByIndex(toIndex));
                }
            }
        }
        return !isValid;
    }

    @Override
    public Class<RowReorderEndCommand> getCommandClass() {
        return RowReorderEndCommand.class;
    }
}

