/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.tree.GlazedListTreeData;
import org.eclipse.nebula.widgets.nattable.tree.ITreeRowModel;
import org.eclipse.nebula.widgets.nattable.tree.ITreeRowModelListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlazedListTreeRowModel<T>
implements ITreeRowModel<T> {
    private final Collection<ITreeRowModelListener> listeners = new HashSet<ITreeRowModelListener>();
    private final GlazedListTreeData<T> treeData;

    public GlazedListTreeRowModel(GlazedListTreeData<T> treeData) {
        this.treeData = treeData;
    }

    public void registerRowGroupModelListener(ITreeRowModelListener listener) {
        this.listeners.add(listener);
    }

    public void notifyListeners() {
        for (ITreeRowModelListener listener : this.listeners) {
            listener.treeRowModelChanged();
        }
    }

    public int depth(int index) {
        return this.treeData.getDepthOfData(this.treeData.getDataAtIndex(index));
    }

    public boolean isLeaf(int index) {
        return !this.hasChildren(index);
    }

    public String getObjectAtIndexAndDepth(int index, int depth) {
        return this.treeData.formatDataForDepth(depth, index);
    }

    public boolean hasChildren(int index) {
        return this.treeData.hasChildren(index);
    }

    public boolean isCollapsed(int index) {
        return !this.treeData.isExpanded(index);
    }

    public void clear() {
    }

    public boolean isCollapseable(int index) {
        return this.hasChildren(index);
    }

    public List<Integer> collapse(int index) {
        this.treeData.collapse(index);
        this.notifyListeners();
        return new ArrayList<Integer>();
    }

    public List<Integer> expand(int index) {
        this.treeData.expand(index);
        this.notifyListeners();
        return new ArrayList<Integer>();
    }

    public List<Integer> getChildIndexes(int parentIndex) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        List<T> children = this.treeData.getChildren(parentIndex);
        for (T child : children) {
            int index = this.treeData.indexOf(child);
            result.add(index);
            result.addAll(this.getChildIndexes(index));
        }
        return result;
    }
}

