/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.ui.menu;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.AbstractUiBindingConfiguration;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuAction;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuBuilder;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Menu;

public class HeaderMenuConfiguration
extends AbstractUiBindingConfiguration {
    private Menu colHeaderMenu;
    private Menu rowHeaderMenu;

    public HeaderMenuConfiguration(NatTable natTable) {
        this.colHeaderMenu = this.createColumnHeaderMenu(natTable).build();
        this.rowHeaderMenu = this.createRowHeaderMenu(natTable).build();
        natTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                HeaderMenuConfiguration.this.colHeaderMenu.dispose();
                HeaderMenuConfiguration.this.rowHeaderMenu.dispose();
            }
        });
    }

    protected PopupMenuBuilder createColumnHeaderMenu(NatTable natTable) {
        return new PopupMenuBuilder(natTable).withHideColumnMenuItem().withShowAllColumnsMenuItem().withCreateColumnGroupsMenuItem().withUngroupColumnsMenuItem().withAutoResizeSelectedColumnsMenuItem().withColumnStyleEditor().withColumnRenameDialog().withClearAllFilters();
    }

    protected PopupMenuBuilder createRowHeaderMenu(NatTable natTable) {
        return new PopupMenuBuilder(natTable).withAutoResizeSelectedRowsMenuItem();
    }

    public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
        uiBindingRegistry.registerMouseDownBinding(new MouseEventMatcher(0, "COLUMN_HEADER", 3), new PopupMenuAction(this.colHeaderMenu));
        uiBindingRegistry.registerMouseDownBinding(new MouseEventMatcher(0, "ROW_HEADER", 3), new PopupMenuAction(this.rowHeaderMenu));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MenuOptions {
        HideColumn,
        ShowColumn;

    }
}

