/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.tickupdate;

public interface ITickUpdateHandler {
    public static final ITickUpdateHandler DEFAULT_TICK_UPDATE_HANDLER = new ITickUpdateHandler(){

        public boolean isApplicableFor(Object value) {
            return value instanceof Number;
        }

        public Object getDecrementedValue(Object currentValue) {
            return this.getIncrementedValue(currentValue, 1.0);
        }

        public Object getIncrementedValue(Object currentValue, double incrementSize) {
            Number oldValue = (Number)currentValue;
            return oldValue.doubleValue() + Math.abs(incrementSize);
        }

        public Object getIncrementedValue(Object currentValue) {
            return this.getDecrementedValue(currentValue, 1.0);
        }

        public Object getDecrementedValue(Object currentValue, double decrementSize) {
            Number oldValue = (Number)currentValue;
            return oldValue.doubleValue() - Math.abs(decrementSize);
        }
    };

    public boolean isApplicableFor(Object var1);

    public Object getIncrementedValue(Object var1);

    public Object getIncrementedValue(Object var1, double var2);

    public Object getDecrementedValue(Object var1);

    public Object getDecrementedValue(Object var1, double var2);
}

