/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer.event;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.RowStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralDiff;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RowInsertEvent
extends RowStructuralChangeEvent {
    public RowInsertEvent(ILayer layer, int rowPosition) {
        this(layer, new Range(rowPosition, rowPosition + 1));
    }

    public RowInsertEvent(ILayer layer, Range rowPositionRange) {
        super(layer, rowPositionRange);
    }

    public RowInsertEvent(RowInsertEvent event) {
        super(event);
    }

    @Override
    public RowInsertEvent cloneEvent() {
        return new RowInsertEvent(this);
    }

    @Override
    public Collection<StructuralDiff> getRowDiffs() {
        ArrayList<StructuralDiff> rowDiffs = new ArrayList<StructuralDiff>();
        for (Range range : this.getRowPositionRanges()) {
            new StructuralDiff(StructuralDiff.DiffTypeEnum.ADD, new Range(range.start, range.start), range);
        }
        return rowDiffs;
    }
}

