/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer.cell;

import java.io.Serializable;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.data.IRowIdAccessor;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.AbstractOverrider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RowOverrideLabelAccumulator<T>
extends AbstractOverrider {
    private IRowDataProvider<T> dataProvider;
    private IRowIdAccessor<T> idAccessor;

    public RowOverrideLabelAccumulator(IRowDataProvider<T> dataProvider, IRowIdAccessor<T> idAccessor) {
        this.dataProvider = dataProvider;
        this.idAccessor = idAccessor;
    }

    @Override
    public void accumulateConfigLabels(LabelStack configLabels, int columnPosition, int rowPosition) {
        T rowObject = this.dataProvider.getRowObject(rowPosition);
        Serializable rowId = this.idAccessor.getRowId(rowObject);
        List<String> overrides = this.getOverrides(rowId);
        if (overrides != null) {
            for (String configLabel : overrides) {
                configLabels.addLabel(configLabel);
            }
        }
    }

    public void registerOverrides(int rowIndex, String ... configLabels) {
        Serializable id = this.idAccessor.getRowId(this.dataProvider.getRowObject(rowIndex));
        this.registerOverrides(id, configLabels);
    }
}

