/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer;

import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;

public class ZoomLayer
extends AbstractLayerTransform {
    private float zoomFactor = 1.0f;

    public ZoomLayer(ILayer underlyingILayer) {
        super(underlyingILayer);
    }

    public float getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(float zoomFactor) {
        this.zoomFactor = zoomFactor;
    }

    public int getWidth() {
        return (int)(this.zoomFactor * (float)super.getWidth());
    }

    public int getPreferredWidth() {
        return (int)(this.zoomFactor * (float)super.getPreferredWidth());
    }

    public int getColumnWidthByPosition(int columnPosition) {
        return (int)(this.zoomFactor * (float)super.getColumnWidthByPosition(columnPosition));
    }

    public int getColumnPositionByX(int x) {
        return super.getColumnPositionByX((int)((float)x / this.zoomFactor));
    }

    public int getStartXOfColumnPosition(int columnPosition) {
        return (int)(this.zoomFactor * (float)super.getStartXOfColumnPosition(columnPosition));
    }

    public int getHeight() {
        return (int)(this.zoomFactor * (float)super.getHeight());
    }

    public int getPreferredHeight() {
        return (int)(this.zoomFactor * (float)super.getPreferredHeight());
    }

    public int getRowHeightByPosition(int rowPosition) {
        return (int)(this.zoomFactor * (float)super.getRowHeightByPosition(rowPosition));
    }

    public int getRowPositionByY(int y) {
        return super.getRowPositionByY((int)((float)y / this.zoomFactor));
    }

    public int getStartYOfRowPosition(int rowPosition) {
        return (int)(this.zoomFactor * (float)super.getStartYOfRowPosition(rowPosition));
    }

    public LabelStack getRegionLabelsByXY(int x, int y) {
        return super.getRegionLabelsByXY((int)((float)x / this.zoomFactor), (int)((float)y / this.zoomFactor));
    }
}

