/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.command;

import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupModel;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupReorderLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupUtils;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.reorder.command.ColumnReorderCommand;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupColumnReorderCommandHandler
extends AbstractLayerCommandHandler<ColumnReorderCommand> {
    private final ColumnGroupReorderLayer columnGroupReorderLayer;
    private final ColumnGroupModel model;

    public GroupColumnReorderCommandHandler(ColumnGroupReorderLayer columnGroupReorderLayer) {
        this.columnGroupReorderLayer = columnGroupReorderLayer;
        this.model = columnGroupReorderLayer.getModel();
    }

    @Override
    public Class<ColumnReorderCommand> getCommandClass() {
        return ColumnReorderCommand.class;
    }

    @Override
    protected boolean doCommand(ColumnReorderCommand command) {
        int fromColumnPosition = command.getFromColumnPosition();
        int toColumnPosition = command.getToColumnPosition();
        if (fromColumnPosition == -1 || toColumnPosition == -1) {
            System.err.println("Invalid reorder positions, fromPosition: " + fromColumnPosition + ", toPosition: " + toColumnPosition);
        }
        ILayer underlyingLayer = this.columnGroupReorderLayer.getUnderlyingLayer();
        int fromColumnIndex = underlyingLayer.getColumnIndexByPosition(fromColumnPosition);
        int toColumnIndex = underlyingLayer.getColumnIndexByPosition(toColumnPosition);
        SelectionLayer.MoveDirectionEnum moveDirection = ColumnGroupUtils.getMoveDirection(fromColumnPosition, toColumnPosition);
        String leftEdgeGroupName = null;
        String rightEdgeGroupName = null;
        if (SelectionLayer.MoveDirectionEnum.RIGHT == moveDirection) {
            rightEdgeGroupName = this.movedToLeftEdgeOfAGroup(toColumnPosition, toColumnIndex);
        }
        if (SelectionLayer.MoveDirectionEnum.LEFT == moveDirection) {
            leftEdgeGroupName = this.movedToRightEdgeOfAGroup(toColumnPosition, toColumnIndex);
        }
        if (this.updateModel(fromColumnIndex, toColumnIndex, leftEdgeGroupName, rightEdgeGroupName)) {
            return underlyingLayer.doCommand(command);
        }
        return false;
    }

    private boolean updateModel(int fromColumnIndex, int toColumnIndex, String leftEdgeGroupName, String rightEdgeGroupName) {
        ColumnGroupModel.ColumnGroup fromColumnGroup = this.model.getColumnGroupByIndex(fromColumnIndex);
        ColumnGroupModel.ColumnGroup toColumnGroup = this.model.getColumnGroupByIndex(toColumnIndex);
        if (rightEdgeGroupName != null) {
            return this.model.isPartOfAGroup(fromColumnIndex) ? fromColumnGroup.removeColumn(fromColumnIndex) : true;
        }
        if (leftEdgeGroupName != null) {
            boolean removed = true;
            if (this.model.isPartOfAGroup(fromColumnIndex)) {
                removed = fromColumnGroup.removeColumn(fromColumnIndex);
            }
            return removed && this.model.insertColumnIndexes(leftEdgeGroupName, fromColumnIndex);
        }
        if (this.model.isPartOfAGroup(toColumnIndex) && !this.model.isPartOfAGroup(fromColumnIndex)) {
            String groupName = toColumnGroup.getName();
            return this.model.insertColumnIndexes(groupName, fromColumnIndex);
        }
        if (this.model.isPartOfAGroup(fromColumnIndex) && !this.model.isPartOfAGroup(toColumnIndex)) {
            return fromColumnGroup.removeColumn(fromColumnIndex);
        }
        if (this.model.isPartOfAGroup(toColumnIndex) && this.model.isPartOfAGroup(fromColumnIndex)) {
            String toGroupName = toColumnGroup.getName();
            String fromGroupName = fromColumnGroup.getName();
            if (fromGroupName.equals(toGroupName)) {
                return true;
            }
            return fromColumnGroup.removeColumn(fromColumnIndex) && this.model.insertColumnIndexes(toGroupName, fromColumnIndex);
        }
        return true;
    }

    private String movedToRightEdgeOfAGroup(int dropColumnPosition, int dropColumnIndex) {
        if (ColumnGroupUtils.isRightEdgeOfAColumnGroup(this.columnGroupReorderLayer, dropColumnPosition, dropColumnIndex, this.model)) {
            return this.model.getColumnGroupByIndex(dropColumnIndex).getName();
        }
        return null;
    }

    private String movedToLeftEdgeOfAGroup(int dropColumnPosition, int dropColumnIndex) {
        if (ColumnGroupUtils.isLeftEdgeOfAColumnGroup(this.columnGroupReorderLayer, dropColumnPosition, dropColumnIndex, this.model)) {
            return this.model.getColumnGroupByIndex(dropColumnIndex).getName();
        }
        return null;
    }
}

