/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.edit.editor;

import org.eclipse.nebula.widgets.nattable.edit.config.RenderErrorHandling;
import org.eclipse.nebula.widgets.nattable.edit.editor.AbstractCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.ControlDecorationProvider;
import org.eclipse.nebula.widgets.nattable.edit.editor.EditorSelectionEnum;
import org.eclipse.nebula.widgets.nattable.edit.editor.IEditErrorHandler;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.widget.EditModeEnum;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public class TextCellEditor
extends AbstractCellEditor {
    private EditorSelectionEnum selectionMode = EditorSelectionEnum.ALL;
    private Text text = null;
    private boolean editable = true;
    private final boolean commitOnUpOrDownCursorKeyPress;
    protected final ControlDecorationProvider decorationProvider = new ControlDecorationProvider();
    private IEditErrorHandler inputConversionErrorHandler = new RenderErrorHandling(this.decorationProvider);
    private IEditErrorHandler inputValidationErrorHandler = new RenderErrorHandling(this.decorationProvider);

    public TextCellEditor() {
        this(false);
    }

    public TextCellEditor(boolean commitOnUpOrDownCursorKeyPress) {
        this.commitOnUpOrDownCursorKeyPress = commitOnUpOrDownCursorKeyPress;
    }

    public Text getTextControl() {
        return this.text;
    }

    public ControlDecorationProvider getDecorationProvider() {
        return this.decorationProvider;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public final void setSelectionMode(EditorSelectionEnum selectionMode) {
        this.selectionMode = selectionMode;
    }

    public final EditorSelectionEnum getSelectionMode() {
        return this.selectionMode;
    }

    protected Control activateCell(Composite parent, Object originalCanonicalValue, Character initialEditValue) {
        this.text = this.createTextControl(parent);
        this.text.setCursor(new Cursor((Device)Display.getDefault(), 19));
        if (initialEditValue != null) {
            this.selectionMode = EditorSelectionEnum.END;
            this.text.setText(initialEditValue.toString());
            this.selectText();
        } else {
            this.setCanonicalValue(originalCanonicalValue);
        }
        if (!this.isEditable()) {
            this.text.setEditable(false);
        }
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 13 && event.stateMask == 0 || event.keyCode == 0x1000050 && event.stateMask == 0) {
                    TextCellEditor.this.commit(SelectionLayer.MoveDirectionEnum.NONE);
                } else if (event.keyCode == 27 && event.stateMask == 0) {
                    TextCellEditor.this.close();
                } else if (TextCellEditor.this.commitOnUpOrDownCursorKeyPress && TextCellEditor.this.editMode == EditModeEnum.INLINE) {
                    if (event.keyCode == 0x1000001) {
                        TextCellEditor.this.commit(SelectionLayer.MoveDirectionEnum.UP);
                    } else if (event.keyCode == 0x1000002) {
                        TextCellEditor.this.commit(SelectionLayer.MoveDirectionEnum.DOWN);
                    }
                }
            }
        });
        this.text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                boolean committed = false;
                if (event.keyCode == 9 && event.stateMask == 131072) {
                    committed = TextCellEditor.this.commit(SelectionLayer.MoveDirectionEnum.LEFT);
                } else if (event.keyCode == 9 && event.stateMask == 0) {
                    committed = TextCellEditor.this.commit(SelectionLayer.MoveDirectionEnum.RIGHT);
                }
                if (!committed) {
                    event.doit = false;
                }
            }
        });
        this.decorationProvider.createErrorDecorationIfRequired((Control)this.text);
        this.text.forceFocus();
        return this.text;
    }

    private void selectText() {
        int textLength = this.text.getText().length();
        if (textLength > 0) {
            EditorSelectionEnum selectionMode = this.getSelectionMode();
            if (selectionMode == EditorSelectionEnum.ALL) {
                this.text.setSelection(0, textLength);
            } else if (selectionMode == EditorSelectionEnum.END) {
                this.text.setSelection(textLength, textLength);
            }
        }
    }

    public void setErrorDecorationEnabled(boolean enabled) {
        this.decorationProvider.setErrorDecorationEnabled(enabled);
    }

    public void setErrorDecorationText(String errorText) {
        this.decorationProvider.setErrorDecorationText(errorText);
    }

    public void showErrorDecorationHover(String customErrorText) {
        this.decorationProvider.showErrorDecorationHover(customErrorText);
    }

    public void setDecorationPositionOverride(int decorationPositionOverride) {
        this.decorationProvider.setDecorationPositionOverride(decorationPositionOverride);
    }

    protected Text createTextControl(Composite parent) {
        IStyle cellStyle = this.getCellStyle();
        Text textControl = new Text(parent, HorizontalAlignmentEnum.getSWTStyle(cellStyle));
        textControl.setBackground(cellStyle.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR));
        textControl.setForeground(cellStyle.getAttributeValue(CellStyleAttributes.FOREGROUND_COLOR));
        textControl.setFont(cellStyle.getAttributeValue(CellStyleAttributes.FONT));
        textControl.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                TextCellEditor.this.validateCanonicalValue(TextCellEditor.this.inputConversionErrorHandler, TextCellEditor.this.inputValidationErrorHandler);
            }
        });
        return textControl;
    }

    public Object getCanonicalValue() {
        return this.getDataTypeConverter().displayToCanonicalValue(this.layerCell, this.configRegistry, this.text.getText());
    }

    public void setCanonicalValue(Object canonicalValue) {
        String displayValue = (String)this.getDataTypeConverter().canonicalToDisplayValue(this.layerCell, this.configRegistry, canonicalValue);
        this.text.setText(displayValue != null && displayValue.length() > 0 ? displayValue.toString() : "");
        this.selectText();
    }

    public void close() {
        super.close();
        if (this.text != null && !this.text.isDisposed()) {
            this.text.dispose();
        }
        this.decorationProvider.dispose();
    }

    protected final Text getTextWidget() {
        return this.text;
    }

    public IEditErrorHandler getInputConversionErrorHandler() {
        return this.inputConversionErrorHandler;
    }

    public void setInputConversionErrorHandler(IEditErrorHandler inputConversionErrorHandler) {
        this.inputConversionErrorHandler = inputConversionErrorHandler;
    }

    public IEditErrorHandler getInputValidationErrorHandler() {
        return this.inputValidationErrorHandler;
    }

    public void setInputValidationErrorHandler(IEditErrorHandler inputValidationErrorHandler) {
        this.inputValidationErrorHandler = inputValidationErrorHandler;
    }
}

